#ifndef LOGCLASS_H
#define LOGCLASS_H

/* 
   logclass.h
   Class definitions of "Log" & "Filter" classes
   to be included by xlogmaster
*/

class Filter;

/*{{{  Modes for "Log" class  */
#define EMPTY 0
#define TAIL_FILE 1
#define RUN_FILE 2
#define CAT_FILE 3

#define NO_FILTER 0
#define CLASS0_FILTER 1<<1
#define CLASS1_FILTER 1<<2

#define ENABLED 0
#define DISABLED 1

#define ABOUT 1

/*}}}*/

class Log {
/*{{{  Functions  */
  friend Filter;
public:
  Log();
  ~Log();







/*}}}*/
/*{{{  Variables  */
public:
  int mode;                  // mode for opening the file / whatever it is
  int interval;              // interval to display things... only used for executing/catting stuff
  int fd;                       // filedescriptor for logfile
  char* buffer;             // buffer to store background reading
  char* rbuffer;            // buffer to do background reading in
  long chunk;               // chunksize during background reading (Class1 filters)
  long length;              // buffer length
  long got;                   // number of new bytes in buffer
  gint active;                 // whether the entry is active & has been activated properly
  // (we don't want interrupts crashing in during initialisation)
  off_t last_size;         // for memorizing how long the file was at last interrupt...
  gdouble fade;               // fading (in percent) between alert and normal
  gdouble last_fade;       // last fading...
  gdouble fadestep;            // fading direction

  /* String variables */
  char *filename;          // where to find it
  char *help;                 // helptext to display when holding mouse over button
  char *buttontext;       // text of button itself
  char **commandline;  // commandline parameters for executable
  
  /* GTK toolkit based variables */
  GtkWidget *button;  
  gint tag; 
  gint wd_tag;
  gint alert_tag;
  // Color stunts:
  GtkStyle* style;
  gulong pixels[2];            // IDs of the current alert-colors...
  /* Filtering things */
  Filter** filter;             // Pointer to NULL terminated list of pointers
  gint filterclass;           // highest class of filtering present
/*}}}*/
};

/*{{{  Modes for "Filter" class  */
#define NO_CHANGE 0
/* class0 filter definitions */
#define RAISE ( 1 << 0 )
#define LOWER ( 1 << 1 )
#define HIDE ( 1 << 2 )

#define CLASS0_MASK ( RAISE | LOWER | HIDE )

/* class1 filter definitions */
#define ALERT ( 1 << 4 )
#define NOTICE ( 1 << 5 )
#define UNICONIFY ( 1 << 6 )
#define EXECUTE ( 1 << 7 )

#define CLASS1_MASK ( ALERT | NOTICE | UNICONIFY | EXECUTE )

/*}}}*/

class Filter {
/*{{{  Functions  */
  friend Log;
public:
  Filter();
  ~Filter();

  init(const char* , gint);
  purge();




/*}}}*/
/*{{{  Variables  */
public:

  gchar* string;
  gchar* pattern;
  gchar* execline;

  gint mode;

/*}}}*/
};

#endif /* LOGCLASS_H */
