--
-- This file is part of TALER
-- Copyright (C) 2024 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE OR REPLACE FUNCTION purse_decision_insert_trigger()
  RETURNS trigger
  LANGUAGE plpgsql
  AS $$
BEGIN
  UPDATE exchange.purse_requests
     SET was_decided=TRUE
   WHERE purse_pub=NEW.purse_pub;
  IF NEW.refunded
  THEN
    INSERT INTO exchange.coin_history
      (coin_pub
      ,table_name
      ,serial_id)
    SELECT
      pd.coin_pub
     ,'purse_decision'
     ,NEW.purse_decision_serial_id
    FROM exchange.purse_deposits pd
    WHERE purse_pub = NEW.purse_pub;
  ELSE
    INSERT INTO exchange.reserve_history
      (reserve_pub
      ,table_name
      ,serial_id)
    SELECT
      reserve_pub
     ,'purse_decision'
     ,NEW.purse_decision_serial_id
    FROM exchange.purse_merges
    WHERE purse_pub=NEW.purse_pub;
  END IF;
  RETURN NEW;
END $$;
COMMENT ON FUNCTION purse_decision_insert_trigger()
  IS 'Automatically generate coin history entry and update decision status for the purse.';


