/*
     This file is part of GNU Taler
     Copyright (C) 2012-2021 Taler Systems SA

     GNU Taler is free software: you can redistribute it and/or modify it
     under the terms of the GNU Lesser General Public License as published
     by the Free Software Foundation, either version 3 of the License,
     or (at your option) any later version.

     GNU Taler is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     Lesser General Public License for more details.

     You should have received a copy of the GNU Lesser General Public License
     along with this program.  If not, see <http://www.gnu.org/licenses/>.

     SPDX-License-Identifier: LGPL3.0-or-later

     Note: the LGPL does not apply to all components of GNU Taler,
     but it does apply to this file.
 */
 /**
  * @file src/include/taler_dbevents.h
  * @brief GNU Taler database event types, generated via https://gana.gnunet.org/
  *
  * Do NOT edit this file, it is generated!
  */
#ifndef GNU_TALER_DBEVENTS_H
#define GNU_TALER_DBEVENTS_H

#ifdef __cplusplus
extern "C" {
#if 0 /* keep Emacsens' auto-indent happy */
}
#endif
#endif

#include <limits.h>


/**
 * Taler database event types.
 */
enum TALER_DbEventType
{


  /**
   * Event triggered when a reserve is funded via a bank transfer.
   */
  TALER_DBEVENT_EXCHANGE_RESERVE_INCOMING = 1000,


  /**
   * Event triggered when new online signing keys are activated via the management API.
   */
  TALER_DBEVENT_EXCHANGE_KEYS_UPDATED = 1001,


  /**
   * Event triggered when the wire response was changed via the management API.
   */
  TALER_DBEVENT_EXCHANGE_WIRE_UPDATED = 1002,


  /**
   * Event triggered when a user completed a KYC process.
   */
  TALER_DBEVENT_EXCHANGE_KYC_COMPLETED = 1003,


  /**
   * Event triggered when the configuration of an extension is updated.
   */
  TALER_DBEVENT_EXCHANGE_EXTENSIONS_UPDATED = 1004,


  /**
   * Event triggered when a purse was merged into a reserve.
   */
  TALER_DBEVENT_EXCHANGE_PURSE_MERGED = 1005,


  /**
   * Event triggered when coins are deposited into a purse.
   */
  TALER_DBEVENT_EXCHANGE_PURSE_DEPOSITED = 1006,


  /**
   * Event triggered when the tracking status for a deposit has changed.
   */
  TALER_DBEVENT_EXCHANGE_DEPOSIT_STATUS_CHANGED = 1007,


  /**
   * Event triggered when any purse was refunded.
   */
  TALER_DBEVENT_EXCHANGE_PURSE_REFUNDED = 1008,


  /**
   * Some instance setting was changed (new instance, deleted instance, change options)
   */
  TALER_DBEVENT_MERCHANT_INSTANCE_SETTINGS = 1100,


  /**
   * Event triggered when an order is paid by a customer.
   */
  TALER_DBEVENT_MERCHANT_ORDER_PAID = 1101,


  /**
   * Event triggered when a refund is approved by the backoffice staff.
   */
  TALER_DBEVENT_MERCHANT_ORDER_REFUND = 1102,


  /**
   * Event triggered when a fulfillment URL becomes paid for a particular session.
   */
  TALER_DBEVENT_MERCHANT_SESSION_CAPTURED = 1103,


  /**
   * Event triggered when a refund is obtained by a wallet.
   */
  TALER_DBEVENT_MERCHANT_REFUND_OBTAINED = 1104,


  /**
   * Event triggered when the set of orders or their state changes.
   */
  TALER_DBEVENT_MERCHANT_ORDERS_CHANGE = 1105,


  /**
   * Event triggered when a new pending webhook is ready to be run.
   */
  TALER_DBEVENT_MERCHANT_WEBHOOK_PENDING = 1106,


  /**
   * Event triggered when a reward is being picked up.
   */
  TALER_DBEVENT_MERCHANT_REWARD_PICKUP = 1107,


  /**
   * Event triggered when a wire transfer is confirmed. Triggers interaction with the exchange to download details about which payments were aggregated.
   */
  TALER_DBEVENT_MERCHANT_WIRE_TRANSFER_CONFIRMED = 1108,


  /**
   * Event triggered when the set of accounts has changed. Triggers restart of taler-merchant-wirewatch.
   */
  TALER_DBEVENT_MERCHANT_ACCOUNTS_CHANGED = 1109,


  /**
   * Event triggered when we downloaded "/keys" from an exchange and stored it in the database. Extra argument must be the exchange base URL.
   */
  TALER_DBEVENT_MERCHANT_EXCHANGE_KEYS = 1110,


  /**
   * Event triggered upon successful (batch) deposit. Notifies taler-merchant-depositcheck about a potentially relevant wire deadline to wake up for. Argument is a 64-bit absolute time in network byte order.
   */
  TALER_DBEVENT_MERCHANT_NEW_WIRE_DEADLINE = 1111,


  /**
   * Event triggered when there is a new deposit confirmation available.
   */
  TALER_DBEVENT_EXCHANGE_AUDITOR_NEW_DEPOSIT_CONFIRMATION = 1200,


  /**
   * Event triggered when there is a new bad sig loss available.
   */
  TALER_DBEVENT_AUDITOR_NEW_BAD_SIG_LOSSES = 1201,


  /**
   * Event triggered when there is a new balance available.
   */
  TALER_DBEVENT_AUDITOR_NEW_BALANCES = 1202,


  /**
   * Event triggered when there is a new closure lag available.
   */
  TALER_DBEVENT_AUDITOR_NEW_CLOSURE_LAGS = 1203,


  /**
   * Event triggered when there is a new coin inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_COIN_INCONSISTENCY = 1204,


  /**
   * Event triggered when there is a new denomination key validity withdraw inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_DENOMINATION_KEY_VALIDITY_WITHDRAW_INCONSISTENCY = 1205,


  /**
   * Event triggered when there is a new pending denomination available.
   */
  TALER_DBEVENT_AUDITOR_NEW_DENOMINATION_PENDING = 1206,


  /**
   * Event triggered when there is a new denomination without sigs available.
   */
  TALER_DBEVENT_AUDITOR_NEW_DENOMINATION_WITHOUT_SIGS = 1207,


  /**
   * Event triggered when there is a new emergency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_EMERGENCY = 1208,


  /**
   * Event triggered when there is a new emergency by count available.
   */
  TALER_DBEVENT_AUDITOR_NEW_EMERGENCY_BY_COUNT = 1209,


  /**
   * Event triggered when there is a new exchange sign keys available.
   */
  TALER_DBEVENT_AUDITOR_NEW_EXCHANGE_SIGNKEYS = 1210,


  /**
   * Event triggered when there is a new fee time inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_FEE_TIME_INCONSISTENCY = 1211,


  /**
   * Event triggered when there is a new historic denomination revenue entry available.
   */
  TALER_DBEVENT_AUDITOR_NEW_HISTORIC_DENOMINATION_REVENUE = 1212,


  /**
   * Event triggered when there is a new historic reserve summary entry available.
   */
  TALER_DBEVENT_AUDITOR_NEW_HISTORIC_RESERVE_SUMMARY = 1213,


  /**
   * Event triggered when there is a new misattribution in inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_MISATTRIBUTION_IN_INCONSISTENCY = 1214,


  /**
   * Event triggered when there is a new progress entry available.
   */
  TALER_DBEVENT_AUDITOR_NEW_PROGRESS = 1215,


  /**
   * Event triggered when there is a new purse not closed inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_PURSE_NOT_CLOSED_INCONSISTENCY = 1216,


  /**
   * Event triggered when there is a new purse entry available.
   */
  TALER_DBEVENT_AUDITOR_NEW_PURSES = 1217,


  /**
   * Event triggered when there is a new refreshes hanging entry available.
   */
  TALER_DBEVENT_AUDITOR_NEW_REFRESHES_HANGING = 1218,


  /**
   * Event triggered when there is a new balance insufficient inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_RESERVE_BALANCE_INSUFFICIENT_INCONSISTENCY = 1219,


  /**
   * Event triggered when there is a new reserve balance summary wrong inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_RESERVE_BALANCE_SUMMARY_WRONG_INCONSISTENCY = 1220,


  /**
   * Event triggered when there is a new reserve in inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_RESERVE_IN_INCONSISTENCY = 1221,


  /**
   * Event triggered when there is a new reserve not closed inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_RESERVE_NOT_CLOSED_INCONSISTENCY = 1222,


  /**
   * Event triggered when there is a new reserves entry available.
   */
  TALER_DBEVENT_AUDITOR_NEW_RESERVES = 1223,


  /**
   * Event triggered when there is a new row inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_ROW_INCONSISTENCY = 1224,


  /**
   * Event triggered when there is a new minor row inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_ROW_MINOR_INCONSISTENCY = 1225,


  /**
   * Event triggered when there is a new wire format inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_WIRE_FORMAT_INCONSISTENCY = 1226,


  /**
   * Event triggered when there is a new wire out inconsistency available.
   */
  TALER_DBEVENT_AUDITOR_NEW_WIRE_OUT_INCONSISTENCY = 1227,


  /**
   * Event triggered when there is new data for the aggregation helper to process.
   */
  TALER_DBEVENT_EXCHANGE_AUDITOR_WAKE_HELPER_AGGREGATION = 1230,


  /**
   * Event triggered when there is new data for the coins helper to process.
   */
  TALER_DBEVENT_EXCHANGE_AUDITOR_WAKE_HELPER_COINS = 1231,


  /**
   * Event triggered when there is new data for the purses helper to process.
   */
  TALER_DBEVENT_EXCHANGE_AUDITOR_WAKE_HELPER_PURSES = 1232,


  /**
   * Event triggered when there is new data for the deposits helper to process.
   */
  TALER_DBEVENT_EXCHANGE_AUDITOR_WAKE_HELPER_DEPOSITS = 1233,


  /**
   * Event triggered when there is new data for the reserves helper to process.
   */
  TALER_DBEVENT_EXCHANGE_AUDITOR_WAKE_HELPER_RESERVES = 1234,


  /**
   * Event triggered when there is a new deposit confirmation available.
   */
  TALER_DBEVENT_EXCHANGE_AUDITOR_WAKE_HELPER_WIRE = 1235,


  /**
   * A wire transfer from the target account with the correct wire transfer subject was received.
   */
  TALER_DBEVENT_ANASTASIS_AUTH_IBAN_TRANSFER = 2000,


  /**
   * A wire transfer with a valid reserve public key was received.
   */
  TALER_DBEVENT_LIBEUFIN_TALER_INCOMING = 3000,


  /**
   * A new transactions internal to Sandbox was made.
   */
  TALER_DBEVENT_LIBEUFIN_REGIO_TX = 3001,


  /**
   * A new fiat transaction can trigger actions in Sandbox.
   */
  TALER_DBEVENT_LIBEUFIN_SANDBOX_FIAT_INCOMING = 3002,


  /**
   * A new transaction was successfully ingested by Nexus.
   */
  TALER_DBEVENT_LIBEUFIN_NEXUS_TX = 3003,


};


#if 0 /* keep Emacsens' auto-indent happy */
{
#endif
#ifdef __cplusplus
}
#endif

#endif
