/* swcommon0.h - lowest level common header file
  
   COPYING TERMS AND CONDITIONS:
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef swcommon0_200212j_h
#define swcommon0_200212j_h

#include "swuser_config.h"
#include "swuser_assert_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef DEFAULT_PAX_W 
#define DEFAULT_PAX_W "pax"
#endif
#ifndef DEFAULT_PAX_R 
#define DEFAULT_PAX_R "pax"
#endif

volatile int global_lastsig;
#define SW_UTILNAME		"swutility"
#define REPORT_BUGS		"<bug-swbis@gnu.org>"
#define SWC_PID_ARRAY_LEN	30
#define SWC_TARGET_FD_ARRAY_LEN	10
#define SWC_SCRIPT_SLEEP_DELAY	0 /* Seconds to sleep a the end of the script */
				/* in order to help ssh not drop any bytes. */
				/* Using recent GNU/Linux releases this can be */
				/* set to zero '0' */

#define CMD_TAINTED_CHARS  "'|\"*?;&<>`$"
#define SW_FAILED_ALL_TARGETS		1
#define SW_FAILED_SOME_TARGETS		2
#define SIGNER_PGP5_BIN			"pgps"
#define SIGNER_PGP26_BIN		"pgp"
#define SIGNER_GPG_BIN			"gpg"

#define SWBIS_TARGET_CTL_MSG_125 	"125 target script started"
#define SWBIS_TARGET_CTL_MSG_128 	"128 catalog path determined"
#define SWBIS_TARGET_CTL_MSG_508 	"508 target script error"

struct g_pax_write_command {
	char * idM;
	char * commandM;
};

struct g_pax_read_command {
	char * idM;
	char * commandM;
	char * verbose_commandM;
	char * keep_commandM;
};

typedef struct {
	int codeM;
} ERRORCODE;

ERRORCODE * createErrorCode(void);
void destroyErrorCode(ERRORCODE * EC);
void setErrorCode(ERRORCODE * EC, int code);
int getErrorCode(ERRORCODE * EC);

int swc0_set_arf_format(char * optarg, int * format_arf, int * do_gnutar,
	int * do_bsdpax3, int * do_oldgnuposix);
  
int swc0_process_w_option(STROB * tmp, CPLOB * w_arglist, char * i_optarg,
	int * w_argc_p);

void swc0_create_parser_buffer(void);

#endif
