#ifndef TAGS_H
#define TAGS_H

#define QUOTATION_MARK "&quot;"
#define LESS_THAN "&lt;"
#define GREATER_THAN "&gt;"
#define AMPERSAND "&amp;"
#define NEWLINE "<br>"
#define SPACE_CHAR " "

#define FONT_TAG "font"
#define COLOR_TAG "color"
#define BOLD_TAG "b"
#define ITALIC_TAG "i"
#define UNDERLINE_TAG "u"

#define ISBOLD 0x1
#define ISITALIC 0x2
#define ISUNDERLINE 0x4


#include "colors.h"

#include <iostream.h>
#include <string.h>
#include <set>

class Tag
{
 protected:
  char *TagName ;
  char *color ;
  char DirectColor[16];
  int flags ;

 public:
  Tag( char *n ) : TagName( n ), color( 0 ), flags( 0 ) {}
  Tag( char *n, char *c ) : TagName( n ), flags( 0 ) {
    if ( strcmp( c, GREEN ) == 0 )
      color = GREEN_C ;
    else if ( strcmp( c, RED ) == 0 )
      color = RED_C ;
    else if ( strcmp( c, DARKRED ) == 0 )
      color = DARKRED_C ;
    else if ( strcmp( c, BLUE ) == 0 )
      color = BLUE_C ;
    else if ( strcmp( c, BROWN ) == 0 )
      color = BROWN_C ;
    else if ( strcmp( c, PINK ) == 0 )
      color = PINK_C ;
    else if ( strcmp( c, YELLOW ) == 0 )
      color = YELLOW_C ;
    else if ( strcmp( c, CYAN ) == 0 )
      color = CYAN_C ;
    else if ( strcmp( c, PURPLE ) == 0 )
      color = PURPLE_C ;
    else if ( strcmp( c, ORANGE ) == 0 )
      color = ORANGE_C ;
    else if ( strcmp( c, BRIGHTORANGE ) == 0 )
      color = BRIGHTORANGE_C ;
    else if ( strcmp( c, BRIGHTGREEN ) == 0 )
      color = BRIGHTGREEN_C ;
    else if ( strcmp( c, DARKGREEN ) == 0 )
      color = DARKGREEN_C ;
    else if ( strcmp( c, BLACK ) == 0 )
      color = BLACK_C ;
    else if ( strcmp( c, TEAL ) == 0 )
      color = TEAL_C ;
    else if ( strcmp( c, GRAY ) == 0 )
      color = GRAY_C ;
    else if ( strcmp( c, DARKBLUE ) == 0 )
      color = DARKBLUE_C ;
    else if ( *c == '#' && strlen(c) == 7 ) {
      strcpy(DirectColor,c); // FIXME: check the lenght or use strdup?
      color = DirectColor;
    }
    else
      color = 0 ;
  }

  void SetFlags( int f ) { flags = f ; }

  char *GetName() const { return TagName ; }
  char *GetColor() const { return color ; }
  void SetColor( char *col ) { color = col ; }

  int IsBold() { return ( flags & ISBOLD ) ; }
  int IsItalic() { return ( flags & ISITALIC ) ; }
  int IsUnderline() { return ( flags & ISUNDERLINE ) ; }

  void Print() ;
} ;

struct TagLess
{
 public:
  bool operator() (const Tag *t1, const Tag *t2) const
  { return strcmp(t1->GetName(),t2->GetName()); }
};

class Tags
{
 protected:
  typedef set<Tag *, TagLess> container_type;

  container_type tagsList ;

  typedef container_type::const_iterator const_iterator;

 public:
  Tags() {}
  void AddTag( Tag *t ) { tagsList.insert( t ) ;  }
  Tag *GetTag( char *name ) ;
} ;

inline Tag * 
Tags::GetTag( char *name ) 
{
  const_iterator p;
  for (p = tagsList.begin (); p != tagsList.end (); ++p)
    if (strcmp ((*p)->GetName (), name) == 0)
      return *p;
  
  return 0;
}

void setTags( Tags *t ) ;
Tag *getTag( char *name ) ;
void createDefaultTags() ;
Tag *newDefaultTag( char *tag, char *color ) ;

#endif
