#!/bin/sh
build() {
  # MS Windows have other defaults than linux. The 'sed' I have installed on
  # my windows machine don't support the -i option.
  mv default.config tmp.cfg
  sed -e "s/type=external-midiplayer/type=sequencer-device/" tmp.cfg > default.config
  rm tmp.cfg

  ./configure PYTHON=/c/Python25/python.exe --disable-pygtk-test --enable-winmidi
  make skipmanual=yes PYTHON_INCLUDES=-I/c/Python25/include
  make winbuild
}

prepare_installer() {
  rm win32 -rf
  make DESTDIR=win32 prefix="" install skipmanual=yes PYTHON_INCLUDES=-I/c/Python25/include
  mkdir win32/python
  (cd win32/python && tar zxf ../../../my-python-2.5.tgz)
  cp -a ../gtk-copy win32/GTK
  cp -a ../pygtk-stuff/* win32/python/lib/site-packages
  (cp soundcard/winmidi.pyd win32/share/solfege/soundcard)
  cp win32-start-solfege.pyw win32/bin
  cp solfegedebug.bat win32/bin/
  cp README.txt INSTALL.win32.txt INSTALL.txt AUTHORS.txt COPYING.txt win32
  (cd win32 && find -name *.pyc | xargs rm)
  python tools/trim_win32_installer.py
  echo "Now you must double click the file windowsinstaller.iss and"
  echo "build the installer"
}

mk_gtk_copy() {
  rm -rf ../gtk-copy
  mkdir ../gtk-copy
  cp -a /C/GTK/* ../gtk-copy
}

mk_pygtk_stuff() {
  rm -rf ../pygtk-stuff
  mkdir ../pygtk-stuff
  cp /C/Python25/Lib/site-packages/pygtk.* ../pygtk-stuff/
  cp -a /C/Python25/Lib/site-packages/cairo/ ../pygtk-stuff/
  cp -a /C/Python25/Lib/site-packages/gtk-2.0/ ../pygtk-stuff/
}
 
if test "x$1" = "xbuild"; then
  build
fi
if test "x$1" = "xmkinstalldir"; then
  prepare_installer
fi
if test "x$1" = "xbuildenv"; then
  mk_gtk_copy
  mk_pygtk_stuff
fi
if test "x$1" = "x-h"; then
  echo "sub commands:"
  echo "   build         build the package"
  echo "   mkinstalldir  create the win32/ folder that the installer will pack"
  echo "   buildenv      create ../gtk-copy and ../pygtk-stuff"
fi

