﻿-- Script was generated by Devart dbForge Studio Express for MySQL, Version 6.0.441.0
-- Product home page: http://www.devart.com/dbforge/mysql/studio
-- Script date 9/15/2013 5:19:04 PM
-- Server version: 5.5.20
-- Client version: 4.1

--
-- Definition for database iptstat
--
DROP DATABASE iptstat;
CREATE DATABASE iptstat
	CHARACTER SET latin1
	COLLATE latin1_swedish_ci;

-- 
-- Disable foreign keys
-- 
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;

-- 
-- Set character set the client will use to send SQL statements to the server
--
SET NAMES 'utf8';

-- 
-- Set default database
--
USE iptstat;

--
-- Definition for table errorlog
--
CREATE TABLE errorlog (
  ErrorID SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  Message VARCHAR(800) NOT NULL,
  TimeStamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (ErrorID)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table language
--
CREATE TABLE language (
  Code VARCHAR(3) NOT NULL,
  Description VARCHAR(255) DEFAULT NULL,
  SortOrder TINYINT(4) UNSIGNED DEFAULT NULL
)
ENGINE = INNODB
AVG_ROW_LENGTH = 3276
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table oidenumvaluelookup
--
CREATE TABLE oidenumvaluelookup (
  EnumId SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  Name VARCHAR(255) NOT NULL,
  Value TINYINT(4) NOT NULL,
  OID VARCHAR(20) NOT NULL,
  PRIMARY KEY (EnumId)
)
ENGINE = INNODB
AUTO_INCREMENT = 104
AVG_ROW_LENGTH = 159
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table oidfieldnamelookup
--
CREATE TABLE oidfieldnamelookup (
  OID VARCHAR(20) NOT NULL,
  FieldName VARCHAR(255) NOT NULL,
  FieldType VARCHAR(20) DEFAULT NULL,
  PRIMARY KEY (OID)
)
ENGINE = INNODB
AVG_ROW_LENGTH = 215
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table resources
--
CREATE TABLE resources (
  ResourceID INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  Code VARCHAR(125) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  Value VARCHAR(400) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  Value_de VARCHAR(400) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  Value_it VARCHAR(400) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  Value_fr VARCHAR(400) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  Value_es VARCHAR(400) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  DropDownItemValue VARCHAR(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  StyleClass VARCHAR(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  SortOrder TINYINT(4) UNSIGNED DEFAULT NULL,
  Page VARCHAR(255) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  LFT SMALLINT(6) UNSIGNED NOT NULL,
  RGT SMALLINT(6) UNSIGNED NOT NULL,
  PRIMARY KEY (ResourceID)
)
ENGINE = INNODB
AUTO_INCREMENT = 148
AVG_ROW_LENGTH = 387
CHARACTER SET utf8
COLLATE utf8_general_ci;

--
-- Definition for table thermostat
--
CREATE TABLE thermostat (
  ThermostatId MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  Name VARCHAR(40) NOT NULL,
  GroupId MEDIUMINT(9) UNSIGNED NOT NULL,
  Description VARCHAR(400) DEFAULT NULL,
  Host VARCHAR(255) NOT NULL,
  Port MEDIUMINT(8) UNSIGNED NOT NULL,
  AuthString VARCHAR(40) DEFAULT NULL,
  TimeZoneOffsetID TINYINT(4) UNSIGNED NOT NULL,
  UserId SMALLINT(5) UNSIGNED NOT NULL,
  Deleted TINYINT(4) UNSIGNED NOT NULL DEFAULT 0,
  PRIMARY KEY (ThermostatId)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
AVG_ROW_LENGTH = 963
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table thermostatgroups
--
CREATE TABLE thermostatgroups (
  GroupId MEDIUMINT(9) UNSIGNED NOT NULL AUTO_INCREMENT,
  Name VARCHAR(40) NOT NULL,
  Description VARCHAR(255) NOT NULL,
  UNIQUE INDEX IDX_GROUP_AND_ID (GroupId, Name)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table timezoneoffset
--
CREATE TABLE timezoneoffset (
  TimeZoneOffsetID TINYINT(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  Description VARCHAR(20) DEFAULT NULL,
  Offset DECIMAL(4, 1) DEFAULT NULL,
  PRIMARY KEY (TimeZoneOffsetID)
)
ENGINE = INNODB
AUTO_INCREMENT = 50
AVG_ROW_LENGTH = 321
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table transactionlog
--
CREATE TABLE transactionlog (
  TransactionId INT(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  ThermostatId MEDIUMINT(9) UNSIGNED NOT NULL,
  OID VARCHAR(20) NOT NULL,
  OldValue VARCHAR(20) DEFAULT NULL,
  NewValue VARCHAR(20) DEFAULT NULL,
  TransactionTimeStamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  TransactionUserId MEDIUMINT(8) UNSIGNED NOT NULL,
  PRIMARY KEY (TransactionId)
)
ENGINE = INNODB
AUTO_INCREMENT = 2
AVG_ROW_LENGTH = 121
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

--
-- Definition for table user
--
CREATE TABLE user (
  UserId SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  UserName VARCHAR(20) NOT NULL,
  MaxNumThermostats MEDIUMINT(8) UNSIGNED DEFAULT NULL,
  LangCode VARCHAR(3) NOT NULL,
  ThermostatSort VARCHAR(20) DEFAULT NULL,
  PRIMARY KEY (UserId)
)
ENGINE = INNODB
AUTO_INCREMENT = 1
AVG_ROW_LENGTH = 2730
CHARACTER SET latin1
COLLATE latin1_swedish_ci;

DELIMITER $$

--
-- Definition for procedure sp_Error_Insert
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Error_Insert(pErrorMessage varchar(800))
BEGIN
		insert into errorlog(Message)
		values(pErrorMessage);
    END
$$

--
-- Definition for procedure sp_Languages_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Languages_Load_All()
BEGIN
  select Code, Description from iptstat.language order by SortOrder;
END
$$

--
-- Definition for procedure sp_Language_Load_Details
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Language_Load_Details(IN pLangCode VARCHAR(3))
BEGIN
  select Code, Description from `language`
  where Code = pLangCode;
END
$$

--
-- Definition for procedure sp_OID_FieldName_Load
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_OID_FieldName_Load(pOID varchar(20))
BEGIN
		select FieldName from oidfieldnamelookup where OID = pOID;
    END
$$

--
-- Definition for procedure sp_OID_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_OID_Load_All()
BEGIN
		select OID, FieldName from oidfieldnamelookup
		order by OID;
    END
$$

--
-- Definition for procedure sp_Resources_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Resources_Load_All()
BEGIN
  select ResourceID, Code, Value, DropDownItemValue, StyleClass, SortOrder, Page, LFT, RGT from iptstat.resources order by LFT;
END
$$

--
-- Definition for procedure sp_Resources_Load_By_Page
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Resources_Load_By_Page(IN pPage VARCHAR(255))
BEGIN
  select ResourceID, Code, Value, DropDownItemValue, StyleClass, SortOrder, LFT, RGT from iptstat.resources
  where Page = pPage
  order by LFT;
END
$$

--
-- Definition for procedure sp_Resources_Load_By_Parent_Code
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Resources_Load_By_Parent_Code(IN pLangCode VARCHAR(3), IN pParentCode VARCHAR(125), IN pUseSortOrder BIT, IN pDepth TINYINT, IN pOnlyAtLevel BIT)
BEGIN
  create temporary table tbl
  (
    ResourceID int,
    Code varchar(125),
    Value varchar(255),
    DropDownItemValue varchar(50),
    StyleClass varchar(50),
    SortOrder tinyint,
    LFT smallint,
    RGT smallint,
    Depth tinyint
  );

  if pDepth is not null then    
      if pOnlyAtLevel = 1 then
        insert into tbl
        (
          ResourceID,
          Code,
          Value,
          DropDownItemValue,
          StyleClass,
          SortOrder,
          LFT,
          RGT,
          Depth
        )
        select
          r1.ResourceID,
          r1.Code,
          r1.Value,
          r1.DropDownItemValue,
          r1.StyleClass,
          r1.SortOrder,
          r1.LFT,
          r1.RGT,
          (count(r2.Code) - (sub.Depth + 1)) as "Depth"
        from iptstat.resources r1,
          iptstat.resources r2,
          iptstat.resources r3,
          (
            select r4.Code, (count(r5.Code) - 1) as "Depth"
            from iptstat.resources r4,
              iptstat.resources r5
            where r4.LFT between r5.LFT and r5.RGT
              and r4.Code = pParentCode
            group by r4.Code
            order by r4.LFT
          ) as sub
        where
          r1.LFT between r2.LFT and r2.RGT
          and r1.LFT between r3.LFT and r3.RGT
          and r3.Code = sub.Code
        group by r1.Code
        having Depth = pDepth
        order by r1.LFT;
      else
        insert into tbl
        (
          ResourceID,
          Code,
          Value,
          DropDownItemValue,
          StyleClass,
          SortOrder,
          LFT,
          RGT,
          Depth
        )
        select
          r1.ResourceID,
          r1.Code,
          r1.Value,
          r1.DropDownItemValue,
          r1.StyleClass,
          r1.SortOrder,
          r1.LFT,
          r1.RGT,
          (count(r2.Code) - (sub.Depth + 1)) as "Depth"
        from iptstat.resources r1,
          iptstat.resources r2,
          iptstat.resources r3,
          (
            select r4.Code, (count(r5.Code) - 1) as "Depth"
            from iptstat.resources r4,
              iptstat.resources r5
            where r4.LFT between r5.LFT and r5.RGT
              and r4.Code = pParentCode
            group by r4.Code
            order by r4.LFT
          ) as sub
        where
          r1.LFT between r2.LFT and r2.RGT
          and r1.LFT between r3.LFT and r3.RGT
          and r3.Code = sub.Code
        group by r1.Code
        having Depth <= pDepth
        order by r1.LFT;
      end if;
  else
    insert into tbl
    (
      ResourceID,
      Code,
      Value,
      DropDownItemValue,
      StyleClass,
      SortOrder,
      LFT,
      RGT,
      Depth
    )
    select
      r1.ResourceID,
      r1.Code,
      r1.Value,
      r1.DropDownItemValue,
      r1.StyleClass,
      r1.SortOrder,
      r1.LFT,
      r1.RGT,
      (count(r2.Code) - (sub.Depth + 1)) as "Depth"
    from iptstat.resources r1,
      iptstat.resources r2,
      iptstat.resources r3,
      (
        select r4.Code, (count(r5.Code) - 1) as "Depth"
        from iptstat.resources r4,
          iptstat.resources r5
        where r4.LFT between r5.LFT and r5.RGT
          and r4.Code = pParentCode
        group by r4.Code
        order by r4.LFT
      ) as sub
    where
      r1.LFT between r2.LFT and r2.RGT
      and r1.LFT between r3.LFT and r3.RGT
      and r3.Code = sub.Code
    group by r1.Code
    order by r1.LFT;
  end if;

  if pLangCode != 'en' then
    set @updstmt = concat('update tbl as tbl1, iptstat.resources as tbl2 set tbl1.Value = tbl2.Value_',pLangCode,' where tbl1.ResourceID = tbl2.ResourceID');
    prepare stmt from @updstmt;
    execute stmt;
  end if;

  if pUseSortOrder is not null and pUseSortOrder = 1 then
    select
      ResourceID,
      Code,
      Value,
      DropDownItemValue,
      StyleClass,
      SortOrder,
      LFT,
      RGT
    from tbl
    order by SortOrder;
  else
    select
      ResourceID,
      Code,
      Value,
      DropDownItemValue,
      StyleClass,
      SortOrder,
      LFT,
      RGT
    from tbl;
  end if;

  drop table tbl;
END
$$

--
-- Definition for procedure sp_Resources_Translate
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Resources_Translate(IN pLangCode VARCHAR(3), IN pResourceCode VARCHAR(125), IN pTranslatedValue VARCHAR(400))
BEGIN
  declare newColumn varchar(50);
  declare newColumnExists tinyint;

  if pLangCode = 'en' then
    set newColumn = 'Value';
  else
    set newColumn = concat('Value_',pLangCode);
  end if;

  set newColumnExists = ifnull((select 1 from information_schema.`COLUMNS`
                                  where COLUMN_NAME = newColumn
                                    and TABLE_SCHEMA = 'iptstat'
                                    and TABLE_NAME = 'resources'), 0);

  if pLangCode != 'en' then
    if newColumnExists = 0 then
      set @updstmt = concat('alter table iptstat.resources add column ',newColumn,' varchar(400) not null after Value');
      prepare stmt from @updstmt;
      execute stmt;
    end if;
  end if;
  
  set @updstmt = concat('update iptstat.resources set ',newColumn,' = \'',pTranslatedValue,'\' where Code = \'',pResourceCode,'\'');  
  prepare stmt from @updstmt;
  execute stmt;
  
END
$$

--
-- Definition for procedure sp_Resource_Load_By_Code
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Resource_Load_By_Code(IN pResourceCode VARCHAR(125), IN pLangCode VARCHAR(3))
BEGIN
  
  if pLangCode = 'en' then
    select ResourceID, Code, Value, DropDownItemValue, StyleClass, SortOrder, Page, LFT, RGT from iptstat.resources where Code = pResourceCode;
  else
    set @updstmt = concat('select ResourceID, Code, Value_', pLangCode, ' as Value, DropDownItemValue, StyleClass, SortOrder, Page, LFT, RGT from iptstat.resources where Code = \'', pResourceCode, '\'');
    prepare stmt from @updstmt;
    execute stmt;
  end if;

END
$$

--
-- Definition for procedure sp_ThermostatGroup_Delete
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_ThermostatGroup_Delete(IN pGroupId MEDIUMINT)
BEGIN
  select count(*) into @fkThermostats from thermostat WHERE GroupId = pGroupId AND Deleted = 0;
  if @fkthermostats > 0 then
      select 1 from nonexistingtabletosimulateanexception;
  else 
      delete from thermostatgroups where GroupId = pGroupId;
  end if;
END
$$

--
-- Definition for procedure sp_ThermostatGroup_Insert_Update
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_ThermostatGroup_Insert_Update(IN pGroupId MEDIUMINT, IN pName VARCHAR(40), IN pDescription VARCHAR(255))
BEGIN
  if pGroupId is null then
			insert into thermostatgroups(Name, Description) values(pName, pDescription);
			select last_insert_id();
		else
		
			update thermostatgroups set
			Name = pName,
			Description = pDescription
			where GroupId = pGroupId;
		end if;
END
$$

--
-- Definition for procedure sp_ThermostatGroup_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_ThermostatGroup_Load_All()
BEGIN
  select GroupId, Name, Description from iptstat.thermostatgroups order by Name;
END
$$

--
-- Definition for procedure sp_ThermostatGroup_Load_Details
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_ThermostatGroup_Load_Details(IN pGroupID MEDIUMINT)
BEGIN
  select Name, Description from iptstat.thermostatgroups
  where GroupId = pGroupID;
END
$$

--
-- Definition for procedure sp_Thermostat_Auth_Info_Update
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Thermostat_Auth_Info_Update(pThermostatId mediumint, pAuthString varchar(40))
BEGIN
		update thermostat set AuthString = pAuthString where ThermostatId = pThermostatId;
    END
$$

--
-- Definition for procedure sp_Thermostat_Delete
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Thermostat_Delete(pThermostatId mediumint)
BEGIN
		update thermostat set Deleted = 1 where ThermostatId = pThermostatId;
    END
$$

--
-- Definition for procedure sp_Thermostat_Insert_Update
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Thermostat_Insert_Update(IN pThermostatId MEDIUMINT, IN pGroupId MEDIUMINT, IN pName VARCHAR(40), IN pDescription VARCHAR(400), IN pHost VARCHAR(255), IN pPort MEDIUMINT, IN pTimeZoneOffsetID TINYINT, IN pUserId SMALLINT)
BEGIN
		if pThermostatId is null then			
			insert into thermostat(Name, GroupId, Description, Host, Port, TimeZoneOffsetID, UserId, Deleted)
			values(pName, pGroupId, pDescription, pHost, pPort, pTimeZoneOffsetID, pUserId, 0);
			
			select last_insert_id();
		Else
			update thermostat set
				`Name` = pName,
				GroupId = pGroupId,
				Description = pDescription,
				`Host` = pHost,
				`Port` = pPort,
        TimeZoneOffsetID = pTimeZoneOffsetID
			where ThermostatId = pThermostatId;
		end if;
    END
$$

--
-- Definition for procedure sp_Thermostat_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Thermostat_Load_All(IN pUserId smallint, IN pThermostatSort VARCHAR(20))
BEGIN
        CASE pThermostatSort
        WHEN 'Group_DESC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where UserId = pUserId and Deleted = 0 order by  G.Name Desc;
        WHEN 'Group_ASC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where UserId = pUserId and Deleted = 0 order by  G.Name Asc;
        WHEN 'Name_DESC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY T.Name Desc;
        WHEN 'Name_ASC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY T.Name Asc;
        WHEN 'Description_DESC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY T.Description Desc;
        WHEN 'Description_ASC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY Description Asc;
        WHEN 'Host_DESC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY Host Desc;
        WHEN 'Host_ASC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY Host Asc;
        WHEN 'Port_DESC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY Port Desc;
        WHEN 'Port_ASC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY Port Asc;
        WHEN 'TimeZone_DESC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY TimeZoneOffsetID Desc;
        WHEN 'TimeZone_ASC' THEN
            select ThermostatId, G.GroupId, T.Name, T.Description, Host, Port, AuthString, TimeZoneOffsetID from thermostat T
            left join thermostatgroups G on T.GroupId = G.GroupId
            where 
            UserId = pUserId and Deleted = 0 ORDER BY TimeZoneOffsetID Asc;
        END CASE;
END
$$

--
-- Definition for procedure sp_Thermostat_Load_Details
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Thermostat_Load_Details(IN pThermostatId mediumint)
BEGIN
	select t.Name, t.Description, t.Host, t.Port, t.AuthString, t.TimeZoneOffsetID, G.GroupId
	from thermostat t INNER JOIN thermostatgroups G ON t.GroupId = g.GroupId
	where t.ThermostatId = pThermostatId;
    END
$$

--
-- Definition for procedure sp_TimeZoneOffset_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_TimeZoneOffset_Load_All()
BEGIN
  select TimeZoneOffsetID, Description, `Offset` from iptstat.timezoneoffset order by `Offset`;
END
$$

--
-- Definition for procedure sp_TimeZoneOffset_Load_Details
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_TimeZoneOffset_Load_Details(IN pTimeZoneOffsetID TINYINT)
BEGIN
  select Description, `Offset` from iptstat.timezoneoffset where TimeZoneOffsetID = pTimeZoneOffsetID;
END
$$

--
-- Definition for procedure sp_Transaction_Log_Insert
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Transaction_Log_Insert(pThermstatId mediumint, pOID varchar(20), pOldValue varchar(20),
		pNewValue varchar(20), pUserId smallInt)
BEGIN
		INSERT INTO transactionlog(ThermostatId, OID, OldValue, NewValue, TransactionUserId)
		VALUES(pThermstatId, pOID, pOldValue, pNewValue, pUserId);
    END
$$

--
-- Definition for procedure sp_Transaction_Log_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Transaction_Log_Load_All(IN pUserId smallint)
BEGIN
		select tl.TransactionId, t.Name, ofl.FieldName, 
			case ofl.FieldType
				when 'Enum' then (select oevl1.Name from oidenumvaluelookup oevl1 where oevl1.OID = tl.OID and oevl1.Value = tl.OldValue)
				when 'Temp' then (tl.OldValue / 10)
				when 'Date' then Date_format(from_unixtime(tl.OldValue), '%a, %b %e, %Y %h:%i %p')
				when 'Period' then time_format(sec_to_time(tl.OldValue * 60), '%h:%i %p')
			end as OldValue,
			case ofl.FieldType
				when 'Enum' then (select oevl2.Name from oidenumvaluelookup oevl2 WHERE oevl2.OID = tl.OID and oevl2.Value = tl.NewValue)
				WHEN 'Temp' THEN (tl.NewValue / 10)
				when 'Date' then DATE_FORMAT(from_unixtime(tl.NewValue), '%a, %b %e, %Y %h:%i %p')
				WHEN 'Period' THEN TIME_FORMAT(SEC_TO_TIME(tl.NewValue * 60), '%h:%i %p')
			end as NewValue,
			DATE_FORMAT(tl.TransactionTimeStamp, '%a, %b %e, %Y %h:%i %p') as TransactionTimeStamp
		from transactionlog tl
			join thermostat t using(ThermostatId)
			join oidfieldnamelookup ofl using(OID)
		where tl.TransactionUserId = pUserId
    order by 6 desc;
    END
$$

--
-- Definition for procedure sp_Transaction_Log_Load_Details
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_Transaction_Log_Load_Details(pTransactionId int)
BEGIN
		SELECT ThermostatId, OID, OldValue, NewValue, TransactionTimeStamp
		FROM transactionlog			
		WHERE TransactionId = pTransactionId;
    END
$$

--
-- Definition for procedure sp_User_Delete
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_User_Delete(IN pUserId MEDIUMINT)
BEGIN
  select count(*) into @fkThermostats from thermostat WHERE UserId = pUserId AND Deleted = 0;
  if @fkthermostats > 0 then
      select 1 from nonexistingtabletosimulateanexception;
  else 
      delete from user where UserId = pUserId;
  end if;
END
$$

--
-- Definition for procedure sp_User_Insert_Update
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_User_Insert_Update(IN pUserId MEDIUMINT, IN pUserName VARCHAR(20), IN pMaxNumThermostats MEDIUMINT, IN pLangCode VARCHAR(3))
BEGIN
		if pUserId is null then
			insert into `user`(UserName, MaxNumThermostats, LangCode) values(pUserName, pMaxNumThermostats, pLangCode);
			select last_insert_id();
		else
		
			update `user` set
			UserName = pUserName,
			MaxNumThermostats = pMaxNumThermostats,
			LangCode = pLangCode
			where UserId = pUserId;
		end if;
    END
$$

--
-- Definition for procedure sp_User_Load_All
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_User_Load_All()
BEGIN
	select UserId, UserName, MaxNumThermostats, LangCode from `user`    
	order by UserName;
    END
$$

--
-- Definition for procedure sp_User_Load_Details_By_UserID
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_User_Load_Details_By_UserID(IN pUserId mediumint)
BEGIN	
		SELECT UserName, IFNULL(MaxNumThermostats, 0) `MaxNumThermostats`, LangCode, ThermostatSort
		FROM `user`
		WHERE UserId = pUserId;
    END
$$

--
-- Definition for procedure sp_User_Load_Details_By_UserName
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_User_Load_Details_By_UserName(IN pUserName varchar(20))
BEGIN
SELECT
  u.UserId,
  IFNULL(u.MaxNumThermostats, 0) `MaxNumThermostats`,
  u.LangCode,
  u.ThermostatSort,
  l.Description AS `LangDesc`
FROM `user` AS u
  INNER JOIN `language` AS l
    ON l.Code = u.LangCode
WHERE u.UserName = pUserName;
    END
$$

--
-- Definition for procedure sp_User_Update_Thermostat_Sort_Field
--
CREATE DEFINER = 'root'@'localhost'
PROCEDURE sp_User_Update_Thermostat_Sort_Field(IN pUserId MEDIUMINT, IN pThermostatSort VARCHAR(20))
BEGIN
        UPDATE user set ThermostatSort = pThermostatSort WHERE userId = pUserId;
END
$$

DELIMITER ;

-- 
-- Dumping data for table errorlog
--

-- Table iptstat.errorlog does not contain any data (it is empty)

-- 
-- Dumping data for table language
--
INSERT INTO language VALUES
('en', 'English', 1),
('es', 'EspaÃ±ol', 2),
('fr', 'franÃ§ais', 3),
('it', 'Italiano', 4),
('de', 'Deutsch', 5);

-- 
-- Dumping data for table oidenumvaluelookup
--
INSERT INTO oidenumvaluelookup VALUES
(1, 'Off', 1, '4.1.1'),
(2, 'Heat', 2, '4.1.1'),
(3, 'Cool', 3, '4.1.1'),
(4, 'Auto', 4, '4.1.1'),
(5, 'Auto', 1, '4.1.3'),
(6, 'On', 2, '4.1.3'),
(7, 'Schedule', 3, '4.1.3'),
(8, 'Normal', 1, '4.1.9'),
(9, 'Hold', 2, '4.1.9'),
(10, 'Override', 3, '4.1.9'),
(11, 'Disabled', 1, '4.3.6.1'),
(12, 'Enabled', 2, '4.3.6.1'),
(13, 'Disabled', 1, '4.3.6.2'),
(14, 'Enabled', 2, '4.3.6.2'),
(15, 'Disabled', 1, '4.3.6.3'),
(16, 'Enabled', 2, '4.3.6.3'),
(17, 'Disabled', 1, '4.3.8.1'),
(18, 'Enabled', 2, '4.3.8.1'),
(19, 'Disabled', 1, '4.3.8.2'),
(20, 'Enabled', 2, '4.3.8.2'),
(21, 'Disabled', 1, '4.3.8.3'),
(22, 'Enabled', 2, '4.3.8.3'),
(23, 'Disable', 0, '4.4.1.6.1.1'),
(24, '15 Minutes', 15, '4.4.1.6.1.1'),
(25, '30 Minutes', 30, '4.4.1.6.1.1'),
(26, '45 Minutes', 45, '4.4.1.6.1.1'),
(27, 'On', 60, '4.4.1.6.1.1'),
(28, 'Disable', 0, '4.4.1.6.1.2'),
(29, '15 Minutes', 15, '4.4.1.6.1.2'),
(30, '30 Minutes', 30, '4.4.1.6.1.2'),
(31, '45 Minutes', 45, '4.4.1.6.1.2'),
(32, 'On', 60, '4.4.1.6.1.2'),
(33, 'Disable', 0, '4.4.1.6.1.3'),
(34, '15 Minutes', 15, '4.4.1.6.1.3'),
(35, '30 Minutes', 30, '4.4.1.6.1.3'),
(36, '45 Minutes', 45, '4.4.1.6.1.3'),
(37, 'On', 60, '4.4.1.6.1.3'),
(38, 'Disable', 0, '4.4.1.6.1.4'),
(39, '15 Minutes', 15, '4.4.1.6.1.4'),
(40, '30 Minutes', 30, '4.4.1.6.1.4'),
(41, '45 Minutes', 45, '4.4.1.6.1.4'),
(42, 'On', 60, '4.4.1.6.1.4'),
(43, 'Disable', 0, '4.4.1.6.2.1'),
(44, '15 Minutes', 15, '4.4.1.6.2.1'),
(45, '30 Minutes', 30, '4.4.1.6.2.1'),
(46, '45 Minutes', 45, '4.4.1.6.2.1'),
(47, 'On', 60, '4.4.1.6.2.1'),
(48, 'Disable', 0, '4.4.1.6.2.2'),
(49, '15 Minutes', 15, '4.4.1.6.2.2'),
(50, '30 Minutes', 30, '4.4.1.6.2.2'),
(51, '45 Minutes', 45, '4.4.1.6.2.2'),
(52, 'On', 60, '4.4.1.6.2.2'),
(53, 'Disable', 0, '4.4.1.6.2.3'),
(54, '15 Minutes', 15, '4.4.1.6.2.3'),
(55, '30 Minutes', 30, '4.4.1.6.2.3'),
(56, '45 Minutes', 45, '4.4.1.6.2.3'),
(57, 'On', 60, '4.4.1.6.2.3'),
(58, 'Disable', 0, '4.4.1.6.2.4'),
(59, '15 Minutes', 15, '4.4.1.6.2.4'),
(60, '30 Minutes', 30, '4.4.1.6.2.4'),
(61, '45 Minutes', 45, '4.4.1.6.2.4'),
(62, 'On', 60, '4.4.1.6.2.4'),
(63, 'Disable', 0, '4.4.1.6.3.1'),
(64, '15 Minutes', 15, '4.4.1.6.3.1'),
(65, '30 Minutes', 30, '4.4.1.6.3.1'),
(66, '45 Minutes', 45, '4.4.1.6.3.1'),
(67, 'On', 60, '4.4.1.6.3.1'),
(68, 'Disable', 0, '4.4.1.6.3.2'),
(69, '15 Minutes', 15, '4.4.1.6.3.2'),
(70, '30 Minutes', 30, '4.4.1.6.3.2'),
(71, '45 Minutes', 45, '4.4.1.6.3.2'),
(72, 'On', 60, '4.4.1.6.3.2'),
(73, 'Disable', 0, '4.4.1.6.3.3'),
(74, '15 Minutes', 15, '4.4.1.6.3.3'),
(75, '30 Minutes', 30, '4.4.1.6.3.3'),
(76, '45 Minutes', 45, '4.4.1.6.3.3'),
(77, 'On', 60, '4.4.1.6.3.3'),
(78, 'Disable', 0, '4.4.1.6.3.4'),
(79, '15 Minutes', 15, '4.4.1.6.3.4'),
(80, '30 Minutes', 30, '4.4.1.6.3.4'),
(81, '45 Minutes', 45, '4.4.1.6.3.4'),
(82, 'On', 60, '4.4.1.6.3.4'),
(83, 'Occupied', 1, '4.4.3.2.1'),
(84, 'Unoccupied', 2, '4.4.3.2.1'),
(85, 'Other', 3, '4.4.3.2.1'),
(86, 'Occupied', 1, '4.4.3.2.2'),
(87, 'Unoccupied', 2, '4.4.3.2.2'),
(88, 'Other', 3, '4.4.3.2.2'),
(89, 'Occupied', 1, '4.4.3.2.3'),
(90, 'Unoccupied', 2, '4.4.3.2.3'),
(91, 'Other', 3, '4.4.3.2.3'),
(92, 'Occupied', 1, '4.4.3.2.4'),
(93, 'Unoccupied', 2, '4.4.3.2.4'),
(94, 'Other', 3, '4.4.3.2.4'),
(95, 'Occupied', 1, '4.4.3.2.5'),
(96, 'Unoccupied', 2, '4.4.3.2.5'),
(97, 'Other', 3, '4.4.3.2.5'),
(98, 'Occupied', 1, '4.4.3.2.6'),
(99, 'Unoccupied', 2, '4.4.3.2.6'),
(100, 'Other', 3, '4.4.3.2.6'),
(101, 'Occupied', 1, '4.4.3.2.7'),
(102, 'Unoccupied', 2, '4.4.3.2.7'),
(103, 'Other', 3, '4.4.3.2.7');

-- 
-- Dumping data for table oidfieldnamelookup
--
INSERT INTO oidfieldnamelookup VALUES
('1.10.9', 'Site Name', 'Free'),
('1.13.2.1', 'Low Temp Alarm', 'ReadOnly'),
('1.13.2.2', 'High Temp Alarm', 'ReadOnly'),
('1.13.2.3', 'Filter Reminder', 'ReadOnly'),
('1.13.2.4', 'High Humidity Alarm', 'ReadOnly'),
('1.2', 'Device Name', 'Free'),
('2.5.1', 'Date/Time', 'Date'),
('2.7.1', 'Model Number', 'Free'),
('4.1.1', 'HVAC Mode', 'Enum'),
('4.1.3', 'Fan Mode', 'Enum'),
('4.1.5', 'Setback Heat', 'Temp'),
('4.1.6', 'Setback Cool', 'Temp'),
('4.1.9', 'Setback Status', 'Enum'),
('4.3.4.2', 'Remote Sensor #1 Correction', 'Temp'),
('4.3.4.3', 'Remote Sensor #2 Correction', 'Temp'),
('4.3.6.1', 'Local Sensor State', 'Enum'),
('4.3.6.2', 'Remote Sensor #1 State', 'Enum'),
('4.3.6.3', 'Remote Sensor #2 State', 'Enum'),
('4.3.8.1', 'Local Sensor Averaging', 'Enum'),
('4.3.8.2', 'Remote Sensor #1 Averaging', 'Enum'),
('4.3.8.3', 'Remote Sensor #2 Averaging', 'Enum'),
('4.4.1.3.1.1', 'Setback Sched Occ Morn Start Time', 'Period'),
('4.4.1.3.1.2', 'Setback Sched Occ Day Start Time', 'Period'),
('4.4.1.3.1.3', 'Setback Sched Occ Eve Start Time', 'Period'),
('4.4.1.3.1.4', 'Setback Sched Occ Night Start Time', 'Period'),
('4.4.1.3.2.1', 'Setback Sched Unocc Morn Start Time', 'Period'),
('4.4.1.3.2.2', 'Setback Sched Unocc Day Start Time', 'Period'),
('4.4.1.3.2.3', 'Setback Sched Unocc Eve Start Time', 'Period'),
('4.4.1.3.2.4', 'Setback Sched Unocc Night Start Time', 'Period'),
('4.4.1.3.3.1', 'Setback Sched Other Morn Start Time', 'Period'),
('4.4.1.3.3.2', 'Setback Sched Other Day Start Time', 'Period'),
('4.4.1.3.3.3', 'Setback Sched Other Eve Start Time', 'Period'),
('4.4.1.3.3.4', 'Setback Sched Other Night Start Time', 'Period'),
('4.4.1.4.1.1', 'Setback Sched Occ Morn Heat', 'Temp'),
('4.4.1.4.1.2', 'Setback Sched Occ Day Heat', 'Temp'),
('4.4.1.4.1.3', 'Setback Sched Occ Eve Heat', 'Temp'),
('4.4.1.4.1.4', 'Setback Sched Occ Night Heat', 'Temp'),
('4.4.1.4.2.1', 'Setback Sched Unocc Morn Heat', 'Temp'),
('4.4.1.4.2.2', 'Setback Sched Unocc Day Heat', 'Temp'),
('4.4.1.4.2.3', 'Setback Sched Unocc Eve Heat', 'Temp'),
('4.4.1.4.2.4', 'Setback Sched Unocc Night Heat', 'Temp'),
('4.4.1.4.3.1', 'Setback Sched Other Morn Heat', 'Temp'),
('4.4.1.4.3.2', 'Setback Sched Other Day Heat', 'Temp'),
('4.4.1.4.3.3', 'Setback Sched Other Eve Heat', 'Temp'),
('4.4.1.4.3.4', 'Setback Sched Other Night Heat', 'Temp'),
('4.4.1.5.1.1', 'Setback Sched Occ Morn Cool', 'Temp'),
('4.4.1.5.1.2', 'Setback Sched Occ Day Cool', 'Temp'),
('4.4.1.5.1.3', 'Setback Sched Occ Eve Cool', 'Temp'),
('4.4.1.5.1.4', 'Setback Sched Occ Night Cool', 'Temp'),
('4.4.1.5.2.1', 'Setback Sched Unocc Morn Cool', 'Temp'),
('4.4.1.5.2.2', 'Setback Sched Unocc Day Cool', 'Temp'),
('4.4.1.5.2.3', 'Setback Sched Unocc Eve Cool', 'Temp'),
('4.4.1.5.2.4', 'Setback Sched Unocc Night Cool', 'Temp'),
('4.4.1.5.3.1', 'Setback Sched Other Morn Cool', 'Temp'),
('4.4.1.5.3.2', 'Setback Sched Other Day Cool', 'Temp'),
('4.4.1.5.3.3', 'Setback Sched Other Eve Cool', 'Temp'),
('4.4.1.5.3.4', 'Setback Sched Other Night Cool', 'Temp'),
('4.4.1.6.1.1', 'Setback Sched Occ Morn Fan', 'Enum'),
('4.4.1.6.1.2', 'Setback Sched Occ Day Fan', 'Enum'),
('4.4.1.6.1.3', 'Setback Sched Occ Eve Fan', 'Enum'),
('4.4.1.6.1.4', 'Setback Sched Occ Night Fan', 'Enum'),
('4.4.1.6.2.1', 'Setback Sched Unocc Morn Fan', 'Enum'),
('4.4.1.6.2.2', 'Setback Sched Unocc Day Fan', 'Enum'),
('4.4.1.6.2.3', 'Setback Sched Unocc Eve Fan', 'Enum'),
('4.4.1.6.2.4', 'Setback Sched Unocc Night Fan', 'Enum'),
('4.4.1.6.3.1', 'Setback Sched Other Morn Fan', 'Enum'),
('4.4.1.6.3.2', 'Setback Sched Other Day Fan', 'Enum'),
('4.4.1.6.3.3', 'Setback Sched Other Eve Fan', 'Enum'),
('4.4.1.6.3.4', 'Setback Sched Other Night Fan', 'Enum'),
('4.4.3.2.1', 'Setback Sched Default Class Sun', 'Enum'),
('4.4.3.2.2', 'Setback Sched Default Class Mon', 'Enum'),
('4.4.3.2.3', 'Setback Sched Default Class Tue', 'Enum'),
('4.4.3.2.4', 'Setback Sched Default Class Wed', 'Enum'),
('4.4.3.2.5', 'Setback Sched Default Class Thu', 'Enum'),
('4.4.3.2.6', 'Setback Sched Default Class Fri', 'Enum'),
('4.4.3.2.7', 'Setback Sched Default Class Sat', 'Enum');

-- 
-- Dumping data for table resources
--
INSERT INTO resources VALUES
(1, 'GRCHM', 'Home', 'Startseite', 'Casa', 'Accueil', 'Home', NULL, NULL, NULL, 'Home', 6, 203),
(2, 'GRCHM$LBL1', 'Display Language:', 'Display-Sprache:', 'Lingua di visualizzazione:', 'Langue d''affichage :', 'Idioma de la pantalla:', NULL, NULL, NULL, 'Home', 7, 8),
(3, 'GRCHM$LBL2', 'Highlighted fields are required.', 'Hervorgehobene Felder mÃ¼ssen ausgefÃ¼llt werden.', 'Campi evidenziati sono obbligatori.', 'Les champs en surbrillance sont obligatoires.', 'Los campos resaltados son obligatorios.', NULL, 'requirednote', NULL, 'Home', 9, 10),
(4, 'GRCHM$LBL3', 'Welcome back, {0}', 'Willkommen Back, {0}', 'Benvenuto back,: {0}', 'Bienvenue back, {0}', 'Bienvenido back, {0}', NULL, NULL, NULL, 'Home', 11, 12),
(5, 'GRCHM$LBL4', 'You are allowed a maximum of <b>{0}</b> thermostats.', 'Sie dÃ¼rfen ein Maximum von <b>{0}</b> Thermostate.', 'Sono ammessi un massimo di <b>{0}</b> termostati.', 'Vous avez droit Ã  un maximum de <b>{0}</b> thermostats.', 'Se permite un mÃ¡ximo de <b>{0}</b> termostatos.', NULL, NULL, NULL, 'Home', 13, 14),
(6, 'GRCHM$HLK1', 'Transaction History', 'Transaktionshistorie', 'Cronologia delle transazioni', 'Historique des transactions', 'Historial de transacciones', NULL, NULL, NULL, 'Home', 35, 36),
(7, 'GRCHM$HLK2', 'Add', 'HinzufÃ¼gen', 'Aggiungi', 'Ajouter', 'AÃ±adir', NULL, 'add', NULL, 'Home', 37, 38),
(8, 'GRCHM$CLM1', 'Device Name', 'GerÃ¤tename', 'Nome del dispositivo', 'Nom du pÃ©riphÃ©rique', 'Nombre del dispositivo', NULL, NULL, NULL, 'Home', 51, 52),
(9, 'GRCHM$CLM2', 'Site Name', 'Site-Name', 'Nome del sito', 'Nom du site', 'Nombre del sitio', NULL, NULL, NULL, 'Home', 53, 54),
(10, 'GRCHM$CLM3', 'Model #', 'Modell #', 'Modello #', 'ModÃ¨le #', 'Modelo #', NULL, NULL, NULL, 'Home', 55, 56),
(11, 'GRCHM$CLM4', 'Custom Name', 'Benutzerdefinierten Namen', 'Nome personalizzato', 'Nom personnalisÃ©', 'Nombre personalizado', NULL, NULL, NULL, 'Home', 57, 58),
(12, 'GRCHM$CLM5', 'Description', 'Beschreibung', 'Descrizione', 'Description', 'DescripciÃ³n', NULL, NULL, NULL, 'Home', 59, 60),
(13, 'GRCHM$CLM6', 'Domain Name/IP', 'Domain-Namen/IP', 'IP o nome dominio', 'IP/nom de domaine', 'Nombre de dominio/IP', NULL, NULL, NULL, 'Home', 61, 62),
(14, 'GRCHM$CLM7', 'Port', 'Port', 'Porta', 'Port', 'Puerto', NULL, NULL, NULL, 'Home', 63, 64),
(15, 'GRCHM$CLM8', 'Login', 'Login', 'Login', 'Ouverture de session', 'Inicio de sesiÃ³n', NULL, NULL, NULL, 'Home', 65, 78),
(16, 'GRCHM$HLK3', 'Edit', 'Bearbeiten', 'Modifica', 'Edit', 'Editar', NULL, 'edit', NULL, 'Home', 39, 40),
(17, 'GRCHM$HLK4', 'Update', 'Update', 'Aggiornamento', 'Mise Ã  jour', 'ActualizaciÃ³n', NULL, 'update', NULL, 'Home', 41, 42),
(18, 'GRCHM$HLK5', 'Cancel', 'Abbrechen', 'Annulla', 'Annuler', 'Cancelar', NULL, 'cancel', NULL, 'Home', 43, 44),
(21, 'GRCHM$HLK6', 'View Settings', 'Ansichtseinstellungen', 'Impostazioni di visualizzazione', 'ParamÃ¨tres d''affichage', 'ConfiguraciÃ³n de vista', NULL, 'viewsettings', NULL, 'Home', 45, 46),
(22, 'GRCHM$HLK7', 'Currently Viewing', 'Z.z. ansehend', 'Attualmente la visualizzazione', 'Currently Viewing', 'Viendo', NULL, 'currentlyviewing', NULL, 'Home', 47, 48),
(23, 'GRCHM$HLK8', 'Delete', 'LÃ¶schen', 'Eliminare', 'Supprimer', 'Eliminar', NULL, 'delete', NULL, 'Home', 49, 50),
(24, 'GRCHM$LBL5', 'Done', 'Getan', 'Fatto', 'Fait', 'Hecho', NULL, 'success', NULL, 'Home', 15, 16),
(25, 'GRCHM$LBL6', 'Error', 'Fehler', 'Errore', 'Erreur', 'Error', NULL, 'failure', NULL, 'Home', 17, 18),
(26, 'GRCHM$LBL7', 'NoTrans', 'NoTrans', 'NoTrans', 'NoTrans', 'NoTrans', NULL, 'notrans', NULL, 'Home', 19, 20),
(27, 'GRCHM$CLM8$HLK1', 'Change', 'Ã„nderung', 'Cambiamento', 'Changement', 'Cambio', NULL, 'change', NULL, 'Home', 66, 67),
(28, 'GRCHM$CLM8$HLK2', 'Set', 'Satz', 'Set', 'Jeu', 'Conjunto', NULL, 'set', NULL, 'Home', 68, 69),
(29, 'GRCHM$TTP1', 'Select All/Deselect All', 'Alle auswÃ¤hlen / Auswahl zurÃ¼cksetzen', 'Seleziona tutto / Deseleziona tutto', 'SÃ©lectionner tout / dÃ©sÃ©lectionner tout', 'Seleccionar todo / deseleccionar todo', NULL, NULL, NULL, 'Home', 87, 88),
(30, 'GRCHM$MSG1', 'Some required fields have been left blank. Group, Custom Name, Domain Name/IP, Port, and Time Zone Offset are required.', 'Einige erforderliche Felder leer gelassen. Gruppe, benutzerdefinierter Name, Domain-Namen/IP, Port und Time Zone Offset sind erforderlich.', 'Alcuni tenuti campi sono state lasciate vuote. Gruppo, nome personalizzato, Domain Name/IP, porta e Offset del fuso orario sono necessari.', 'Certains requis zones ont été laissées en blanc. Groupe, Custom Name, nom de domaine/IP, Port et décalage de fuseau horaire sont nécessaires.', 'Algunos requieren campos han sido dejados en blanco. Grupo, Custom nombre, nombre de dominio/IP, puerto y zona horaria Offset se requieren.', NULL, NULL, NULL, 'Home', 23, 24),
(31, 'GRCHM$MSG2', 'You must enter a password.', 'Sie mÃ¼ssen ein Kennwort eingeben.', 'Ãˆ necessario immettere una password.', 'Vous devez entrer un mot de passe.', 'Debe introducir una contraseÃ±a.', NULL, NULL, NULL, 'Home', 25, 26),
(32, 'GRCHM$MSG3', 'At least one thermostat must be selected before submitting.', 'Vor dem Absenden muss mindestens ein Thermostat ausgewÃ¤hlt werden.', 'Prima della presentazione, Ã¨ necessario selezionare almeno un termostato.', 'Au moins un thermostat doit Ãªtre sÃ©lectionnÃ©e avant de la soumettre.', 'Al menos un termostato debe seleccionarse antes de enviar.', NULL, NULL, NULL, 'Home', 27, 28),
(33, 'GRCHM$TTP2', 'No transaction occurred. All submitted values are the same as current values.', 'Keine Transaktion aufgetreten ist. Alle eingereichten, dass Werte, die die aktuellen Werte identisch sind.', 'Nessuna transazione avvenuta. Tutti dei valori sono gli stessi valori correnti.', 'Aucune transaction n''a eu lieu. Tout a fait valoir les valeurs sont les mÃªmes que les valeurs actuelles.', 'Se ha producido ninguna transacciÃ³n. Todos presentaron valores son los mismos que los valores actuales.', NULL, NULL, NULL, 'Home', 89, 90),
(34, 'GRCHM$TTP3', 'The following error occurred during the transaction: {0}', 'Der folgende Fehler trat wÃ¤hrend der Transaction: {0}', 'Il seguente errore si Ã¨ verificato durante il transaction: {0}', 'L''erreur suivante s''est produite lors de la transaction: : {0}', 'OcurriÃ³ el siguiente error durante la transaction: {0}', NULL, NULL, NULL, 'Home', 91, 92),
(35, 'GRCHM$TTP4', 'Transaction completed successfully.', 'Transaktion erfolgreich abgeschlossen.', 'Transazione completata con successo.', 'OpÃ©ration terminÃ©e avec succÃ¨s.', 'TransacciÃ³n completada con Ã©xito.', NULL, NULL, NULL, 'Home', 93, 94),
(36, 'GRCHM$MSG4', 'Setback Heat and Setback Cool are within 2 degrees of each other. This is not allowed when HVAC Mode is Auto.', 'RÃ¼ckschlag-Hitze und RÃ¼ckschlag Cool sind innerhalb von 2 Grad voneinander. Dies ist nicht zulÃ¤ssig, wenn der HVAC-Modus Auto ist.', 'Battuta d''arresto termico e battuta d''arresto Cool sono entro i 2 gradi uno da altro. Questo non Ã¨ consentito quando la modalitÃ  di HVAC Ã¨ automatico.', 'Chaleur revers et revers Cool se trouvent 2 degrÃ©s de l''autre. Ce n''est pas autorisÃ© lorsque le Mode de CVC est automatique.', 'RevÃ©s calor y frÃ­o de retroceso estÃ¡n dentro de los 2 grados entre sÃ­. Esto no estÃ¡ permitido cuando el modo de climatizaciÃ³n es Auto.', NULL, NULL, NULL, 'Home', 29, 30),
(37, 'GRCHM$MSG5', 'Setback Scheduling Period Times cannot overlap. Please check your Time selections in the Setback Scheduling section.', 'RÃ¼ckschlag Scheduling Zeitraum Mal dÃ¼rfen sich nicht Ã¼berschneiden. Bitte Ã¼berprÃ¼fen Sie Ihre Zeit-Auswahl im Abschnitt RÃ¼ckschlag zu planen.', 'Battuta d''arresto di programmazione tempi di periodo non possono sovrapporsi. Si prega di controllare le selezioni di tempo nella sezione pianificazione della battuta d''arresto.', 'Revers calendrier pÃ©riode de temps ne peuvent pas se chevaucher. S''il vous plaÃ®t vÃ©rifier vos sÃ©lections de temps dans la section planification des revers.', 'RevÃ©s programaciÃ³n perÃ­odo veces no pueden solaparse. Por favor revise sus selecciones de tiempo en la secciÃ³n de programaciÃ³n de revÃ©s.', NULL, NULL, NULL, 'Home', 31, 32),
(38, 'GRCHM$HDR1', 'HVAC Settings', 'HVAC-Einstellungen', 'Impostazioni di HVAC', 'ParamÃ¨tres de CVC', 'ConfiguraciÃ³n HVAC', NULL, 'sectionheader', NULL, 'Home', 95, 126),
(39, 'GRCHM$HDR1$LBL1', 'HVAC Mode', 'HVAC-Modus', 'ModalitÃ  HVAC', 'Mode de chauffage ', 'Modo HVAC', NULL, 'fieldlabel', NULL, 'Home', 96, 105),
(40, 'GRCHM$HDR1$LBL1$DDI1', 'Off', 'Ausschalten', 'Fuori', 'Hors', 'Apagado', '1', NULL, 1, 'Home', 97, 98),
(41, 'GRCHM$HDR1$LBL1$DDI2', 'Heat', 'WÃ¤rme', 'Calore', 'Chaleur', 'Calor', '2', 'heat', 2, 'Home', 99, 100),
(42, 'GRCHM$HDR1$LBL1$DDI3', 'Cool', 'Cool', 'Cool', 'Cool', 'Cool', '3', 'cool', 3, 'Home', 101, 102),
(43, 'GRCHM$HDR1$LBL1$DDI4', 'Auto', 'Auto', 'Auto', 'Voiture', 'Coche', '4', NULL, 4, 'Home', 103, 104),
(44, 'GRCHM$HDR1$LBL2', 'Fan Mode', 'LÃ¼fter-Modus', 'ModalitÃ  fan', 'Mode ventilateur ', 'Modo de ventilaciÃ³n', NULL, 'fieldlabel', NULL, 'Home', 106, 113),
(45, 'GRCHM$HDR1$LBL2$DDI1', 'Auto', 'Auto', 'Auto', 'Voiture', 'Coche', '1', NULL, 1, 'Home', 107, 108),
(46, 'GRCHM$HDR1$LBL2$DDI2', 'On', 'Auf', 'Su', 'Sur', 'En', '2', NULL, 2, 'Home', 109, 110),
(47, 'GRCHM$HDR1$LBL2$DDI3', 'Schedule', 'Zeitplan', 'Calendario', 'Annexe', 'Horario', '3', NULL, 3, 'Home', 111, 112),
(48, 'GRCHM$HDR1$LBL3', 'Setback Status', 'RÃ¼ckschlag-Status', 'Stato di transizione', 'Statut de revers ', 'Estado de retroceso', NULL, 'fieldlabel', NULL, 'Home', 114, 121),
(49, 'GRCHM$HDR1$LBL3$DDI1', 'Normal', 'Normal', 'Normale', 'Normal', 'Normal', '1', NULL, 1, 'Home', 115, 116),
(50, 'GRCHM$HDR1$LBL3$DDI2', 'Hold', 'Halten', 'Tenere', 'Cale', 'Mantenga', '2', NULL, 2, 'Home', 117, 118),
(51, 'GRCHM$HDR1$LBL3$DDI3', 'Override', 'Ãœberschreiben', 'Eseguire l''override', 'Substituez', 'AnulaciÃ³n', '3', NULL, 3, 'Home', 119, 120),
(52, 'GRCHM$HDR1$LBL4', 'Setback Heat', 'RÃ¼ckschlag-Hitze', 'Battuta d''arresto calore', 'Chaleur de revers ', 'Calor de revÃ©s', NULL, 'fieldlabel', NULL, 'Home', 122, 123),
(53, 'GRCHM$HDR1$LBL5', 'Setback Cool', 'RÃ¼ckschlag Cool', 'Battuta d''arresto Cool', 'Revers Cool ', 'Cool de revÃ©s', NULL, 'fieldlabel', NULL, 'Home', 124, 125),
(54, 'GRCHM$HDR2', 'Setback Scheduling', 'RÃ¼ckschlag zu planen', 'Battuta d''arresto di pianificazione', 'Planification des revers', 'ProgramaciÃ³n de revÃ©s', NULL, 'sectionheader', NULL, 'Home', 127, 180),
(55, 'GRCHM$HDR2$CPT1', 'Day Class Schedules', 'Tag StundenplÃ¤ne', 'Giorno orari di classe', 'Jour horaires de classe', 'Horarios dÃ­a', NULL, 'subsectionheader', NULL, 'Home', 128, 129),
(56, 'GRCHM$HDR2$CPT2', 'Default Weekly Schedule', 'Standard-Wochenplan', 'Pianificazione settimanale predefinita', 'Horaire hebdomadaire par dÃ©faut', 'ProgramaciÃ³n semanal de predeterminada', NULL, 'subsectionheader', NULL, 'Home', 130, 131),
(57, 'GRCHM$HDR2$CLM1', 'Occupied', 'Besetzt', 'Occupato', 'OccupÃ©', 'Ocupada', NULL, 'occupied', NULL, 'Home', 140, 141),
(58, 'GRCHM$HDR2$CLM2', 'Unoccupied', 'Unbesetzt', 'Non occupato', 'InoccupÃ©', 'Desocupada', NULL, 'unoccupied', NULL, 'Home', 142, 143),
(59, 'GRCHM$HDR2$CLM3', 'Other', 'Andere', 'Altri', 'Autres', 'Otros', NULL, 'other', NULL, 'Home', 144, 145),
(60, 'GRCHM$HDR2$SCL1', 'Period', 'Zeitraum', 'Periodo', 'PÃ©riode', 'PerÃ­odo', NULL, NULL, NULL, 'Home', 160, 161),
(61, 'GRCHM$HDR2$SCL2', 'Time', 'Zeit', 'Tempo', 'Temps', 'Tiempo', NULL, NULL, NULL, 'Home', 162, 163),
(62, 'GRCHM$HDR2$SCL3', 'Heat', 'WÃ¤rme', 'Calore', 'Chaleur', 'Calor', NULL, 'heat', NULL, 'Home', 164, 165),
(63, 'GRCHM$HDR2$SCL4', 'Cool', 'Cool', 'Cool', 'Cool', 'Cool', NULL, 'cool', NULL, 'Home', 166, 167),
(64, 'GRCHM$HDR2$SCL5', 'Fan', 'LÃ¼fter', 'Ventilatore', 'Ventilateur', 'Ventilador', NULL, NULL, NULL, 'Home', 168, 173),
(65, 'GRCHM$HDR2$SCL5$DDI1', 'Off', 'Ausschalten', 'Fuori', 'Hors', 'Apagado', '0', NULL, 1, 'Home', 169, 170),
(66, 'GRCHM$HDR2$SCL5$DDI2', 'On', 'Auf', 'Su', 'Sur', 'En', '60', NULL, 2, 'Home', 171, 172),
(67, 'GRCHM$HDR2$CLM4', 'Sunday', 'Sonntag', 'Domenica', 'Dimanche', 'Domingo', NULL, NULL, NULL, 'Home', 146, 147),
(68, 'GRCHM$HDR2$CLM5', 'Monday', 'Montag', 'LunedÃ¬', 'Lundi', 'Lunes', NULL, NULL, NULL, 'Home', 148, 149),
(69, 'GRCHM$HDR2$CLM6', 'Tuesday', 'Dienstag', 'MartedÃ¬', 'Mardi', 'Martes', NULL, NULL, NULL, 'Home', 150, 151),
(70, 'GRCHM$HDR2$CLM7', 'Wednesday', 'Mittwoch', 'MercoledÃ¬', 'Mercredi', 'MiÃ©rcoles', NULL, NULL, NULL, 'Home', 152, 153),
(71, 'GRCHM$HDR2$CLM8', 'Thursday', 'Donnerstag', 'GiovedÃ¬', 'Jeudi', 'Jueves', NULL, NULL, NULL, 'Home', 154, 155),
(72, 'GRCHM$HDR2$CLM9', 'Friday', 'Freitag', 'VenerdÃ¬', 'Vendredi', 'Viernes', NULL, NULL, NULL, 'Home', 156, 157),
(73, 'GRCHM$HDR2$CLM10', 'Saturday', 'Samstag', 'Sabato', 'Samedi', 'SÃ¡bado', NULL, NULL, NULL, 'Home', 158, 159),
(74, 'GRCHM$HDR2$LBL1', 'Morning', 'Morgen', 'Mattina', 'Matin', 'Por la maÃ±ana', NULL, 'periodlabelcell', NULL, 'Home', 132, 133),
(75, 'GRCHM$HDR2$LBL2', 'Day', 'Tag', 'Giorno', 'JournÃ©e', 'DÃ­a', NULL, 'periodlabelcell', NULL, 'Home', 134, 135),
(76, 'GRCHM$HDR2$LBL3', 'Evening', '''Nabend', 'Sera', 'SoirÃ©e', 'Por la noche', NULL, 'periodlabelcell', NULL, 'Home', 136, 137),
(77, 'GRCHM$HDR2$LBL4', 'Night', 'Nacht', 'Notte', 'Nuit', 'Noche', NULL, 'periodlabelcell', NULL, 'Home', 138, 139),
(78, 'GRCHM$HDR2$DDI1', 'Occupied', 'Besetzt', 'Occupato', 'OccupÃ©', 'Ocupada', '1', 'occupied', 1, 'Home', 174, 175),
(79, 'GRCHM$HDR2$DDI2', 'Unoccupied', 'Unbesetzt', 'Non occupato', 'InoccupÃ©', 'Desocupada', '2', 'unoccupied', 2, 'Home', 176, 177),
(80, 'GRCHM$HDR2$DDI3', 'Other', 'Andere', 'Altri', 'Autres', 'Otros', '3', 'other', 3, 'Home', 178, 179),
(81, 'GRCHM$HDR3', 'Sensor Settings', 'Sensoreinstellungen', 'Impostazioni sensore', 'ParamÃ¨tres de capteur', 'ConfiguraciÃ³n del sensor', NULL, 'sectionheader', NULL, 'Home', 181, 198),
(82, 'GRCHM$HDR3$LBL1', 'Local Sensor', 'Lokaler Sensor', 'Sensore locale', 'Capteur local', 'Sensor local', NULL, 'sensorlabelcell', NULL, 'Home', 182, 183),
(83, 'GRCHM$HDR3$LBL2', 'Remote Sensor 1', 'FernfÃ¼hler 1', 'Sensore remoto 1', '1 Capteur de tÃ©lÃ©commande', 'Sensor remoto 1', NULL, 'sensorlabelcell', NULL, 'Home', 184, 185),
(84, 'GRCHM$HDR3$LBL3', 'Remote Sensor 2', 'FernfÃ¼hler 2', 'Sensore remoto 2', 'Capteur de tÃ©lÃ©commande 2', 'Sensor remoto 2', NULL, 'sensorlabelcell', NULL, 'Home', 186, 187),
(85, 'GRCHM$HDR3$CLM1', 'State', 'Zustand', 'Stato', 'Ã‰tat', 'Estado', NULL, NULL, NULL, 'Home', 188, 189),
(86, 'GRCHM$HDR3$CLM2', 'Averaging', 'Mit durchschnittlich', 'Media', 'Avec une moyenne', 'Con un promedio de', NULL, NULL, NULL, 'Home', 190, 191),
(87, 'GRCHM$HDR3$CLM3', 'Correction', 'Korrektur', 'Correzione', 'Correction', 'CorrecciÃ³n', NULL, NULL, NULL, 'Home', 192, 193),
(88, 'GRCHM$HDR3$DDI1', 'Disabled', 'Behinderte', 'Disabili', 'HandicapÃ©s', 'Discapacitados', '1', NULL, 1, 'Home', 194, 195),
(89, 'GRCHM$HDR3$DDI2', 'Enabled', 'Aktiviert', 'Abilitato', 'ActivÃ©', 'Habilitado', '2', NULL, 2, 'Home', 196, 197),
(91, 'GRCHM$BTN1', 'Submit', 'Senden', 'Invia', 'Envoyer', 'Enviar', NULL, 'commandbutton', NULL, 'Home', 199, 200),
(92, 'GRCHM$CLM8$LBL1', 'Username:', 'Benutzername:', 'Nome utente:', 'Nom d''utilisateur :', 'Nombre de usuario:', NULL, 'fieldlabel', NULL, 'Home', 70, 71),
(93, 'GRCHM$CLM8$LBL2', 'Password:', 'Passwort:', 'Password:', 'Mot de passe :', 'ContraseÃ±a:', NULL, 'fieldlabel', NULL, 'Home', 72, 73),
(94, 'GRCHM$CLM8$BTN1', 'Save', 'Speichern', 'Salvare', 'Enregistrer', 'Guardar', NULL, 'commandbutton', NULL, 'Home', 74, 75),
(95, 'GRCHM$CLM8$BTN2', 'Cancel', 'Abbrechen', 'Annulla', 'Annuler', 'Cancelar', NULL, 'commandbutton', NULL, 'Home', 76, 77),
(96, 'GRCTL', 'Transaction History', 'Transaktionshistorie', 'Cronologia delle transazioni', 'Historique des transactions', 'Historial de transacciones', NULL, NULL, NULL, 'Transaction Log', 204, 221),
(97, 'GRCTL$HLK1', 'Home', 'Startseite', 'Casa', 'Accueil', 'PÃ¡gina de inicio', NULL, NULL, NULL, 'Transaction Log', 207, 208),
(98, 'GRCTL$HLK2', 'Clear Search', 'Suche lÃ¶schen', 'Ricerca chiara', 'Effacer la recherche', 'Borrar bÃºsqueda', NULL, NULL, NULL, 'Transaction Log', 209, 210),
(99, 'GRCTL$CLM1', 'Thermostat', 'Thermostat', 'Termostato', 'Thermostat', 'Termostato', NULL, NULL, NULL, 'Transaction Log', 211, 212),
(100, 'GRCTL$CLM2', 'Field', 'Feld', 'Campo', 'Champ', 'Campo', NULL, NULL, NULL, 'Transaction Log', 213, 214),
(101, 'GRCTL$CLM3', 'Old Value', 'Der alte Wert', 'Valore precedente', 'Ancienne valeur', 'Valor antiguo', NULL, NULL, NULL, 'Transaction Log', 215, 216),
(102, 'GRCTL$CLM4', 'New Value', 'Neuen Wert', 'Nuovo valore', 'Nouvelle valeur', 'Nuevo valor', NULL, NULL, NULL, 'Transaction Log', 217, 218),
(103, 'GRCTL$CLM5', 'Timestamp', 'Timestamp', 'Timestamp', 'Timestamp', 'Fecha y hora', NULL, NULL, NULL, 'Transaction Log', 219, 220),
(104, 'GRCTL$LBL1', 'Search:', 'Suche:', 'Ricerca:', 'Rechercher :', 'BÃºsqueda:', NULL, NULL, NULL, 'Transaction Log', 205, 206),
(105, 'GRCHM$MSG6', 'Are you sure you want to delete this thermostat?', 'Sind Sie sicher, dass Sie dieses Thermostat lÃ¶schen mÃ¶chten?', 'Sei sicuro di che voler eliminare questo termostato?', 'ÃŠtes-vous sÃ»r de que vouloir supprimer ce thermostat ?', 'Â¿EstÃ¡ seguro que desea eliminar este termostato?', NULL, NULL, NULL, 'Home', 33, 34),
(106, 'GRC', 'GNU Remote Control', 'GNU Remote Control', 'GNU Remote Control', 'GNU Remote Control', 'GNU Remote Control', NULL, NULL, NULL, '*', 1, 272),
(112, 'GRC$MSG1', 'Could not create XMLHttpRequest object', 'XMLHttpRequest-Objekt konnte nicht erstellt werden.', 'Non può creare l''oggetto XMLHttpRequest', 'Pas pu créer d''objet XMLHttpRequest', 'No se pudo crear el objeto XMLHttpRequest', NULL, NULL, NULL, '*', 2, 3),
(113, 'GRC$MSG2', 'An error occurred, but the error message cannot be displayed. This is probably because of your browser''s pop-up blocker. \n Please allow pop-ups from this web site if you want to see the full error messages. \n\n Status Code: {0}\n Status Description: {1}', 'Ist ein Fehler aufgetreten, aber die Fehlermeldung nicht angezeigt werden. Dieses ist vermutlich wegen Popup-Blocker Ihres Browsers. \n Bitte erlauben Sie Popups von dieser Website, wenn die vollständigen Fehlermeldungen angezeigt werden sollen. \n\n Statuscode: {0} Statusbeschreibung: {1}', 'Si è verificato un errore, ma non può essere visualizzato il messaggio di errore. Questo è probabilmente a causa del blocco popup del vostro browser. \n Si prega di consentire i popup da questo sito web se si desidera visualizzare i messaggi di errore completo. \n\n Codice di stato: descrizione dello stato {0}: {1}.', 'Une erreur s''est produite, mais impossible d''afficher le message d''erreur. C''est probablement à cause du bloqueur de fenêtres publicitaires de votre navigateur. \n Veuillez prévoir des fenêtres publicitaires intempestives de ce site web si vous souhaitez afficher les messages d''erreur complet. \n\n Code d''État : {0} Description de l''État : {1}', 'Se ha producido un error, pero no se puede mostrar el mensaje de error. Esto es probablemente debido al bloqueador de elementos emergentes de su navegador. \n Por favor permita las ventanas emergentes de este sitio web si desea ver los mensajes de error completo. \n\n Código de estado: {0} Estado Descripción: {1}', NULL, NULL, NULL, '*', 4, 5),
(114, 'GRCHM$CLM9', 'Time Zone Offset', 'Zeitzonenoffset', 'Offset del fuso orario', 'DÃ©calage de fuseau horaire', 'Zona horaria', NULL, NULL, NULL, 'Home', 79, 82),
(115, 'GRCHM$BTN2', 'Set Time on Selected Thermostats', 'Eingestellten Zeit auf ausgewÃ¤hlten Thermostate', 'Tempo impostato su termostati selezionati', 'DurÃ©e rÃ©glÃ©e sur certains Thermostats', 'Tiempo en termostatos seleccionados', NULL, 'commandbutton', NULL, 'Home', 201, 202),
(116, 'GRCHM$LBL8', '{0} (at page load)', '{0} (bei Laden der Seite)', '{0} (al caricamento della pagina)', '{0} (au chargement de la page)', '{0} (en la carga de la pÃ¡gina)', NULL, NULL, NULL, 'Home', 21, 22),
(117, 'GRCHM$CLM9$DDI1', '-- Select Offset --', '-WÃ¤hlen Sie Offset-', '-- Selezionare Offset-', '--SÃ©lectionnez Offset--', '--Seleccione desvÃ­o--', '', NULL, 1, 'Home', 80, 81),
(118, 'GRCAD', 'Administration', 'Verwaltung', 'Gestione', 'Gestion', 'GestiÃ³n', NULL, NULL, NULL, 'Admin', 222, 271),
(119, 'GRCAD$HDR1$LBL1', 'Total User Accounts:', 'Gesamt-Benutzerkonten:', 'Account utente totale:', 'Comptes d''utilisateurs total:', 'Cuentas de usuario total:', NULL, NULL, NULL, 'Admin', 226, 227),
(120, 'GRCAD$HDR1$LBL2', 'Total Thermostats:', 'Gesamt-Thermostate:', 'Termostati totale:', 'Thermostats totales:', 'Termostatos totales:', NULL, NULL, NULL, 'Admin', 228, 229),
(121, 'GRCAD$HDR1$CLM1', 'User Name', 'Benutzername', 'Nome utente', 'Nom d''utilisateur', 'Nombre de usuario', NULL, NULL, NULL, 'Admin', 242, 243),
(122, 'GRCAD$HDR1$CLM2', 'Maximum # Thermostats', 'Maximum Thermostate', 'Termostati massimi', 'Thermostats maximales', 'Termostatos de mÃ¡ximos', NULL, NULL, NULL, 'Admin', 244, 245),
(123, 'GRCAD$HDR1$CLM3', 'Language', 'Sprache', 'Lingua', 'Langue', 'Idioma', NULL, NULL, NULL, 'Admin', 246, 249),
(124, 'GRCAD$HDR1$HLK1', 'Add', 'HinzufÃ¼gen', 'Aggiungi', 'Ajouter', 'AÃ±adir', NULL, 'add', NULL, 'Admin', 232, 233),
(125, 'GRCAD$HDR1$HLK2', 'Edit', 'Bearbeiten', 'Modifica', 'Edit', 'Editar', NULL, 'edit', NULL, 'Admin', 234, 235),
(126, 'GRCAD$HDR1$HLK3', 'Update', 'Update', 'Aggiornamento', 'Mise Ã  jour', 'ActualizaciÃ³n', NULL, 'update', NULL, 'Admin', 236, 237),
(127, 'GRCAD$HDR1$HLK4', 'Cancel', 'Abbrechen', 'Annulla', 'Annuler', 'Cancelar', NULL, 'cancel', NULL, 'Admin', 238, 239),
(128, 'GRCAD$HDR1$HLK5', 'Delete', 'LÃ¶schen', 'Eliminare', 'Supprimer', 'Borrar', NULL, 'delete', NULL, 'Admin', 240, 241),
(130, 'GRCHM$CLM10', 'Group', 'Gruppe', 'Gruppo', 'Groupe', 'Grupo', NULL, NULL, NULL, 'Home', 83, 86),
(131, 'GRCAD$HDR1', 'User Accounts', 'Benutzer-Accounts', 'Account utente', 'Comptes d''utilisateurs', 'Cuentas de usuario', NULL, 'sectionheader', NULL, 'Admin', 225, 250),
(132, 'GRCAD$HDR2', 'Groups', 'Gruppen', 'Gruppo', 'Groupe', 'Grupo', NULL, 'sectionheader', NULL, 'Admin', 251, 270),
(133, 'GRCAD$HDR2$HLK1', 'Add', 'Hinzuf gen', 'Hinzuf gen', 'Hinzuf gen', 'Gen Hinzuf', NULL, 'add', NULL, 'Admin', 256, 257),
(134, 'GRCAD$HDR2$HLK2', 'Edit', 'Bearbeiten', 'Modifica', 'Edit', 'Editar', NULL, 'edit', NULL, 'Admin', 258, 259),
(135, 'GRCAD$HDR2$HLK3', 'Update', 'Update', 'Aggiornamento', 'Mise Ã  jour', 'ActualizaciÃ³n', NULL, 'update', NULL, 'Admin', 260, 261),
(136, 'GRCAD$HDR2$HLK4', 'Cancel', 'Abbrechen', 'Annulla', 'Annuler', 'Cancelar', NULL, 'cancel', NULL, 'Admin', 262, 263),
(137, 'GRCAD$HDR2$HLK5', 'Delete', 'Lï¿½schen', 'Cancella', 'Supprimer', 'Borrar', NULL, 'delete', NULL, 'Admin', 264, 265),
(138, 'GRCAD$HDR2$CLM1', 'Group Name', 'Gruppenname', 'Gruppenname', 'Gruppenname', 'Gruppenname', NULL, NULL, NULL, 'Admin', 266, 267),
(139, 'GRCAD$HDR2$CLM2', 'Description', 'Beschreibung', 'Descrizione', 'Description', 'DescripciÃ³n', NULL, NULL, NULL, 'Admin', 268, 269),
(140, 'GRCHM$CLM10$DDL1', '-- Select Group --', '--Gruppe auswÃ¤hlen--', '-Seleziona gruppo hlen...', '-SÃ©lectionner un groupe hlen--', '-Seleccionar grupo hlen...', '', NULL, 1, 'Home', 84, 85),
(143, 'GRCAD$LBL1', 'Highlighted fields are required.', 'Markierten Felder mï¿½ssen ausgefï¿½llt werden.', 'I campi contrassegnati m ssen eseguito cadute.', 'Les champs marquÃ©s m ssen exÃ©cutÃ© chutes.', 'Los campos marcados m ssen ejecutado caÃ­das.', NULL, 'requirednote', NULL, 'Admin', 223, 224),
(144, 'GRCAD$HDR2$LBL1', 'Total Groups:', 'Gesamt Gruppen:', 'Totale gruppi:', 'Totales groupes:', 'Totales grupos:', NULL, NULL, NULL, 'Admin', 252, 253),
(145, 'GRCAD$HDR1$MSG1', 'Some required fields have been left blank. User Name, Maximum # Thermostats, and Language are required.', 'Einige erforderliche Felder leer gelassen. Benutzername, Maximum # Thermostate und Sprache sind erforderlich.', 'Alcuni campi obbligatori lasciato vuoti. Sono necessari username, termostati # massimo e lingua.', 'Certains champs obligatoires laissÃ©es en blancs. Nom d''utilisateur, thermostats # maximale et la langue sont nÃ©cessaires.', 'Algunos campos obligatorios dejaron en blanco. Nombre de usuario, termostatos de mÃ¡xima # y lengua son necesarios.', NULL, NULL, NULL, 'Admin', 230, 231),
(146, 'GRCAD$HDR2$MSG1', 'Some required fields have been left blank. Group Name is required.', 'Einige erforderliche Felder leer gelassen. Gruppenname ist erforderlich.', 'Alcuni campi obbligatori lasciato vuoti. Nome del gruppo Ã¨ richiesto.', 'Certains champs obligatoires laissÃ©es en blancs. Nom du groupe est nÃ©cessaire.', 'Algunos campos obligatorios dejaron en blanco. Nombre del grupo es necesaria.', NULL, NULL, NULL, 'Admin', 254, 255),
(147, 'GRCAD$HDR1$CLM3$DDI1', '-- Select Language --', '--Wï¿½hlen Sie Sprache--', 'Lingua - scegliere -W', 'W - choisir langue-', '-W elegir idioma', '', NULL, 0, 'Admin', 247, 248);

-- 
-- Dumping data for table thermostat
--

-- Table iptstat.thermostat does not contain any data (it is empty)

-- 
-- Dumping data for table thermostatgroups
--

-- Table iptstat.thermostatgroups does not contain any data (it is empty)

-- 
-- Dumping data for table timezoneoffset
--
INSERT INTO timezoneoffset VALUES
(1, 'GMT -12:00', -12.0),
(2, 'GMT -11:30', -11.5),
(3, 'GMT -11:00', -11.0),
(4, 'GMT -10:30', -10.5),
(5, 'GMT -10:00', -10.0),
(6, 'GMT -9:30', -9.5),
(7, 'GMT -9:00', -9.0),
(8, 'GMT -8:30', -8.5),
(9, 'GMT -8:00', -8.0),
(10, 'GMT -7:30', -7.5),
(11, 'GMT -7:00', -7.0),
(12, 'GMT -6:30', -6.5),
(13, 'GMT -6:00', -6.0),
(14, 'GMT -5:30', -5.5),
(15, 'GMT -5:00', -5.0),
(16, 'GMT -4:30', -4.5),
(17, 'GMT -4:00', -4.0),
(18, 'GMT -3:30', -3.5),
(19, 'GMT -3:00', -3.0),
(20, 'GMT -2:30', -2.5),
(21, 'GMT -2:00', -2.0),
(22, 'GMT -1:30', -1.5),
(23, 'GMT -1:00', -1.0),
(24, 'GMT -0:30', -0.5),
(25, 'GMT 0:00', 0.0),
(26, 'GMT 0:30', 0.5),
(27, 'GMT 1:00', 1.0),
(28, 'GMT 1:30', 1.5),
(29, 'GMT 2:00', 2.0),
(30, 'GMT 2:30', 2.5),
(31, 'GMT 3:00', 3.0),
(32, 'GMT 3:30', 3.5),
(33, 'GMT 4:00', 4.0),
(34, 'GMT 4:30', 4.5),
(35, 'GMT 5:00', 5.0),
(36, 'GMT 5:30', 5.5),
(37, 'GMT 6:00', 6.0),
(38, 'GMT 6:30', 6.5),
(39, 'GMT 7:00', 7.0),
(40, 'GMT 7:30', 7.5),
(41, 'GMT 8:00', 8.0),
(42, 'GMT 8:30', 8.5),
(43, 'GMT 9:00', 9.0),
(44, 'GMT 9:30', 9.5),
(45, 'GMT 10:00', 10.0),
(46, 'GMT 10:30', 10.5),
(47, 'GMT 11:00', 11.0),
(48, 'GMT 11:30', 11.5),
(49, 'GMT 12:00', 12.0);

-- 
-- Dumping data for table transactionlog
--
INSERT INTO transactionlog VALUES
(1, 1, '2', 'qwe', 'ewq', '2013-06-05 17:19:19', 0);

-- 
-- Dumping data for table user
--

-- Table iptstat.user does not contain any data (it is empty)

-- 
-- Enable foreign keys
-- 
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;