#! /bin/sh

TEMPDIR=/tmp/pspp-tst-$$
mkdir -p $TEMPDIR
trap 'cd /; rm -rf $TEMPDIR' 0

# ensure that top_builddir  are absolute
if [ -z "$top_builddir" ] ; then top_builddir=. ; fi
if [ -z "$top_srcdir" ] ; then top_srcdir=. ; fi
top_builddir=`cd $top_builddir; pwd`
PSPP=$top_builddir/src/ui/terminal/pspp

# ensure that top_srcdir is absolute
top_srcdir=`cd $top_srcdir; pwd`

STAT_CONFIG_PATH=$top_srcdir/config
export STAT_CONFIG_PATH

fail()
{
    echo $activity
    echo FAILED
    exit 1;
}


no_result()
{
    echo $activity
    echo NO RESULT;
    exit 2;
}

pass()
{
    exit 0;
}

cd $TEMPDIR

activity="write pspp syntax"
cat > month-out.pspp <<EOF
set errors=none.
set mxwarns=10000000.
data list /x 1-10.
begin data.

0
0.5
0.9
1
2
3
4
4.1
4.5
4.9
5
6
7
7.1
7.5
7.9
8
9
10
11
12
13
end data.
print outfile='month-out.out'/x(month3).
print outfile='month-out.out'/x(month4).
print outfile='month-out.out'/x(month5).
print outfile='month-out.out'/x(month6).
print outfile='month-out.out'/x(month7).
print outfile='month-out.out'/x(month8).
print outfile='month-out.out'/x(month9).
print outfile='month-out.out'/x(month10).
print outfile='month-out.out'/x(month11).
print outfile='month-out.out'/x(month12).
print outfile='month-out.out'/x(month13).
print outfile='month-out.out'/x(month14).
print outfile='month-out.out'/x(month15).
print outfile='month-out.out'/x(month16).
print outfile='month-out.out'/x(month17).
print outfile='month-out.out'/x(month18).
print outfile='month-out.out'/x(month19).
print outfile='month-out.out'/x(month20).
print outfile='month-out.out'/x(month21).
print outfile='month-out.out'/x(month22).
print outfile='month-out.out'/x(month23).
print outfile='month-out.out'/x(month24).
print outfile='month-out.out'/x(month25).
print outfile='month-out.out'/x(month26).
print outfile='month-out.out'/x(month27).
print outfile='month-out.out'/x(month28).
print outfile='month-out.out'/x(month29).
print outfile='month-out.out'/x(month30).
print outfile='month-out.out'/x(month31).
print outfile='month-out.out'/x(month32).
print outfile='month-out.out'/x(month33).
print outfile='month-out.out'/x(month34).
print outfile='month-out.out'/x(month35).
print outfile='month-out.out'/x(month36).
print outfile='month-out.out'/x(month37).
print outfile='month-out.out'/x(month38).
print outfile='month-out.out'/x(month39).
print outfile='month-out.out'/x(month40).
execute.
EOF
if [ $? -ne 0 ] ; then no_result ; fi

activity="run program"
$SUPERVISOR $PSPP --testing-mode month-out.pspp
if [ $? -eq 0 ] ; then no_result ; fi

activity="compare output"
diff -u month-out.out - <<EOF 
   .
    .
     .
      .
       .
        .
         .
          .
           .
            .
             .
              .
               .
                .
                 .
                  .
                   .
                    .
                     .
                      .
                       .
                        .
                         .
                          .
                           .
                            .
                             .
                              .
                               .
                                .
                                 .
                                  .
                                   .
                                    .
                                     .
                                      .
                                       .
                                        .
   .
    .
     .
      .
       .
        .
         .
          .
           .
            .
             .
              .
               .
                .
                 .
                  .
                   .
                    .
                     .
                      .
                       .
                        .
                         .
                          .
                           .
                            .
                             .
                              .
                               .
                                .
                                 .
                                  .
                                   .
                                    .
                                     .
                                      .
                                       .
                                        .
   .
    .
     .
      .
       .
        .
         .
          .
           .
            .
             .
              .
               .
                .
                 .
                  .
                   .
                    .
                     .
                      .
                       .
                        .
                         .
                          .
                           .
                            .
                             .
                              .
                               .
                                .
                                 .
                                  .
                                   .
                                    .
                                     .
                                      .
                                       .
                                        .
   .
    .
     .
      .
       .
        .
         .
          .
           .
            .
             .
              .
               .
                .
                 .
                  .
                   .
                    .
                     .
                      .
                       .
                        .
                         .
                          .
                           .
                            .
                             .
                              .
                               .
                                .
                                 .
                                  .
                                   .
                                    .
                                     .
                                      .
                                       .
                                        .
 JAN
 JANU
 JANUA
 JANUAR
 JANUARY
 JANUARY 
 JANUARY  
 JANUARY   
 JANUARY    
 JANUARY     
 JANUARY      
 JANUARY       
 JANUARY        
 JANUARY         
 JANUARY          
 JANUARY           
 JANUARY            
 JANUARY             
 JANUARY              
 JANUARY               
 JANUARY                
 JANUARY                 
 JANUARY                  
 JANUARY                   
 JANUARY                    
 JANUARY                     
 JANUARY                      
 JANUARY                       
 JANUARY                        
 JANUARY                         
 JANUARY                          
 JANUARY                           
 JANUARY                            
 JANUARY                             
 JANUARY                              
 JANUARY                               
 JANUARY                                
 JANUARY                                 
 FEB
 FEBR
 FEBRU
 FEBRUA
 FEBRUAR
 FEBRUARY
 FEBRUARY 
 FEBRUARY  
 FEBRUARY   
 FEBRUARY    
 FEBRUARY     
 FEBRUARY      
 FEBRUARY       
 FEBRUARY        
 FEBRUARY         
 FEBRUARY          
 FEBRUARY           
 FEBRUARY            
 FEBRUARY             
 FEBRUARY              
 FEBRUARY               
 FEBRUARY                
 FEBRUARY                 
 FEBRUARY                  
 FEBRUARY                   
 FEBRUARY                    
 FEBRUARY                     
 FEBRUARY                      
 FEBRUARY                       
 FEBRUARY                        
 FEBRUARY                         
 FEBRUARY                          
 FEBRUARY                           
 FEBRUARY                            
 FEBRUARY                             
 FEBRUARY                              
 FEBRUARY                               
 FEBRUARY                                
 MAR
 MARC
 MARCH
 MARCH 
 MARCH  
 MARCH   
 MARCH    
 MARCH     
 MARCH      
 MARCH       
 MARCH        
 MARCH         
 MARCH          
 MARCH           
 MARCH            
 MARCH             
 MARCH              
 MARCH               
 MARCH                
 MARCH                 
 MARCH                  
 MARCH                   
 MARCH                    
 MARCH                     
 MARCH                      
 MARCH                       
 MARCH                        
 MARCH                         
 MARCH                          
 MARCH                           
 MARCH                            
 MARCH                             
 MARCH                              
 MARCH                               
 MARCH                                
 MARCH                                 
 MARCH                                  
 MARCH                                   
 APR
 APRI
 APRIL
 APRIL 
 APRIL  
 APRIL   
 APRIL    
 APRIL     
 APRIL      
 APRIL       
 APRIL        
 APRIL         
 APRIL          
 APRIL           
 APRIL            
 APRIL             
 APRIL              
 APRIL               
 APRIL                
 APRIL                 
 APRIL                  
 APRIL                   
 APRIL                    
 APRIL                     
 APRIL                      
 APRIL                       
 APRIL                        
 APRIL                         
 APRIL                          
 APRIL                           
 APRIL                            
 APRIL                             
 APRIL                              
 APRIL                               
 APRIL                                
 APRIL                                 
 APRIL                                  
 APRIL                                   
 APR
 APRI
 APRIL
 APRIL 
 APRIL  
 APRIL   
 APRIL    
 APRIL     
 APRIL      
 APRIL       
 APRIL        
 APRIL         
 APRIL          
 APRIL           
 APRIL            
 APRIL             
 APRIL              
 APRIL               
 APRIL                
 APRIL                 
 APRIL                  
 APRIL                   
 APRIL                    
 APRIL                     
 APRIL                      
 APRIL                       
 APRIL                        
 APRIL                         
 APRIL                          
 APRIL                           
 APRIL                            
 APRIL                             
 APRIL                              
 APRIL                               
 APRIL                                
 APRIL                                 
 APRIL                                  
 APRIL                                   
 APR
 APRI
 APRIL
 APRIL 
 APRIL  
 APRIL   
 APRIL    
 APRIL     
 APRIL      
 APRIL       
 APRIL        
 APRIL         
 APRIL          
 APRIL           
 APRIL            
 APRIL             
 APRIL              
 APRIL               
 APRIL                
 APRIL                 
 APRIL                  
 APRIL                   
 APRIL                    
 APRIL                     
 APRIL                      
 APRIL                       
 APRIL                        
 APRIL                         
 APRIL                          
 APRIL                           
 APRIL                            
 APRIL                             
 APRIL                              
 APRIL                               
 APRIL                                
 APRIL                                 
 APRIL                                  
 APRIL                                   
 APR
 APRI
 APRIL
 APRIL 
 APRIL  
 APRIL   
 APRIL    
 APRIL     
 APRIL      
 APRIL       
 APRIL        
 APRIL         
 APRIL          
 APRIL           
 APRIL            
 APRIL             
 APRIL              
 APRIL               
 APRIL                
 APRIL                 
 APRIL                  
 APRIL                   
 APRIL                    
 APRIL                     
 APRIL                      
 APRIL                       
 APRIL                        
 APRIL                         
 APRIL                          
 APRIL                           
 APRIL                            
 APRIL                             
 APRIL                              
 APRIL                               
 APRIL                                
 APRIL                                 
 APRIL                                  
 APRIL                                   
 MAY
 MAY 
 MAY  
 MAY   
 MAY    
 MAY     
 MAY      
 MAY       
 MAY        
 MAY         
 MAY          
 MAY           
 MAY            
 MAY             
 MAY              
 MAY               
 MAY                
 MAY                 
 MAY                  
 MAY                   
 MAY                    
 MAY                     
 MAY                      
 MAY                       
 MAY                        
 MAY                         
 MAY                          
 MAY                           
 MAY                            
 MAY                             
 MAY                              
 MAY                               
 MAY                                
 MAY                                 
 MAY                                  
 MAY                                   
 MAY                                    
 MAY                                     
 JUN
 JUNE
 JUNE 
 JUNE  
 JUNE   
 JUNE    
 JUNE     
 JUNE      
 JUNE       
 JUNE        
 JUNE         
 JUNE          
 JUNE           
 JUNE            
 JUNE             
 JUNE              
 JUNE               
 JUNE                
 JUNE                 
 JUNE                  
 JUNE                   
 JUNE                    
 JUNE                     
 JUNE                      
 JUNE                       
 JUNE                        
 JUNE                         
 JUNE                          
 JUNE                           
 JUNE                            
 JUNE                             
 JUNE                              
 JUNE                               
 JUNE                                
 JUNE                                 
 JUNE                                  
 JUNE                                   
 JUNE                                    
 JUL
 JULY
 JULY 
 JULY  
 JULY   
 JULY    
 JULY     
 JULY      
 JULY       
 JULY        
 JULY         
 JULY          
 JULY           
 JULY            
 JULY             
 JULY              
 JULY               
 JULY                
 JULY                 
 JULY                  
 JULY                   
 JULY                    
 JULY                     
 JULY                      
 JULY                       
 JULY                        
 JULY                         
 JULY                          
 JULY                           
 JULY                            
 JULY                             
 JULY                              
 JULY                               
 JULY                                
 JULY                                 
 JULY                                  
 JULY                                   
 JULY                                    
 JUL
 JULY
 JULY 
 JULY  
 JULY   
 JULY    
 JULY     
 JULY      
 JULY       
 JULY        
 JULY         
 JULY          
 JULY           
 JULY            
 JULY             
 JULY              
 JULY               
 JULY                
 JULY                 
 JULY                  
 JULY                   
 JULY                    
 JULY                     
 JULY                      
 JULY                       
 JULY                        
 JULY                         
 JULY                          
 JULY                           
 JULY                            
 JULY                             
 JULY                              
 JULY                               
 JULY                                
 JULY                                 
 JULY                                  
 JULY                                   
 JULY                                    
 JUL
 JULY
 JULY 
 JULY  
 JULY   
 JULY    
 JULY     
 JULY      
 JULY       
 JULY        
 JULY         
 JULY          
 JULY           
 JULY            
 JULY             
 JULY              
 JULY               
 JULY                
 JULY                 
 JULY                  
 JULY                   
 JULY                    
 JULY                     
 JULY                      
 JULY                       
 JULY                        
 JULY                         
 JULY                          
 JULY                           
 JULY                            
 JULY                             
 JULY                              
 JULY                               
 JULY                                
 JULY                                 
 JULY                                  
 JULY                                   
 JULY                                    
 JUL
 JULY
 JULY 
 JULY  
 JULY   
 JULY    
 JULY     
 JULY      
 JULY       
 JULY        
 JULY         
 JULY          
 JULY           
 JULY            
 JULY             
 JULY              
 JULY               
 JULY                
 JULY                 
 JULY                  
 JULY                   
 JULY                    
 JULY                     
 JULY                      
 JULY                       
 JULY                        
 JULY                         
 JULY                          
 JULY                           
 JULY                            
 JULY                             
 JULY                              
 JULY                               
 JULY                                
 JULY                                 
 JULY                                  
 JULY                                   
 JULY                                    
 AUG
 AUGU
 AUGUS
 AUGUST
 AUGUST 
 AUGUST  
 AUGUST   
 AUGUST    
 AUGUST     
 AUGUST      
 AUGUST       
 AUGUST        
 AUGUST         
 AUGUST          
 AUGUST           
 AUGUST            
 AUGUST             
 AUGUST              
 AUGUST               
 AUGUST                
 AUGUST                 
 AUGUST                  
 AUGUST                   
 AUGUST                    
 AUGUST                     
 AUGUST                      
 AUGUST                       
 AUGUST                        
 AUGUST                         
 AUGUST                          
 AUGUST                           
 AUGUST                            
 AUGUST                             
 AUGUST                              
 AUGUST                               
 AUGUST                                
 AUGUST                                 
 AUGUST                                  
 SEP
 SEPT
 SEPTE
 SEPTEM
 SEPTEMB
 SEPTEMBE
 SEPTEMBER
 SEPTEMBER 
 SEPTEMBER  
 SEPTEMBER   
 SEPTEMBER    
 SEPTEMBER     
 SEPTEMBER      
 SEPTEMBER       
 SEPTEMBER        
 SEPTEMBER         
 SEPTEMBER          
 SEPTEMBER           
 SEPTEMBER            
 SEPTEMBER             
 SEPTEMBER              
 SEPTEMBER               
 SEPTEMBER                
 SEPTEMBER                 
 SEPTEMBER                  
 SEPTEMBER                   
 SEPTEMBER                    
 SEPTEMBER                     
 SEPTEMBER                      
 SEPTEMBER                       
 SEPTEMBER                        
 SEPTEMBER                         
 SEPTEMBER                          
 SEPTEMBER                           
 SEPTEMBER                            
 SEPTEMBER                             
 SEPTEMBER                              
 SEPTEMBER                               
 OCT
 OCTO
 OCTOB
 OCTOBE
 OCTOBER
 OCTOBER 
 OCTOBER  
 OCTOBER   
 OCTOBER    
 OCTOBER     
 OCTOBER      
 OCTOBER       
 OCTOBER        
 OCTOBER         
 OCTOBER          
 OCTOBER           
 OCTOBER            
 OCTOBER             
 OCTOBER              
 OCTOBER               
 OCTOBER                
 OCTOBER                 
 OCTOBER                  
 OCTOBER                   
 OCTOBER                    
 OCTOBER                     
 OCTOBER                      
 OCTOBER                       
 OCTOBER                        
 OCTOBER                         
 OCTOBER                          
 OCTOBER                           
 OCTOBER                            
 OCTOBER                             
 OCTOBER                              
 OCTOBER                               
 OCTOBER                                
 OCTOBER                                 
 NOV
 NOVE
 NOVEM
 NOVEMB
 NOVEMBE
 NOVEMBER
 NOVEMBER 
 NOVEMBER  
 NOVEMBER   
 NOVEMBER    
 NOVEMBER     
 NOVEMBER      
 NOVEMBER       
 NOVEMBER        
 NOVEMBER         
 NOVEMBER          
 NOVEMBER           
 NOVEMBER            
 NOVEMBER             
 NOVEMBER              
 NOVEMBER               
 NOVEMBER                
 NOVEMBER                 
 NOVEMBER                  
 NOVEMBER                   
 NOVEMBER                    
 NOVEMBER                     
 NOVEMBER                      
 NOVEMBER                       
 NOVEMBER                        
 NOVEMBER                         
 NOVEMBER                          
 NOVEMBER                           
 NOVEMBER                            
 NOVEMBER                             
 NOVEMBER                              
 NOVEMBER                               
 NOVEMBER                                
 DEC
 DECE
 DECEM
 DECEMB
 DECEMBE
 DECEMBER
 DECEMBER 
 DECEMBER  
 DECEMBER   
 DECEMBER    
 DECEMBER     
 DECEMBER      
 DECEMBER       
 DECEMBER        
 DECEMBER         
 DECEMBER          
 DECEMBER           
 DECEMBER            
 DECEMBER             
 DECEMBER              
 DECEMBER               
 DECEMBER                
 DECEMBER                 
 DECEMBER                  
 DECEMBER                   
 DECEMBER                    
 DECEMBER                     
 DECEMBER                      
 DECEMBER                       
 DECEMBER                        
 DECEMBER                         
 DECEMBER                          
 DECEMBER                           
 DECEMBER                            
 DECEMBER                             
 DECEMBER                              
 DECEMBER                               
 DECEMBER                                
   .
    .
     .
      .
       .
        .
         .
          .
           .
            .
             .
              .
               .
                .
                 .
                  .
                   .
                    .
                     .
                      .
                       .
                        .
                         .
                          .
                           .
                            .
                             .
                              .
                               .
                                .
                                 .
                                  .
                                   .
                                    .
                                     .
                                      .
                                       .
                                        .
EOF
if [ $? -ne 0 ] ; then fail ; fi

pass
