/* mem.c - malloc,realloc,free wrappers and thread-safety version.
 * Copyright (C) 2005-2006 Jia Wang <skyroam@gmail.com>
 *
 *
 *
 * This file is part of GNU Proxyknife.
 * GNU Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * GNU Proxyknife is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Proxyknife; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */


#include<proxyknife.h>
#include<stdlib.h>
#include<stdio.h>
#include<proxyknife.h>
#include <assert.h>

/* global, outside thread  */

/* Free memory the pointer point to  and set the memory pointer to NULL */
void
xfree (void **p)
{
  assert (p != NULL);
  if (*p != NULL)
    free (*p);
  *p = NULL;
  /* shorten link! */
  /* link->p == NULL */
}

/* Set all memory pointers to NULL */
void
mem_init ()
{
  user_agent = NULL;
  logfilename = NULL;
  proxyknife_in = NULL;
  proxyknife_out = NULL;
  proxyknife_in_buffer = NULL;

  my.myhost = NULL;
  my.myuser = NULL;
  my.mypass = NULL;

  my.myuserpass = NULL;
  my.header_auth = NULL;
  my.socks5authreq = NULL;
  my.buffer = NULL;

  target.target = NULL;
  target.targethost = NULL;
  target.targetport = NULL;
  target.targetpath = NULL;
  target.protocol = NULL;
  target.key = NULL;
  target.checkreqin = NULL;
  target.req = NULL;
  target.req_get_via_http_proxy = NULL;
  target.con_via_http_proxy = NULL;
}

/* This is not necessary for common operating system */
/* Free all memory the  non-NULL memory pointer point to, then exit. */
void
xexit (int status)
{
  /* clean global memory */
  /* efficiency is'nt important to exit with little memory cleaned */
  if (logfilename)
    free (logfilename);
  if (user_agent)
    free (user_agent);
  if (target.key)
    free (target.key);
  if (proxyknife_in)
    free (proxyknife_in);
  if (proxyknife_out)
    free (proxyknife_out);
  if (proxyknife_in_buffer)
    free (proxyknife_in_buffer);
  if (my.myhost)
    free (my.myhost);
  if (my.myuser)
    free (my.myuser);
  if (my.mypass)
    free (my.mypass);
  if (my.myuserpass)
    free (my.myuserpass);
  if (my.header_auth)
    free (my.header_auth);
  if (my.socks5authreq)
    free (my.socks5authreq);
  if (my.buffer)
    free (my.buffer);
  if (target.target)
    free (target.target);
  if (target.targethost)
    free (target.targethost);
  if (target.targetport)
    free (target.targetport);
  if (target.targetpath)
    free (target.targetpath);
  if (target.protocol)
    free (target.protocol);
  if (target.req)
    free (target.req);
  if (target.checkreqin)
    free (target.checkreqin);
  if (target.req_get_via_http_proxy)
    free (target.req_get_via_http_proxy);
  if (target.con_via_http_proxy)
    free (target.con_via_http_proxy);
  /* for compatible with mytype do not exist, implent this 
     within xmalloc && init.
     init: NULL for all
     xmalloc: non-NULL for sucess.
     so this code can be changed from
     if(my.mytype==HTTP_CONNECT_AUTH){
     free(my.header_auth);
     }
     to:
     if(my.header_auth) free(my.header_auth).

     even loop{if(i)free(i->xxx);i=..}

   */

  /* exit with exit 2 */
  exit (status);
}

/* A malloc wrapper with error check.
 * */
void *
xmalloc (size_t size)
{
  void *p;
  p = malloc (size);
  if (p == NULL)
    {				/* atexit */
      fprintf (stderr, "%s: xmalloc:Need more memory\n", progname);
      /* the pointer requesting memory is still NULL */
      xexit (EXIT_FAILURE);	/* atexit will do this similarly */
    }
  else
    {
      /* add to memlist */
      /* p-> link */
      return p;
    }
}

/* A realloc wrapper with error check.
 * */
void *
xrealloc (void *ptr, size_t size)
{
  void *p;
  p = realloc (ptr, size);

  /* if NULL , ptr may be destroied for realloc bug. here we ignored it .
     Otherwise, we should know &ptr and rest ptr to NULL if it happened. 
   */
  if (p == NULL)
    {
      xexit (EXIT_FAILURE);
    }
  else
    {
      return p;
    }
}

/************* thread *******************************************/
#include <pthread.h>


/* A realloc wrapper with error check and mutex lock inside thread. */
void *
prealloc (void *ptr, size_t size, struct thread_mem *thread_mem)
{
  void *p;
  pthread_mutex_lock (&counter_mutex_malloc);
  p = realloc (ptr, size);
  /* If NULL , ptr may be destroied for realloc bug. here we ignored it .
     Otherwise, we should know &ptr and rest ptr to NULL if it happened. 
   */
  if (p == NULL)
    {
      pthread_mutex_unlock (&counter_mutex_malloc);
      return NULL;
      // x_pthread_exit ((void *) &ret, thread_mem);
      /* To avoid deadlock */
    }
  else
    {
      pthread_mutex_unlock (&counter_mutex_malloc);
      return p;
    }
}

/* A malloc wrapper with error check and mutex lock inside thread. */
void *
pmalloc (size_t size, struct thread_mem *thread_mem)
{
  void *p;

  pthread_mutex_lock (&counter_mutex_malloc);
  p = malloc (size);
  if (p == NULL)
    {
      pthread_mutex_unlock (&counter_mutex_malloc);
      return NULL;
    }
  else
    {				/* add to memlist */
      pthread_mutex_unlock (&counter_mutex_malloc);
      return p;
    }
}

/* Set all memory pointer to NULL. */
void
thread_mem_init (struct thread_mem *thread_mem)
{
  thread_mem->line = NULL;
  thread_mem->queue.testproxy = NULL;
  thread_mem->request = NULL;
  thread_mem->reply = NULL;
  thread_mem->queue.proto_out = NULL;
}

/* Free all memory and set the pointers to NULL */
void
thread_mem_clean (struct thread_mem *thread_mem)
{
  if (thread_mem->line)
    pxfree ((void **) &(thread_mem->line));
  if (thread_mem->queue.testproxy)
    pxfree ((void **) &(thread_mem->queue.testproxy));
  if (thread_mem->request)
    pxfree ((void **) &(thread_mem->request));
  if (thread_mem->reply)
    pxfree ((void **) &(thread_mem->reply));
  if (thread_mem->queue.proto_out)
    pxfree ((void **) &(thread_mem->queue.proto_out));
}

/* Now no mutex_lock needed,every thread free  different var */
/* Free memory */
void
pxfree (void **p)
{
  assert (p != NULL);
  if (*p)
    free (*p);
  *p = NULL;
  /* shorten link! */
  /* link->p == NULL */
}

/* Free all memory the non-NULL memory pointer point to ,then exit thread */
void
x_pthread_exit (void *retval, struct thread_mem *thread_mem)
{
  /* These pointers will not be used, no need to set them to NULL */
  if (thread_mem->line)
    free (thread_mem->line);
  if (thread_mem->queue.testproxy)
    free (thread_mem->queue.testproxy);
  if (thread_mem->request)
    free (thread_mem->request);
  if (thread_mem->reply)
    free (thread_mem->reply);
  if (thread_mem->queue.proto_out)
    free (thread_mem->queue.proto_out);
  pthread_exit (retval);
}

/* Update a string to a new value.
   *dst was NULL or point to a memory malloced. 
 
   return NULL or a updated *dst. 
 */
void *
update_string_thread (char **dst, char *value, struct thread_mem *thread_mem)
{
  int size;
  if (*dst != NULL)
    pxfree ((void **) dst);

  size = strlen (value) + 1;
  *dst = pmalloc (size, thread_mem);
  if (*dst == NULL)
    return NULL;
  memmove (*dst, value, size);
  return *dst;
}

void
x_update_string_thread (char **dst, char *value,
			struct thread_mem *thread_mem)
{
  int ret = EXIT_FAILURE;
  if (update_string_thread (dst, value, thread_mem) == NULL)
    {
      fprintf (stderr, "%s %s: x_update_string_thread: "
	       "fail to allocate memory!\n", progname, __FILE__);
      x_pthread_exit ((void *) &ret, thread_mem);
    }
}
