/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include "MessageBoxDrawable.h"
#include "BoxElement.h"
#include "StringDrawer.h"
#include <string>
#include <vector>
class StringMessageBoxDrawable :
	public MessageBoxDrawable
{
public:
	StringMessageBoxDrawable(std::vector<BoxElement *> stringList,std::string title,int startX,int startY,int &screenWidth,int &screenHeight,StringDrawer *drawer);
	StringMessageBoxDrawable(std::string message,std::string title,int startX,int startY,int &screenWidth,int &screenHeight,StringDrawer *drawer);
	virtual ~StringMessageBoxDrawable(void);

	virtual void draw();
	virtual void setSelected(int);
	void drawComplex( );
	virtual void setTitle(std::string);
	virtual void setMessage(std::string);
protected:
	std::vector<BoxElement *> stringList_;
	std::string actualTitle_;
	int selected_;
private: 
	void calculateLines(std::string pp);
	std::string actualMessage_;
	
	
	int startX_;
	int startY_;
	int *screenWidth_;
	void drawSimple( );

	void drawEmptyLine(int lineNumber);
	void drawLine(int lineNumber);
	void drawComplexLine(std::string line,int lineNumber,char esp=' ');
	
	
	void calculateLength();
	int maxCharByLine_;
	int decalage_;
	bool precalculated_;
	int *screenHeight_;
	StringDrawer *drawer_;
	
};

