/*  Motti -- a strategy game
    Copyright (C) 1999-2014 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "GameDispatcher.h"
#include "SessionService.h"
#include "LoginService.h"
#include "GameManager.h"
#include "GamePersistanceService.h"
//defined for the life one list to be dispatched
std::map<std::string,InAction*> GameDispatcher::actionsMap;

GameDispatcher::GameDispatcher()
{
    actionsMap.insert(std::pair<std::string,InAction *>("createUser",new CreateUser()));
    actionsMap.insert(std::pair<std::string,InAction *>("regeneratePassword",new RegeneratePassword()));
    actionsMap.insert(std::pair<std::string,InAction *>("login",new LoginUser()));
    actionsMap.insert(std::pair<std::string,InAction *>("createGame",new CreateGame()));
    actionsMap.insert(std::pair<std::string,InAction *>("attachUserOnGame",new AttachUserOnGame()));
    actionsMap.insert(std::pair<std::string,InAction *>("play",new Play()));
    actionsMap.insert(std::pair<std::string,InAction *>("listGames",new ListGames()));
    actionsMap.insert(std::pair<std::string,InAction *>("listMyGames",new ListMyGames()));
    actionsMap.insert(std::pair<std::string,InAction *>("getGame",new GetGame()));
    actionsMap.insert(std::pair<std::string,InAction *>("logout",new Logout()));
}


std::string GameDispatcher::dispatch(std::string session,std::string action,std::string msg){
    //preload disathing service
    if(actionsMap.empty())
      GameDispatcher();
    //manage session
    bool secured=true;
    if (!SessionService::validate(session))
      secured=false;
    //manage action
    if(actionsMap.find(action)!=actionsMap.end())
      return (actionsMap.find(action)->second)->dispatch(secured,msg,session);
    return std::string("Unknow action:")+action;
}