/* lexfn.h

   written by Don Maszle
   15 October 1991
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.lexfn.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:15:02
      Author:  @a
   -- SCCS  ---------

   Header file for input definitions.
*/

#ifndef _LEXFN_INCLUDED

/* ----- Inclusions  */

#include "lex.h"

/* ----- Constants  */

#define N_TAU_EXPOSE	40	/* Number of Tau's to expose exp() inputs */

/* Input Function constants */

#define IFN_NULL	0
#define IFN_CONSTANT	1
#define IFN_PERDOSE	2
#define IFN_PERRATE	3
#define IFN_PEREXP	4
#define IFN_DOSES	5
#define IFN_SPIKES      6

/* ----- Enumerations  */

/* ----- Typedefs  */

/* IFN:  Predefined input functions

   The parameters of interest vary depending on the type of the function.
   I know, this should really be a union, but they are kind of messy and
   this needs to be redone more intelligently anyway.

   At any point in time, dVal is the current value (this is calculated
   for a given point in time by CalcInputs().  For pulsed inputs, bOn
   flags whether or not the pulse is active.  Dependencies of IFN parms on
   on model parameters are respected via the handle fields 

   Here is what the parms mean:

     IFN_CONSTANT  dMag is the constant

   -- Periodic functions:  Period = dTper, magnitude = dMag, start time = dT0
   
     IFN_PERDOSE  Periodic dose lasting dTexp
     IFN_PEREXP   Periodic exponential with decay constant dDecay

   -- Multiple pulse functions:
   
     IFN_DOSES    nDoses of rgMags[] starting at rgT0s[] of duration rgTexps[]
     IFN_SPIKES   nDoses spikes of rgMags[] at time rgT0s[]
*/

typedef struct tagIFN {
  /*-- Bookkeeping */
			 
  int iType;				/* One of the IFN_ types */
  BOOL bOn;				/* TRUE if exposure is On */
  double dTStartPeriod;			/* Start of current period */
  double dVal;				/* Current value: CalcInputs updates */

  /*-- Periodic functions */

  double dMag;				/* Magnitude of input */
  double dTper;				/* Duration of Period */
  double dT0;				/* Starting time of exposure */
  double dTexp;				/* Exposure duration */

  /* For exponential inputs, the exponential decay rate
     Exposure lasts for N_TAU_EXPOSE Tau periods. (tau=1/Decay)
     After this, input is considered to be neglible.
   */
  double dDecay;

  /*-- Dependencies for the periodic parms */

  HANDLE hMag;				/* Handle to magnitude */
  HANDLE hTper;				/* Handle to period */
  HANDLE hT0;				/* Handle to starting time */
  HANDLE hTexp;				/* Handle to exposure time */
  HANDLE hDecay;			/* Handle to exponential decay rate */

  /*-- Multiple dose inputs */
  
  int nDoses;				/* Number of doses of spikes */
  int iDoseCur;				/* Current Dose */
  PDOUBLE rgT0s;			/* Array of start times */
  PDOUBLE rgTexps;			/* Array of exposure durations */
  PDOUBLE rgMags;			/* Array of magnitudes */
  
} IFN, *PIFN;	/* struct tagIFN */


/* ----- Prototypes  */

BOOL GetInputFn (PINPUTBUF pibIn, PSTR sz, PIFN pifn);


#define _LEXFN_INCLUDED
#endif
