/*
 * Decompiled with CFR 0.152.
 */
package qalbum;

import gnu.mapping.InPort;
import gnu.text.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import qalbum.create;
import qalbum.pictures;

public class qalbum {
    static File userdir = new File(System.getProperty("user.dir"));

    public static void main(String[] stringArray) {
        qalbum.process(userdir, stringArray);
    }

    public static void process(File file, String[] stringArray) {
        int n = 0;
        while (true) {
            if (n == stringArray.length) {
                qalbum.generate(file, new String[0]);
                break;
            }
            String string = stringArray[n];
            if (string.equals("generate")) {
                String[] stringArray2 = new String[stringArray.length - n - 1];
                if (stringArray2.length > 0) {
                    System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray2.length);
                }
                qalbum.generate(file, stringArray2);
                break;
            }
            if (string.equals("-R") || string.equals("--recursive")) {
                String[] stringArray3 = new String[stringArray.length - n - 1];
                if (stringArray3.length > 0) {
                    System.arraycopy(stringArray, n + 1, stringArray3, 0, stringArray3.length);
                }
                qalbum.recursive(file, stringArray3);
                break;
            }
            if (string.equals("create") || string.equals("new") || string.equals("--create") || string.equals("--new")) {
                String[] stringArray4 = new String[stringArray.length - n - 1];
                if (stringArray4.length > 0) {
                    System.arraycopy(stringArray, n + 1, stringArray4, 0, stringArray4.length);
                }
                create.main(stringArray4);
                if (!string.equals("new") && !string.equals("--new")) break;
                qalbum.generate(file, new String[0]);
                break;
            }
            if (string.equals("version") || stringArray.equals("--version")) {
                System.out.println("qalbum Coperyright 2007 Per Bothner");
                break;
            }
            if (!string.startsWith("--scriptdir=")) {
                qalbum.help();
                break;
            }
            create.scriptdir = string.substring(12);
            ++n;
        }
    }

    public static void recursive(File file, String[] stringArray) {
        File[] fileArray = file.listFiles();
        File file2 = new File(file, "index.xml");
        if (file2.exists()) {
            System.out.println("Processing " + file2);
            Path.setCurrentPath((Path)Path.valueOf((Object)file));
            if (stringArray.length == 0) {
                qalbum.generate(file2, file, stringArray);
            } else {
                qalbum.process(file, stringArray);
            }
        }
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            qalbum.recursive(fileArray[i], stringArray);
        }
    }

    public static void generate(File file, String[] stringArray) {
        File file2 = new File(file, "index.xml");
        if (!file2.exists()) {
            qalbum.help();
        } else {
            qalbum.generate(file2, file, stringArray);
        }
    }

    public static void generate(File file, File file2, String[] stringArray) {
        String string = null;
        try {
            String[] stringArray2;
            Object object;
            FileInputStream fileInputStream = new FileInputStream(file);
            InPort inPort = new InPort((InputStream)fileInputStream);
            while ((object = inPort.readLine()) != null) {
                char c;
                int n;
                stringArray2 = "<group libdir=";
                int n2 = stringArray2.length();
                int n3 = ((String)object).indexOf((String)stringArray2);
                if (n3 < 0 || (n = ((String)object).indexOf(c = ((String)object).charAt(n3 + n2), n3 + n2 + 1)) <= 0) continue;
                string = ((String)object).substring(n3 + n2 + 1, n);
                break;
            }
            if (string == null) {
                string = create.libdirSearch(file2);
            }
            if (!((File)(object = new File(file2, string))).isDirectory()) {
                create.error("libdir " + string + " is not a directory");
            }
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray2[stringArray.length] = "libdir=" + string;
            pictures.main(stringArray2);
            create.updateLibdir((File)object);
        }
        catch (Throwable throwable) {
            System.err.println("caught " + throwable);
            System.exit(-1);
        }
    }

    public static void help() {
        System.err.println("qalbum usage:");
        System.err.println("  qalbum create [options] \"Title\" [pic1.jpg]...  (create new folder)");
        System.err.println("  qalbum new ...   (a synonym for qalbum create followed by generate)");
        System.err.println("  qalbum generate  (generate web pages, if index.xml exists)");
        System.err.println("  qalbum           (same as: qalbum generate)");
        System.err.println("  qalbum -R        (generate here and in subdirectories containing index.xml)");
    }
}

