.TH QEXO 1
.\" NAME should be all caps, SECTION should be 1-8, maybe w/ subsection
.\" other parms are allowed: see man(7), man(1)
.SH NAME
qexo \- the XQuery language implemented on a Java VM
.SH SYNOPSIS
.B qexo
.I "[options]"
.br
.B java kawa.repl --xquery
.I "[options]"
.SH "DESCRIPTION"
This manual page documents briefly the
.BR qexo
package, an XQuery implementation written completely in the Java language.
XQuery expressions are compiled into Java bytecodes for efficiency.

XQuery is a new language designed for querying, manipulating, and
generating XML and similar data sets.

Using the
.B qexo
script is equivalent to invoking an interpreter of the Java language on the
.B "kawa.repl"
class and specifying the
.B "--xquery"
option.

This manual page is just a quick synopsis.
For more information, see the links below.

.SH OPTIONS
.TP
.BI "-e " expression
Evaluate the
.IR expression .
.TP
.BI "-c " expression
Evaluate the
.IR expression ,
but does not cause the start-up file
.I ~/.kawarc.scm
to be read.
.TP
.BI "-f " filename
Read and evaluate XQuery expressions from the
.IR filename .
.TP
.B -s
Enter an interactive read-evaluate-print command loop.
.TP
.B -w
Enter an interactive read-evaluate-print in a new top-level window.
.TP
.BI "-C " filename
Compile
.IR filename
to one or more Java class files.  See the Kawa manual for details.
.P
If no options are specified, it is equivalent to
.BR "-s" "."
.br
GNU
.BR "readline(3)" " can normally be used to edit commands."

.SH FILES
.TP
.B /usr/bin/qexo
The
.B qexo
executable just invokes
.B kawa(1)
with the
.B --xquery
option.
.TP
.B ~/.kawarc.scm
Commands that are executed when
.BR "qexo" " (or"
.BR "kawa" ") is started."
.SH AUTHOR
Per Bothner <per@bothner.com>.
.SH "SEE ALSO"
.B kawa(1)
.P
.BR "info kawa" " - the complete Kawa manual."
.UR "http://www.gnu.org/software/qxeo/"
.I http://www.gnu.org/software/qxeo/
.UE
- the
.B qexo
home page.
.UR "http://www.gnu.org/software/kawa/"
.I "http://www.gnu.org/software/kawa/"
.UE
- the
.B kawa
home page.
.UR "htpp://www.w3.org/XML/Query"
.I "htpp://www.w3.org/XML/Query"
.UE
- the W3C XQuery home page.

