/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.DateTime;
import gnu.math.Numeric;
import gnu.math.Quantity;
import gnu.math.RealNum;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Duration
extends Quantity
implements Externalizable {
    public Unit unit;
    int months;
    long seconds;
    int nanos;

    public static Duration make(int n, long l, int n2, Unit unit) {
        Duration duration = new Duration();
        duration.months = n;
        duration.seconds = l;
        duration.nanos = n2;
        duration.unit = unit;
        return duration;
    }

    public static Duration makeMonths(int n) {
        Duration duration = new Duration();
        duration.unit = Unit.month;
        duration.months = n;
        return duration;
    }

    public static Duration makeMinutes(int n) {
        Duration duration = new Duration();
        duration.unit = Unit.second;
        duration.seconds = 60 * n;
        return duration;
    }

    public static Duration parse(String string, Unit unit) {
        Duration duration = Duration.valueOf(string, unit);
        if (duration == null) {
            throw new IllegalArgumentException("not a valid " + unit.getName() + " duration: '" + string + "'");
        }
        return duration;
    }

    public static Duration parseDuration(String string) {
        return Duration.parse(string, Unit.duration);
    }

    public static Duration parseYearMonthDuration(String string) {
        return Duration.parse(string, Unit.month);
    }

    public static Duration parseDayTimeDuration(String string) {
        return Duration.parse(string, Unit.second);
    }

    public static Duration valueOf(String string, Unit unit) {
        boolean bl;
        int n = 0;
        int n2 = (string = string.trim()).length();
        if (n < n2 && string.charAt(n) == '-') {
            bl = true;
            ++n;
        } else {
            bl = false;
        }
        if (n + 1 >= n2 || string.charAt(n) != 'P') {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        long l2 = Duration.scanPart(string, ++n);
        n = (int)l2 >> 16;
        char c = (char)l2;
        if (unit == Unit.second && (c == 'Y' || c == 'M')) {
            return null;
        }
        if (c == 'Y') {
            n3 = 12 * (int)(l2 >> 32);
            n = (int)l2 >> 16;
            l2 = Duration.scanPart(string, n);
            c = (char)l2;
        }
        if (c == 'M') {
            n3 = (int)((long)n3 + (l2 >> 32));
            n = (int)l2 >> 16;
            l2 = Duration.scanPart(string, n);
            c = (char)l2;
        }
        if (unit == Unit.month && n != n2) {
            return null;
        }
        if (c == 'D') {
            if (unit == Unit.month) {
                return null;
            }
            l = 86400L * (long)((int)(l2 >> 32));
            n = (int)l2 >> 16;
            l2 = Duration.scanPart(string, n);
        }
        if (l2 != (long)(n << 16)) {
            return null;
        }
        if (n != n2) {
            if (string.charAt(n) != 'T' || ++n == n2) {
                return null;
            }
            if (unit == Unit.month) {
                return null;
            }
            l2 = Duration.scanPart(string, n);
            c = (char)l2;
            if (c == 'H') {
                l += (long)(3600 * (int)(l2 >> 32));
                n = (int)l2 >> 16;
                l2 = Duration.scanPart(string, n);
                c = (char)l2;
            }
            if (c == 'M') {
                l += (long)(60 * (int)(l2 >> 32));
                n = (int)l2 >> 16;
                l2 = Duration.scanPart(string, n);
                c = (char)l2;
            }
            if (c == 'S' || c == '.') {
                l += (long)((int)(l2 >> 32));
                n = (int)l2 >> 16;
            }
            if (c == '.' && n + 1 < n2 && Character.digit(string.charAt(n), 10) >= 0) {
                int n5;
                int n6 = 0;
                while (n < n2 && (n5 = Character.digit(c = string.charAt(n++), 10)) >= 0) {
                    if (n6 < 9) {
                        n4 = 10 * n4 + n5;
                    } else if (n6 == 9 && n5 >= 5) {
                        ++n4;
                    }
                    ++n6;
                }
                while (n6++ < 9) {
                    n4 = 10 * n4;
                }
                if (c != 'S') {
                    return null;
                }
            }
        }
        if (n != n2) {
            return null;
        }
        Duration duration = new Duration();
        if (bl) {
            n3 = -n3;
            l = -l;
            n4 = -n4;
        }
        duration.months = n3;
        duration.seconds = l;
        duration.nanos = n4;
        duration.unit = unit;
        return duration;
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof Duration) {
            return Duration.add(this, (Duration)object2, n);
        }
        if (object2 instanceof DateTime && n == 1) {
            return DateTime.add((DateTime)object2, this, 1);
        }
        throw new IllegalArgumentException();
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof RealNum) {
            return Duration.times(this, ((RealNum)object2).doubleValue());
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric mulReversed(Numeric numeric) {
        if (!(numeric instanceof RealNum)) {
            throw new IllegalArgumentException();
        }
        return Duration.times(this, ((RealNum)numeric).doubleValue());
    }

    public static double div(Duration duration, Duration duration2) {
        int n = duration.months;
        int n2 = duration2.months;
        double d = (double)duration.seconds + (double)duration.nanos * 1.0E-9;
        double d2 = (double)duration2.seconds + (double)duration.nanos * 1.0E-9;
        if (n2 == 0 && d2 == 0.0) {
            throw new ArithmeticException("divide duration by zero");
        }
        if (n2 == 0) {
            if (n == 0) {
                return d / d2;
            }
        } else if (d2 == 0.0 && d == 0.0) {
            return (double)n / (double)n2;
        }
        throw new ArithmeticException("divide of incompatible durations");
    }

    public Numeric div(Object object2) {
        if (object2 instanceof RealNum) {
            double d = ((RealNum)object2).doubleValue();
            if (d == 0.0 || Double.isNaN(d)) {
                throw new ArithmeticException("divide of duration by 0 or NaN");
            }
            return Duration.times(this, 1.0 / d);
        }
        if (object2 instanceof Duration) {
            return new DFloNum(Duration.div(this, (Duration)object2));
        }
        return ((Numeric)object2).divReversed(this);
    }

    public static Duration add(Duration duration, Duration duration2, int n) {
        long l = (long)duration.months + (long)n * (long)duration2.months;
        long l2 = duration.seconds * 1000000000L + (long)duration.nanos + (long)n * (duration2.seconds * 1000000000L + (long)duration2.nanos);
        Duration duration3 = new Duration();
        duration3.months = (int)l;
        duration3.seconds = (int)(l2 / 1000000000L);
        duration3.nanos = (int)(l2 % 1000000000L);
        if (duration.unit != duration2.unit || duration.unit == Unit.duration) {
            throw new ArithmeticException("cannot add these duration types");
        }
        duration3.unit = duration.unit;
        return duration3;
    }

    public static Duration times(Duration duration, double d) {
        if (duration.unit == Unit.duration) {
            throw new IllegalArgumentException("cannot multiply general duration");
        }
        double d2 = (double)duration.months * d;
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new ArithmeticException("overflow/NaN when multiplying a duration");
        }
        double d3 = (double)(duration.seconds * 1000000000L + (long)duration.nanos) * d;
        Duration duration2 = new Duration();
        duration2.months = (int)Math.floor(d2 + 0.5);
        duration2.seconds = (int)(d3 / 1.0E9);
        duration2.nanos = (int)(d3 % 1.0E9);
        duration2.unit = duration.unit;
        return duration2;
    }

    public static int compare(Duration duration, Duration duration2) {
        long l = (long)duration.months - (long)duration2.months;
        long l2 = duration.seconds * 1000000000L + (long)duration.nanos - (duration2.seconds * 1000000000L + (long)duration2.nanos);
        if (l < 0L && l2 <= 0L) {
            return -1;
        }
        if (l > 0L && l2 >= 0L) {
            return 1;
        }
        if (l == 0L) {
            return l2 < 0L ? -1 : (l2 > 0L ? 1 : 0);
        }
        return -2;
    }

    public int compare(Object object2) {
        if (object2 instanceof Duration) {
            return Duration.compare(this, (Duration)object2);
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        long l;
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.months;
        long l2 = this.seconds;
        int n2 = this.nanos;
        boolean bl2 = bl = n < 0 || l2 < 0L || n2 < 0;
        if (bl) {
            n = -n;
            l2 = -l2;
            n2 = -n2;
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        int n3 = n / 12;
        if (n3 != 0) {
            stringBuffer.append(n3);
            stringBuffer.append('Y');
            n -= n3 * 12;
        }
        if (n != 0) {
            stringBuffer.append(n);
            stringBuffer.append('M');
        }
        if ((l = l2 / 86400L) != 0L) {
            stringBuffer.append(l);
            stringBuffer.append('D');
            l2 -= 86400L * l;
        }
        if (l2 != 0L || n2 != 0) {
            long l3;
            stringBuffer.append('T');
            long l4 = l2 / 3600L;
            if (l4 != 0L) {
                stringBuffer.append(l4);
                stringBuffer.append('H');
                l2 -= 3600L * l4;
            }
            if ((l3 = l2 / 60L) != 0L) {
                stringBuffer.append(l3);
                stringBuffer.append('M');
                l2 -= 60L * l3;
            }
            if (l2 != 0L || n2 != 0) {
                stringBuffer.append(l2);
                Duration.appendNanoSeconds(n2, stringBuffer);
                stringBuffer.append('S');
            }
        } else if (stringBuffer.length() == 1) {
            stringBuffer.append(this.unit == Unit.month ? "0M" : "T0S");
        }
        return stringBuffer.toString();
    }

    static void appendNanoSeconds(int n, StringBuffer stringBuffer) {
        if (n == 0) {
            return;
        }
        stringBuffer.append('.');
        int n2 = stringBuffer.length();
        stringBuffer.append(n);
        int n3 = stringBuffer.length();
        int n4 = n2 + 9 - n3;
        while (--n4 >= 0) {
            stringBuffer.insert(n2, '0');
        }
        n3 = n2 + 9;
        while (stringBuffer.charAt(--n3) == '0') {
        }
        stringBuffer.setLength(n3 + 1);
    }

    private static long scanPart(String string, int n) {
        long l = -1L;
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = Character.digit(c, 10);
            if (n3 >= 0) continue;
            if (l < 0L) {
                return n << 16;
            }
            return l << 32 | (long)(i << 16) | (long)c;
        }
        return l < 0L ? (long)(n << 16) : -1L;
    }

    public int getYears() {
        return this.months / 12;
    }

    public int getMonths() {
        return this.months % 12;
    }

    public int getDays() {
        return (int)(this.seconds / 86400L);
    }

    public int getHours() {
        return (int)(this.seconds / 3600L % 24L);
    }

    public int getMinutes() {
        return (int)(this.seconds / 60L % 60L);
    }

    public int getSecondsOnly() {
        return (int)(this.seconds % 60L);
    }

    public int getNanoSecondsOnly() {
        return this.nanos;
    }

    public int getTotalMonths() {
        return this.months;
    }

    public long getTotalSeconds() {
        return this.seconds;
    }

    public long getTotalMinutes() {
        return this.seconds / 60L;
    }

    public long getNanoSeconds() {
        return this.seconds * 1000000000L + (long)this.nanos;
    }

    public boolean isZero() {
        return this.months == 0 && this.seconds == 0L && this.nanos == 0;
    }

    public boolean isExact() {
        return false;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.months);
        objectOutput.writeLong(this.seconds);
        objectOutput.writeInt(this.nanos);
        objectOutput.writeObject(this.unit);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.months = objectInput.readInt();
        this.seconds = objectInput.readLong();
        this.nanos = objectInput.readInt();
        this.unit = (Unit)objectInput.readObject();
    }

    public Unit unit() {
        return this.unit;
    }

    public Complex number() {
        throw new Error("number needs to be implemented!");
    }

    public int hashCode() {
        return this.months ^ (int)this.seconds ^ this.nanos;
    }

    public static boolean equals(Duration duration, Duration duration2) {
        return duration.months == duration2.months && duration.seconds == duration2.seconds && duration.nanos == duration2.nanos;
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof Duration)) {
            return false;
        }
        return Duration.equals(this, (Duration)object2);
    }
}

