/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Printable;
import gnu.mapping.Procedure;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import kawa.lang.Quote;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class Macro
extends Syntax
implements Printable,
Externalizable {
    public Object expander;
    Object instance;
    private boolean hygienic = true;
    private ScopeExp capturedScope;

    public ScopeExp getCapturedScope() {
        if (this.capturedScope == null) {
            if (this.instance instanceof ModuleExp) {
                this.capturedScope = (ModuleExp)this.instance;
            } else if (this.instance != null) {
                this.capturedScope = ModuleInfo.findFromInstance(this.instance).getModuleExp();
            }
        }
        return this.capturedScope;
    }

    public void setCapturedScope(ScopeExp scopeExp) {
        this.capturedScope = scopeExp;
    }

    public static Macro make(Declaration declaration) {
        Macro macro = new Macro(declaration.getSymbol());
        declaration.setSyntax();
        return macro;
    }

    public static Macro makeNonHygienic(Object object2, Procedure procedure) {
        Macro macro = new Macro(object2, procedure);
        macro.hygienic = false;
        return macro;
    }

    public static Macro makeNonHygienic(Object object2, Procedure procedure, Object object3) {
        Macro macro = new Macro(object2, procedure);
        macro.hygienic = false;
        macro.instance = object3;
        return macro;
    }

    public static Macro make(Object object2, Procedure procedure) {
        Macro macro = new Macro(object2, procedure);
        return macro;
    }

    public static Macro make(Object object2, Procedure procedure, Object object3) {
        Macro macro = new Macro(object2, procedure);
        macro.instance = object3;
        return macro;
    }

    public final boolean isHygienic() {
        return this.hygienic;
    }

    public final void setHygienic(boolean bl) {
        this.hygienic = bl;
    }

    public Macro() {
    }

    public Macro(Macro macro) {
        this.name = macro.name;
        this.expander = macro.expander;
        this.hygienic = macro.hygienic;
    }

    public Macro(Object object2, Procedure procedure) {
        super(object2);
        this.expander = new QuoteExp(procedure);
    }

    public Macro(Object object2) {
        super(object2);
    }

    public Expression rewriteForm(Pair pair, Translator translator) {
        return translator.rewrite(this.expand(pair, translator));
    }

    public Expression rewriteForm(Object object2, Translator translator) {
        return translator.rewrite(this.expand(object2, translator));
    }

    public String toString() {
        return "#<macro " + this.getName() + '>';
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<macro ");
        printWriter.print(this.getName());
        printWriter.print('>');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object expand(Object object2, Translator translator) {
        try {
            Object object3;
            Procedure procedure;
            Object object4 = this.expander;
            if (object4 instanceof Procedure && !(object4 instanceof Expression)) {
                procedure = (Procedure)object4;
            } else {
                if (!(object4 instanceof Expression)) {
                    object3 = translator.currentMacroDefinition;
                    translator.currentMacroDefinition = this;
                    try {
                        this.expander = object4 = translator.rewrite(object4);
                    }
                    finally {
                        translator.currentMacroDefinition = object3;
                    }
                }
                procedure = (Procedure)((Expression)object4).eval(translator.getGlobalEnvironment());
            }
            if (!this.hygienic) {
                int n = Translator.listLength(object2 = Quote.quote(object2, translator));
                if (n <= 0) {
                    return translator.syntaxError("invalid macro argument list to " + this);
                }
                Object[] objectArray = new Object[n - 1];
                for (int i = 0; i < n; ++i) {
                    Pair pair = (Pair)object2;
                    if (i > 0) {
                        objectArray[i - 1] = pair.car;
                    }
                    object2 = pair.cdr;
                }
                object3 = procedure.applyN(objectArray);
            } else {
                object3 = procedure.apply1(object2);
            }
            if (object2 instanceof PairWithPosition && object3 instanceof Pair && !(object3 instanceof PairWithPosition)) {
                Pair pair = (Pair)object3;
                object3 = new PairWithPosition((PairWithPosition)object2, pair.car, pair.cdr);
            }
            return object3;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return translator.syntaxError("evaluating syntax transformer '" + this.getName() + "' threw " + throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForm(Pair pair, ScopeExp scopeExp, Translator translator) {
        String string = translator.getFile();
        int n = translator.getLine();
        int n2 = translator.getColumn();
        Syntax syntax2 = translator.currentSyntax;
        try {
            translator.setLine(pair);
            translator.currentSyntax = this;
            Object object2 = this.expand(pair, translator);
            translator.scanForm(object2, scopeExp);
        }
        finally {
            translator.setLine(string, n, n2);
            translator.currentSyntax = syntax2;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getName());
        objectOutput.writeObject(((QuoteExp)this.expander).getValue());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setName((String)objectInput.readObject());
        this.expander = new QuoteExp(objectInput.readObject());
    }
}

