/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.Command;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EKeymap;
import gnu.jemacs.buffer.Modeline;
import gnu.jemacs.buffer.TooLongAction;
import gnu.lists.LList;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;

public abstract class EWindow {
    public Modeline modeline;
    public EFrame frame;
    public Buffer buffer;
    protected int[] pendingKeys = null;
    protected int pendingLength = 0;
    protected EWindow prevWindow;
    protected EWindow nextWindow;
    protected int charHeight;
    protected int charWidth;

    public EWindow(Buffer buffer) {
        this.buffer = buffer;
        this.nextWindow = this;
        this.prevWindow = this;
    }

    public static EWindow getSelected() {
        return EFrame.selectedFrame == null ? null : EFrame.selectedFrame.selectedWindow;
    }

    public abstract void setSelected();

    public static void setSelected(EWindow eWindow) {
        eWindow.setSelected();
        eWindow.requestFocus();
    }

    public void requestFocus() {
    }

    public EFrame getFrame() {
        return this.frame;
    }

    public final void setFrame(EFrame eFrame) {
        this.frame = eFrame;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public abstract int getPoint();

    public final void setPoint(int n) {
        this.setDot(n - 1);
    }

    public abstract void setDot(int var1);

    public final EWindow split(int n, boolean bl) {
        return this.split(this.buffer, n, bl);
    }

    public abstract EWindow split(Buffer var1, int var2, boolean var3);

    protected final void linkSibling(EWindow eWindow, boolean bl) {
        EWindow eWindow2;
        this.nextWindow = eWindow;
        eWindow.prevWindow = this;
        eWindow.nextWindow = eWindow2 = this.nextWindow;
        eWindow2.prevWindow = eWindow;
    }

    protected final void unlink() {
        if (this.frame.firstWindow == this) {
            this.frame.firstWindow = this.nextWindow == this ? null : this.nextWindow;
        }
        this.nextWindow.prevWindow = this.prevWindow;
        this.prevWindow.nextWindow = this.nextWindow;
        this.prevWindow = this;
        this.nextWindow = this;
    }

    public EWindow getNextWindow(boolean bl) {
        return this.nextWindow;
    }

    public final EWindow getOtherWindow(boolean bl) {
        EWindow eWindow = this.getNextWindow(bl);
        return eWindow;
    }

    public final EWindow getNextWindowInFrame(int n) {
        EWindow eWindow = this;
        if (n > 0) {
            while (--n >= 0) {
                eWindow = eWindow.getOtherWindow(true);
            }
        } else {
            while (++n <= 0) {
                eWindow = eWindow.getOtherWindow(false);
            }
        }
        return eWindow;
    }

    public void delete() {
        EFrame eFrame = this.frame;
        this.deleteNoValidate();
        if (eFrame.getFirstWindow() == null) {
            eFrame.delete();
        } else {
            eFrame.validate();
        }
    }

    protected void deleteNoValidate() {
        if (this.frame.selectedWindow == this) {
            EWindow eWindow = this.getNextWindowInFrame(1);
            if (this.frame == EFrame.selectedFrame) {
                EWindow.setSelected(eWindow);
            } else {
                this.frame.selectedWindow = eWindow;
            }
        }
        this.unlink();
        this.frame = null;
    }

    public void deleteOtherWindows() {
        EWindow eWindow = this.frame.getFirstWindow();
        while (eWindow != null) {
            EWindow eWindow2 = eWindow.getNextWindow(true);
            if (eWindow != this) {
                eWindow.deleteNoValidate();
            }
            eWindow = eWindow2;
        }
        this.frame.validate();
    }

    protected abstract void getCharSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public int getHeightInLines() {
        if (this.charHeight == 0) {
            this.getCharSize();
        }
        return this.getHeight() / this.charHeight;
    }

    public int getWidthInColumns() {
        if (this.charWidth == 0) {
            this.getCharSize();
        }
        return this.getWidth() / this.charWidth;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("#<window on ");
        if (this.buffer == null) {
            stringBuffer.append("no buffer");
        } else {
            stringBuffer.append('\"');
            stringBuffer.append(this.buffer.getName());
            stringBuffer.append('\"');
        }
        stringBuffer.append(" 0x");
        stringBuffer.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public void pushPrefix(int n) {
        if (this.pendingKeys == null) {
            this.pendingKeys = new int[10];
        }
        this.pendingKeys[this.pendingLength++] = n;
    }

    public Object lookupKey(int n) {
        for (int i = 0; i < this.buffer.activeLength; ++i) {
            EKeymap eKeymap = this.buffer.activeKeymaps[i];
            Object object2 = eKeymap.lookupKey(this.pendingKeys, this.pendingLength, n, i < this.buffer.activeLength - 1);
            if (object2 == null) continue;
            return object2;
        }
        return EKeymap.ignorable(n) ? null : new TooLongAction(this.pendingLength);
    }

    public void handleKey(int n) {
        Object object2 = this.lookupKey(n);
        this.pushPrefix(n);
        --this.pendingLength;
        this.handleCommand(object2);
    }

    public void handleCommand(Object object2) {
        Object object3;
        if (object2 instanceof String || object2 instanceof Symbol) {
            object3 = Command.resolveSymbol(object2);
            if (object3 == null) {
                throw new Error("no function defined for " + object2);
            }
            object2 = object3;
        }
        if (object2 instanceof EKeymap) {
            if (this.pendingKeys[this.pendingLength] != 0) {
                ++this.pendingLength;
            }
            return;
        }
        this.pendingLength = 0;
        try {
            object3 = (Procedure)object2;
            Object object4 = ((Procedure)object3).getProperty("emacs-interactive", null);
            if (object4 != null) {
                if (object4 instanceof String) {
                    ((Procedure)object3).applyN(Command.processInteractionString(object4.toString()));
                } else if (object4 == LList.Empty) {
                    ((Procedure)object3).apply0();
                } else {
                    System.err.println("not implemented: interactive not a string");
                    ((Procedure)object3).apply0();
                }
            } else {
                ((Procedure)object3).apply0();
            }
        }
        catch (CancelledException cancelledException) {
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new WrappedException(throwable);
        }
    }
}

