/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.IntegerStack;
import gnu.jel.TableKeeper;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.util.Stack;

public class TypesStack
implements Cloneable {
    public static final Class[] specialTypes = (Class[])TableKeeper.getTable("specialTypes");
    public static final byte[] baseType = (byte[])TableKeeper.getTable("baseType");
    public static final byte[] unwrapType = (byte[])TableKeeper.getTable("unwrapType");
    public static final char[] primitiveCodes = (char[])TableKeeper.getTable("primitiveCodes");
    protected static final byte[] stkoccup = (byte[])TableKeeper.getTable("stkoccup");
    private IntegerStack typeIDs = new IntegerStack();
    private Stack classes = new Stack();
    protected int currWords = 0;
    private int maxWords = 0;
    private static final int[] cvt_wide = (int[])TableKeeper.getTable("cvt_wide");

    public static final int typeID(Class clazz) {
        if (clazz == null) {
            return 8;
        }
        if (clazz.isPrimitive()) {
            int n = 0;
            while (n < 10 && specialTypes[n] != clazz) {
                ++n;
            }
            return n;
        }
        int n = 11;
        while (n < specialTypes.length && !specialTypes[n].isAssignableFrom(clazz)) {
            ++n;
        }
        if (n < specialTypes.length) {
            return n;
        }
        return 8;
    }

    public static final int typeIDObject(Object object) {
        if (object instanceof Boolean) {
            return 0;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Character) {
            return 2;
        }
        if (object instanceof Short) {
            return 3;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 7;
        }
        if (object instanceof String) {
            return 11;
        }
        return 8;
    }

    public Object clone() {
        TypesStack typesStack = null;
        try {
            typesStack = (TypesStack)super.clone();
            typesStack.typeIDs = (IntegerStack)typesStack.typeIDs.clone();
            typesStack.classes = (Stack)typesStack.classes.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return typesStack;
    }

    public final Class peek() {
        return (Class)this.classes.peek();
    }

    public final int peekID() {
        return this.typeIDs.peek();
    }

    public final Class peek(int n) {
        return (Class)this.classes.elementAt(this.classes.size() - 1 - n);
    }

    public final int peekID(int n) {
        return this.typeIDs.peek(n);
    }

    public final Class pop() {
        int n = this.typeIDs.pop();
        this.currWords -= stkoccup[baseType[n]];
        return (Class)this.classes.pop();
    }

    public final void pushID(int n, Class clazz) {
        Debug.assert(n != 8 || clazz != null);
        this.typeIDs.push(n);
        if (clazz != null) {
            this.classes.push(clazz);
        } else {
            this.classes.push(specialTypes[n]);
        }
        this.currWords += stkoccup[baseType[n]];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int n) {
        this.pushID(n, null);
    }

    public final void push(Class clazz) {
        this.pushID(TypesStack.typeID(clazz), clazz);
    }

    public final void push(Class clazz, int n) {
        int n2 = TypesStack.typeID(clazz);
        this.typeIDs.push(n2, n);
        this.classes.insertElementAt(clazz, this.classes.size() - n);
        this.currWords += stkoccup[baseType[n2]];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int n, int n2) {
        Class clazz = specialTypes[n];
        this.typeIDs.push(n, n2);
        this.classes.insertElementAt(clazz, this.classes.size() - n2);
        this.currWords += stkoccup[baseType[n]];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final int size() {
        return this.typeIDs.size();
    }

    public final void resetStats() {
        this.maxWords = 0;
    }

    public final void tempExcessWords(int n) {
        if ((n = this.currWords + n) > this.maxWords) {
            this.maxWords = n;
        }
    }

    public final int getMaxOccupation() {
        return this.maxWords;
    }

    public static boolean isWidening(int n, Class clazz, int n2, Class clazz2) {
        if (baseType[n2] == 8 && n2 != 11 && n != 28) {
            if (baseType[n] == 8) {
                return clazz2.isAssignableFrom(clazz);
            }
            return false;
        }
        return (cvt_wide[n2] & 2048 >> (n = unwrapType[n])) > 0;
    }

    public static boolean isIntegral(int n) {
        return (62 >> n & 1) > 0;
    }

    public static boolean isWidening(Class clazz, Class clazz2) {
        return TypesStack.isWidening(TypesStack.typeID(clazz), clazz, TypesStack.typeID(clazz2), clazz2);
    }

    protected static Number widen(Object object, int n) {
        switch (n) {
            case 0: {
                if (((Boolean)object).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
            case 1: {
                return (Number)object;
            }
            case 2: {
                return new Long(((Character)object).charValue());
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (Number)object;
            }
        }
        return new Long(0L);
    }

    protected static Object narrow(Number number, int n) {
        switch (n) {
            case 0: {
                if (number.longValue() != 0L) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                return new Byte(number.byteValue());
            }
            case 2: {
                return new Character((char)number.longValue());
            }
            case 3: {
                return new Short(number.shortValue());
            }
            case 4: {
                return new Integer(number.intValue());
            }
            case 5: {
                return new Long(number.longValue());
            }
            case 6: {
                return new Float(number.floatValue());
            }
            case 7: {
                return new Double(number.doubleValue());
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
    }

    public static void test(Tester tester) {
    }
}

