/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.DVMap;
import gnu.jel.Library;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPcall;
import gnu.jel.OPcondtnl;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.lang.reflect.Member;
import java.util.Stack;

public class Parser {
    Stack paramOPs;
    Stack xchgOP;
    int err_col = -1;
    Library lib;
    StringBuffer accDV = null;
    StringBuffer typeAccum = new StringBuffer();
    private String in;
    private int pos = 0;
    protected int c;
    private boolean prevCR = false;
    private boolean prevLF = false;
    private int column = 0;
    private int line = 1;
    public int ct_column;
    public int ct_line;
    public Object val;
    public int type;
    private StringBuffer buf = new StringBuffer();

    public Parser(String in, Library lib) {
        this.in = in;
        this.read();
        this.lib = lib;
        this.paramOPs = new Stack();
        this.xchgOP = new Stack();
        if (lib.resolver != null) {
            this.accDV = new StringBuffer();
        }
    }

    protected int read() {
        try {
            this.c = this.in.charAt(this.pos++);
        }
        catch (Exception e) {
            this.c = -1;
        }
        ++this.column;
        if (this.prevLF) {
            this.prevLF = false;
            this.column = 1;
            ++this.line;
        } else if (this.prevCR) {
            this.prevCR = false;
            if (this.c == 10) {
                this.prevLF = true;
            } else {
                this.column = 1;
                ++this.line;
            }
        }
        switch (this.c) {
            case 13: {
                this.prevCR = true;
                break;
            }
            case 10: {
                this.prevLF = true;
                break;
            }
            case 9: {
                --this.column;
                this.column += 8 - (this.column & 7);
                break;
            }
        }
        return this.c;
    }

    protected void consume(int cc) throws CompilationException {
        if (cc < 0 || this.c != cc) {
            CompilationException exc = new CompilationException(this.c == -1 ? 1 : 3, new Character((char)this.c));
            exc.col = this.column;
            if (this.c == -1) {
                --exc.col;
            }
            throw exc;
        }
        this.read();
    }

    public void nextToken() throws CompilationException {
        this.ct_column = this.column;
        this.ct_line = this.line;
        block48: while (true) {
            switch (this.c) {
                case -1: {
                    this.type = -1;
                    return;
                }
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    this.ct_column = this.column;
                    this.ct_line = this.line;
                    continue block48;
                }
                case 43: {
                    this.read();
                    this.type = 0;
                    return;
                }
                case 45: {
                    this.read();
                    this.type = 1;
                    return;
                }
                case 42: {
                    this.read();
                    this.type = 2;
                    return;
                }
                case 47: {
                    this.read();
                    this.type = 3;
                    return;
                }
                case 37: {
                    this.read();
                    this.type = 4;
                    return;
                }
                case 38: {
                    switch (this.read()) {
                        case 38: {
                            this.read();
                            this.type = 17;
                            return;
                        }
                    }
                    this.type = 5;
                    return;
                }
                case 124: {
                    switch (this.read()) {
                        case 124: {
                            this.read();
                            this.type = 18;
                            return;
                        }
                    }
                    this.type = 6;
                    return;
                }
                case 94: {
                    this.read();
                    this.type = 7;
                    return;
                }
                case 61: {
                    this.read();
                    this.consume(61);
                    this.type = 8;
                    return;
                }
                case 33: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 9;
                            return;
                        }
                    }
                    this.type = 31;
                    return;
                }
                case 60: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 13;
                            return;
                        }
                        case 60: {
                            this.read();
                            this.type = 14;
                            return;
                        }
                    }
                    this.type = 10;
                    return;
                }
                case 62: {
                    switch (this.read()) {
                        case 61: {
                            this.read();
                            this.type = 11;
                            return;
                        }
                        case 62: {
                            switch (this.read()) {
                                case 62: {
                                    this.read();
                                    this.type = 16;
                                    return;
                                }
                            }
                            this.type = 15;
                            return;
                        }
                    }
                    this.type = 12;
                    return;
                }
                case 126: {
                    this.read();
                    this.type = 30;
                    return;
                }
                case 91: {
                    this.read();
                    this.type = 19;
                    return;
                }
                case 93: {
                    this.read();
                    this.type = 20;
                    return;
                }
                case 63: {
                    this.read();
                    this.type = 35;
                    return;
                }
                case 58: {
                    this.read();
                    this.type = 36;
                    return;
                }
                case 46: {
                    int cc = this.read();
                    if (cc >= 48 && cc <= 57) {
                        this.parseReal();
                    } else {
                        this.type = 40;
                    }
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.parseNumber();
                    return;
                }
                case 40: {
                    this.read();
                    this.type = 41;
                    return;
                }
                case 41: {
                    this.read();
                    this.type = 42;
                    return;
                }
                case 44: {
                    this.read();
                    this.type = 43;
                    return;
                }
                case 34: {
                    this.read();
                    this.parseString();
                    return;
                }
                case 39: {
                    this.parseChar();
                    return;
                }
            }
            if (Character.isJavaIdentifierStart((char)this.c)) {
                this.parseID();
                return;
            }
            this.consume(-1);
        }
    }

    private int parseEscape() throws CompilationException {
        switch (this.read()) {
            case 114: {
                this.read();
                return 13;
            }
            case 110: {
                this.read();
                return 10;
            }
            case 102: {
                this.read();
                return 12;
            }
            case 98: {
                this.read();
                return 8;
            }
            case 116: {
                this.read();
                return 9;
            }
            case 34: 
            case 39: 
            case 92: {
                return this.c + (this.read() - this.c);
            }
        }
        if (this.c >= 48 && this.c <= 55) {
            int v = this.c - 48;
            int i = 0;
            while (i < 2) {
                this.read();
                if (this.c < 48 || this.c > 55) {
                    if (v > 255) {
                        this.consume(-1);
                    }
                    return v;
                }
                v = (v << 3) + this.c - 48;
                ++i;
            }
            this.read();
            if (v > 255) {
                this.consume(-1);
            }
            return v;
        }
        this.consume(-1);
        return -1;
    }

    private void parseChar() throws CompilationException {
        char ch = '\u0000';
        switch (this.read()) {
            case 92: {
                ch = (char)this.parseEscape();
                break;
            }
            case -1: 
            case 10: 
            case 13: 
            case 39: {
                this.consume(-1);
                break;
            }
            default: {
                ch = (char)this.c;
                this.read();
            }
        }
        this.consume(39);
        this.type = 60;
        this.val = new Character(ch);
    }

    private void parseString() throws CompilationException {
        Debug.check(this.buf.length() == 0);
        block5: while (true) {
            switch (this.c) {
                case -1: 
                case 10: 
                case 13: 
                case 39: {
                    this.consume(-1);
                    continue block5;
                }
                case 92: {
                    this.buf.append((char)this.parseEscape());
                    continue block5;
                }
                case 34: {
                    this.read();
                    this.type = 60;
                    this.val = this.buf.toString();
                    this.buf.setLength(0);
                    return;
                }
            }
            this.buf.append((char)this.c);
            this.read();
        }
    }

    private void parseID() throws CompilationException {
        Debug.check(this.buf.length() == 0);
        do {
            this.buf.append((char)this.c);
            this.read();
        } while (this.c > 0 && Character.isJavaIdentifierPart((char)this.c));
        this.type = 50;
        this.val = this.buf.toString();
        this.buf.setLength(0);
        if (this.val.equals("true")) {
            this.type = 60;
            this.val = Boolean.TRUE;
        } else if (this.val.equals("false")) {
            this.type = 60;
            this.val = Boolean.FALSE;
        }
    }

    private void parseNumber() throws CompilationException {
        Debug.check(this.buf.length() == 0);
        boolean seenDigit = false;
        boolean seen89 = false;
        int base = this.c == 48 ? 8 : 10;
        long value = this.c - 48;
        this.buf.append((char)this.c);
        block9: while (true) {
            switch (this.read()) {
                case 56: 
                case 57: {
                    seen89 = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    seenDigit = true;
                    this.buf.append((char)this.c);
                    if (base == 10) {
                        if (value * 10L / 10L != value) {
                            this.consume(-1);
                        }
                        value = value * 10L + (long)(this.c - 48);
                        continue block9;
                    }
                    if (base == 8) {
                        if (value >>> 61 > 0L) {
                            this.consume(-1);
                        }
                        value = (value << 3) + (long)(this.c - 48);
                        continue block9;
                    }
                    if (value >>> 60 > 0L) {
                        this.consume(-1);
                    }
                    value = (value << 4) + (long)(this.c - 48);
                    continue block9;
                }
                case 68: 
                case 69: 
                case 70: 
                case 100: 
                case 101: 
                case 102: {
                    if (base != 16) {
                        this.parseReal();
                        return;
                    }
                }
                case 65: 
                case 66: 
                case 67: 
                case 97: 
                case 98: 
                case 99: {
                    if (base != 16) break block9;
                    seenDigit = true;
                    if (value >>> 60 > 0L) {
                        this.consume(-1);
                    }
                    value = (value << 4) + (long)(10 + Character.toLowerCase((char)this.c) - 97);
                    continue block9;
                }
                case 46: {
                    if (base == 16) break block9;
                    this.parseReal();
                    return;
                }
                case 76: 
                case 108: {
                    this.read();
                    this.buf.setLength(0);
                    this.type = 60;
                    this.val = new Long(value);
                    break block9;
                }
                case 88: 
                case 120: {
                    if (this.buf.length() != 1 || base != 8) break block9;
                    base = 16;
                    seenDigit = false;
                    continue block9;
                }
                default: {
                    this.buf.setLength(0);
                    this.type = 60;
                    if (value <= 127L) {
                        this.val = new Byte((byte)value);
                        break block9;
                    }
                    if (value <= 32767L) {
                        this.val = new Short((short)value);
                        break block9;
                    }
                    if (value <= Integer.MAX_VALUE) {
                        this.val = new Integer((int)value);
                        break block9;
                    }
                    this.consume(-1);
                    break block9;
                }
            }
            break;
        }
        if (this.c == 46 || Character.isJavaIdentifierPart((char)this.c)) {
            this.consume(-1);
        } else if (base == 8 && seen89) {
            this.consume(-1);
        } else if (base == 16 && !seenDigit) {
            this.consume(-1);
        }
    }

    private void parseReal() throws CompilationException {
        char lch;
        boolean seenE = false;
        boolean makeFloat = false;
        if (this.c == 46) {
            this.read();
        }
        this.buf.append('.');
        block7: while (true) {
            switch (this.c) {
                case 69: 
                case 101: {
                    if (seenE) break block7;
                    seenE = true;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.buf.append((char)this.c);
                    break;
                }
                case 43: 
                case 45: {
                    lch = this.buf.charAt(this.buf.length() - 1);
                    if (lch != 'e' && lch != 'E') break block7;
                    this.buf.append((char)this.c);
                    break;
                }
                case 70: 
                case 102: {
                    this.read();
                    makeFloat = true;
                    break block7;
                }
                case 68: 
                case 100: {
                    this.read();
                }
                default: {
                    break block7;
                }
            }
            this.read();
        }
        if (this.c == 46 || Character.isJavaIdentifierPart((char)this.c)) {
            this.consume(-1);
        } else {
            lch = this.buf.charAt(this.buf.length() - 1);
            if (lch == 'E' || lch == 'e' || lch == '+' || lch == '-') {
                this.consume(-1);
            } else {
                this.type = 60;
                if (makeFloat) {
                    this.val = Float.valueOf(this.buf.toString());
                    if (Float.isInfinite(((Float)this.val).floatValue())) {
                        this.consume(-1);
                    }
                } else {
                    this.val = Double.valueOf(this.buf.toString());
                    if (Double.isInfinite((Double)this.val)) {
                        this.consume(-1);
                    }
                }
                this.buf.setLength(0);
            }
        }
    }

    public boolean isCast() {
        if (this.type != 41) {
            return false;
        }
        boolean t_CR = this.prevCR;
        boolean t_LF = this.prevLF;
        int t_column = this.column;
        int t_line = this.line;
        int t_pos = this.pos;
        int t_c = this.c;
        boolean result = false;
        boolean arrCast = false;
        block19: while (true) {
            switch (this.c) {
                case -1: {
                    break block19;
                }
                case 10: 
                case 13: 
                case 32: {
                    this.read();
                    continue block19;
                }
                default: {
                    if (!Character.isJavaIdentifierStart((char)this.c)) break block19;
                    this.read();
                    while (Character.isJavaIdentifierPart((char)this.c)) {
                        this.read();
                    }
                    block21: while (true) {
                        switch (this.c) {
                            case -1: {
                                break block19;
                            }
                            case 10: 
                            case 13: 
                            case 32: {
                                this.read();
                                continue block21;
                            }
                        }
                        break;
                    }
                    switch (this.c) {
                        case 46: {
                            this.read();
                            continue block19;
                        }
                        case 41: {
                            break;
                        }
                        case 91: {
                            arrCast = true;
                            break;
                        }
                        default: {
                            break block19;
                        }
                    }
                    this.read();
                    block22: while (true) {
                        switch (this.c) {
                            case 10: 
                            case 13: 
                            case 32: {
                                this.read();
                                continue block22;
                            }
                            case 93: {
                                result = true;
                            }
                            case 34: 
                            case 39: 
                            case 40: 
                            case 46: {
                                if (arrCast) break block19;
                                result = true;
                            }
                            case -1: {
                                break block19;
                            }
                            default: {
                                result = !arrCast && (this.c >= 48 && this.c <= 57 || Character.isJavaIdentifierStart((char)this.c));
                                break block19;
                            }
                        }
                        break;
                    }
                }
            }
            break;
        }
        this.prevCR = t_CR;
        this.prevLF = t_LF;
        this.c = t_c;
        this.column = t_column;
        this.line = t_line;
        this.pos = t_pos;
        return result;
    }

    public OP parse(Class resultType) throws CompilationException {
        try {
            this.expression();
            this.err_col = this.ct_column - 1;
            if (((OP)this.paramOPs.peek()).resID == 10) {
                this.paramOPs.push(new OPunary(this.paramOPs, 11, null, false));
            }
            if (resultType != null) {
                this.paramOPs.push(new OPunary(this.paramOPs, OP.typeID(resultType), resultType, false));
            }
            this.paramOPs.push(new OPunary(this.paramOPs, 3));
        }
        catch (CompilationException exc) {
            if (exc.col < 0) {
                Debug.check(this.err_col > 0);
                exc.col = this.err_col;
            }
            throw exc;
        }
        Debug.check(this.paramOPs.size() == 1, "There must be only a single item left in paramOPs stack.");
        return (OP)this.paramOPs.pop();
    }

    private void consumeT(int t) throws CompilationException {
        if (this.type != t) {
            this.consume(-1);
        }
        this.nextToken();
    }

    private void expression() throws CompilationException {
        this.nextToken();
        this.conditional();
        this.consumeT(-1);
    }

    private void conditional() throws CompilationException {
        this.binOP(0);
        if (this.type == 35) {
            int ecol = this.ct_column;
            this.nextToken();
            int stackSizeBeforeBranch = this.paramOPs.size();
            this.conditional();
            this.consumeT(36);
            int stackSizeAfterFirstBranch = this.paramOPs.size();
            this.conditional();
            this.err_col = ecol;
            Debug.check(this.paramOPs.size() == stackSizeAfterFirstBranch + 1 && stackSizeAfterFirstBranch == stackSizeBeforeBranch + 1, "Stack in conditional branches is not balanced.");
            this.paramOPs.push(new OPcondtnl(this.paramOPs));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void binOP(int idx) throws CompilationException {
        int t;
        if (idx == 9) {
            this.unary();
        } else {
            this.binOP(idx + 1);
        }
        Debug.check(idx >= 0 && idx <= 9);
        int v = (int)(idx < 5 ? 181667661137490L >>> idx * 10 : 142971423336744L >>> (idx - 5) * 10);
        while ((t = this.type) >= (v & 0x1F) && t <= (v >>> 5 & 0x1F)) {
            void var2_3;
            int ecol = this.ct_column;
            this.nextToken();
            if (idx == 9) {
                this.unary();
            } else {
                this.binOP(idx + 1);
            }
            this.err_col = ecol;
            this.paramOPs.push(new OPbinary(this.paramOPs, (int)var2_3));
        }
    }

    private void unary() throws CompilationException {
        int t = this.type;
        if (t == 1 || t == 30 || t == 31) {
            int ecol = this.ct_column;
            this.nextToken();
            this.unary();
            if (t >= 30) {
                t -= 28;
            }
            this.err_col = ecol;
            this.paramOPs.push(new OPunary(this.paramOPs, t - 1));
        } else if (this.isCast()) {
            this.consumeT(41);
            int ecol = this.ct_column;
            int accumStrt = this.typeAccum.length();
            this.typeAccum.append(this.val);
            this.consumeT(50);
            while (this.type == 40) {
                this.typeAccum.append('.');
                this.nextToken();
                this.typeAccum.append(this.val);
                this.consumeT(50);
            }
            this.consumeT(42);
            this.element();
            this.err_col = ecol;
            int typeID = 0;
            Class clazz = null;
            while (typeID < 8 && !this.typeAccum.substring(accumStrt).equals(OP.specialTypes[typeID].toString())) {
                ++typeID;
            }
            Debug.check(typeID <= 8);
            if (typeID == 8 && (clazz = this.lib.cnmap == null ? null : (Class)this.lib.cnmap.get(this.typeAccum.substring(accumStrt))) == null) {
                typeID = -1;
            }
            if (typeID == 8) {
                typeID = OP.typeID(clazz);
            }
            this.typeAccum.setLength(accumStrt);
            if (typeID < 0) {
                throw new CompilationException(4, this.typeAccum.toString());
            }
            this.paramOPs.push(new OPunary(this.paramOPs, typeID, clazz, true));
        } else {
            t = this.type;
            if (t == 60 || t == 50 || t == 41) {
                this.element();
            } else {
                this.consume(-1);
            }
        }
    }

    private void element() throws CompilationException {
        switch (this.type) {
            case 60: {
                this.paramOPs.push(new OPload(this.val));
                this.nextToken();
                break;
            }
            case 41: {
                this.nextToken();
                this.conditional();
                this.consumeT(42);
                break;
            }
            case 50: {
                this.invocation(false);
                break;
            }
            default: {
                this.consume(-1);
                break;
            }
        }
        while (this.type == 40) {
            this.nextToken();
            this.invocation(true);
        }
        this.genDVCall();
    }

    private void invocation(boolean afterDot) throws CompilationException {
        int ecol;
        int paramsStart = 0;
        Class resolveIn = null;
        boolean inDVmatch = false;
        int ecol_id = ecol = this.ct_column;
        Object idImage = this.val;
        this.consumeT(50);
        if (this.accDV != null) {
            int oldLen = this.accDV.length();
            if (afterDot) {
                this.accDV.append('.');
            }
            this.accDV.append(idImage);
            inDVmatch = this.isDV();
            if (!inDVmatch) {
                this.accDV.setLength(oldLen);
                this.err_col = ecol;
                this.genDVCall();
            }
        }
        if (!inDVmatch) {
            if (afterDot) {
                resolveIn = ((OP)this.paramOPs.peek()).resType;
            }
            paramsStart = this.paramOPs.size();
        }
        if (this.type == 41) {
            ecol = this.ct_column;
            if (inDVmatch) {
                this.err_col = ecol;
                throw new CompilationException(26, null);
            }
            this.nextToken();
            int t = this.type;
            if (t == 1 || t == 30 || t == 31 || t == 41 || t == 60 || t == 50) {
                this.conditional();
                while (this.type == 43) {
                    this.nextToken();
                    this.conditional();
                }
            }
            this.consumeT(42);
        }
        if (!inDVmatch) {
            this.err_col = ecol_id;
            this.functionCall(resolveIn, (String)idImage, paramsStart);
        }
        while (this.type == 19) {
            ecol = this.ct_column;
            this.nextToken();
            this.genDVCall();
            this.conditional();
            this.consumeT(20);
            this.err_col = ecol;
            this.paramOPs.push(new OPbinary(this.paramOPs, 19));
        }
    }

    private final boolean isDV() {
        return this.lib.resolver.getTypeName(this.accDV.toString()) != null;
    }

    private final void genDVCall() throws CompilationException {
        if (this.accDV == null || this.accDV.length() == 0) {
            return;
        }
        String varName = this.accDV.toString();
        String typeName = this.lib.resolver.getTypeName(varName);
        int paramsStart = this.paramOPs.size();
        Object varObj = this.lib.resolver instanceof DVMap ? ((DVMap)this.lib.resolver).translate(varName) : varName;
        this.paramOPs.push(new OPload(varObj));
        this.functionCall(null, "get" + typeName + "Property", paramsStart);
        this.accDV.setLength(0);
    }

    private final void functionCall(Class resolveInClass, String name, int paramsStart) throws CompilationException {
        int np = this.paramOPs.size() - paramsStart;
        Class[] params = new Class[np];
        int i = np - 1;
        while (i >= 0) {
            OP cop = (OP)this.paramOPs.pop();
            this.xchgOP.push(cop);
            params[i] = cop.resType;
            --i;
        }
        Member m = this.lib.getMember(resolveInClass, name, params);
        if (resolveInClass == null && (m.getModifiers() & 8) == 0) {
            this.paramOPs.push(new OPcall(1, new Object[0].getClass()));
            int classID = this.lib.getDynamicMethodClassID(m);
            this.paramOPs.push(new OPload(new Integer(classID)));
            this.paramOPs.push(new OPbinary(this.paramOPs, 19));
        }
        int i2 = 0;
        while (i2 < np) {
            this.paramOPs.push(this.xchgOP.pop());
            ++i2;
        }
        this.paramOPs.push(new OPcall(this.paramOPs, m, this.lib.isStateless(m)));
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        Parser.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        Library lib = new Library(null, null, null, null, null);
        Parser tok = null;
        t.startTest("Instantiate Parser and detect <EOF>");
        try {
            tok = new Parser("", lib);
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String stokens = "+ -  * / % & | \n ^ < >   [ ] ~  ! ? : . ( ) ,";
        t.println("Test simple one-symbol tokens:");
        t.println("\"" + stokens + "\"");
        t.startTest("Instantiate Parser");
        try {
            tok = new Parser(stokens, lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"+\"");
        try {
            tok.nextToken();
            t.compare(tok.type, 0);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Check it is in the first column.");
        try {
            t.compare(tok.ct_column, 1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"-\"");
        try {
            tok.nextToken();
            t.compare(tok.type, 1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Check it is in the third column.");
        try {
            t.compare(tok.ct_column, 3);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Check it is on the first line.");
        try {
            t.compare(tok.ct_line, 1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"*\"");
        try {
            tok.nextToken();
            t.compare(tok.type, 2);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Check it is in the 6th column.");
        try {
            t.compare(tok.ct_column, 6);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String[] part1 = new String[]{"/", "%", "&", "|"};
        int i = 0;
        while (i < part1.length) {
            t.startTest("Read \"" + part1[i] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.type, 3 + i);
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i;
        }
        t.startTest("Read \"^\"");
        try {
            tok.nextToken();
            t.compare(tok.type, 7);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Check it is in the 2nd column.");
        try {
            t.compare(tok.ct_column, 2);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Check it is on the second line.");
        try {
            t.compare(tok.ct_line, 2);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String[] part2Str = new String[]{"<", ">", "[", "]", "~", "!", "?", ":", ".", "(", ")", ","};
        int[] part2Int = new int[]{10, 12, 19, 20, 30, 31, 35, 36, 40, 41, 42, 43};
        int i2 = 0;
        while (i2 < part2Str.length) {
            t.startTest("Read \"" + part2Str[i2] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.type, part2Int[i2]);
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i2;
        }
        t.startTest("Read <EOF>");
        try {
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Check it is on the column 30 (beyond end of line).");
        try {
            t.compare(tok.ct_column, 30);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String mtokens = "== != >= <= << >> && || >>>";
        t.println("Test simple many-symbol tokens:");
        t.println("\"" + mtokens + "\"");
        t.startTest("Instantiate Parser");
        try {
            tok = new Parser(mtokens, lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String[] part3Str = new String[]{"==", "!=", ">=", "<=", "<<", ">>", "&&", "||", ">>>"};
        int[] part3Int = new int[]{8, 9, 11, 13, 14, 15, 17, 18, 16};
        int i3 = 0;
        while (i3 < part3Str.length) {
            t.startTest("Read \"" + part3Str[i3] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.type, part3Int[i3]);
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i3;
        }
        String mctokens = "=! !! >! <! &! |! >!> >>!";
        t.println("Test simple many-symbol tokens cut off:");
        t.println("\"" + mctokens + "\"");
        t.startTest("Instantiate Parser");
        try {
            tok = new Parser(mctokens, lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"=\" (must give an error)");
        try {
            tok.nextToken();
            t.testFail();
        }
        catch (CompilationException e) {
            t.compare(e.col, 2);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String[] part4Str = new String[]{"!", "!", "!", ">", "!", "<", "!", "&", "!", "|", "!", ">", "!", ">", ">>", "!"};
        int[] part4Int = new int[]{31, 31, 31, 12, 31, 10, 31, 5, 31, 6, 31, 12, 31, 12, 15, 31};
        int i4 = 0;
        while (i4 < part4Str.length) {
            t.startTest("Read \"" + part4Str[i4] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.type, part4Int[i4]);
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i4;
        }
        t.startTest("Read <EOF>");
        try {
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String chartokens = "' ' '\\n' 'a' '\\052' '\\\\' '\n' '\\'";
        char[] char1 = new char[]{' ', '\n', 'a', '*', '\\'};
        t.println("Test char tokens :");
        t.println("\"" + chartokens + "\"");
        t.startTest("Instantiate Parser");
        try {
            tok = new Parser(chartokens, lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        int i5 = 0;
        while (i5 < char1.length) {
            t.startTest("Read \"" + char1[i5] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.val, new Character(char1[i5]));
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i5;
        }
        t.startTest("Read char with NL (must give an error)");
        try {
            tok.nextToken();
            t.testFail();
        }
        catch (CompilationException e) {
            t.compare(e.col, 27);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read '\\' (must give an error, unexp EOF)");
        try {
            tok = new Parser("'\\'", lib);
            tok.nextToken();
            t.testFail();
        }
        catch (CompilationException e) {
            t.compare(e.col, 3);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read '  ' (must give an error)");
        try {
            tok = new Parser("'  '", lib);
            tok.nextToken();
            t.testFail();
        }
        catch (CompilationException e) {
            t.compare(e.col, 3);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String strtokens = "\"\" \" \" \"ab\\052c\"";
        String[] str1 = new String[]{"", " ", "ab*c"};
        t.println("Test String tokens:");
        t.println("\"" + strtokens + "\"");
        t.startTest("Instantiate Parser");
        try {
            tok = new Parser(strtokens, lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        int i6 = 0;
        while (i6 < str1.length) {
            t.startTest("Read \"" + str1[i6] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.val, str1[i6]);
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i6;
        }
        t.startTest("Instantiate Parser(\"a+bba\")");
        try {
            tok = new Parser("a+bba", lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"a\"");
        try {
            tok.nextToken();
            t.compare(tok.val, "a");
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"+\"");
        try {
            tok.nextToken();
            t.compare(tok.type, 0);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"bba\"");
        try {
            tok.nextToken();
            t.compare(tok.val, "bba");
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read <EOF>");
        try {
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String i1tokens = "1 011 258   0xFF 67000 456890L";
        Object[] i1 = new Object[]{new Byte(1), new Byte(9), new Short(258), new Short(255), new Integer(67000), new Long(456890L)};
        t.println("Test integer tokens:");
        t.println("\"" + i1tokens + "\"");
        t.startTest("Instantiate Parser");
        try {
            tok = new Parser(i1tokens, lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        int i7 = 0;
        while (i7 < i1.length) {
            t.startTest("Read \"" + i1[i7] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.val, i1[i7]);
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i7;
        }
        t.startTest("Read <EOF>");
        try {
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String d1tokens = ".1 0.1 0.1E1 001.0E-1 001.0E-1F 1F";
        Object[] d1 = new Object[]{new Double(0.1), new Double(0.1), new Double(1.0), new Double(0.1), new Float(0.1), new Float(1.0)};
        t.println("Test real tokens:");
        t.println("\"" + d1tokens + "\"");
        t.startTest("Instantiate Parser");
        try {
            tok = new Parser(d1tokens, lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        int i8 = 0;
        while (i8 < d1.length) {
            t.startTest("Read \"" + d1[i8] + "\"");
            try {
                tok.nextToken();
                t.compare(tok.val, d1[i8]);
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i8;
        }
        t.startTest("Read <EOF>");
        try {
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Instantiate Parser(\"1\")");
        try {
            tok = new Parser("1", lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("isCast()=false");
        try {
            tok.nextToken();
            if (!tok.isCast()) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"1\"");
        try {
            tok.nextToken();
            t.compare(tok.val, new Byte(1));
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read <EOF>");
        try {
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        String[] fcasts = new String[]{"1", "(", "()", "(a", "(a[", "(a)", "(a)-"};
        int i9 = 0;
        while (i9 < fcasts.length) {
            t.startTest("False cast \"" + fcasts[i9] + "\"");
            try {
                tok = new Parser(fcasts[i9], lib);
                if (!tok.isCast()) {
                    t.testOK();
                } else {
                    t.testFail();
                }
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i9;
        }
        String[] tcasts = new String[]{"(a)(", "(a.b.c)0", "(a.b.c[]", " ( a ) ( ", " ( a . b . c ) 0 ", " ( a .  b . c [  ] "};
        int i10 = 0;
        while (i10 < tcasts.length) {
            t.startTest("True cast \"" + tcasts[i10] + "\"");
            try {
                tok = new Parser(tcasts[i10], lib);
                tok.nextToken();
                if (tok.isCast()) {
                    t.testOK();
                } else {
                    t.testFail();
                }
            }
            catch (Exception e) {
                t.testFail();
                Debug.reportThrowable(e);
            }
            ++i10;
        }
        t.startTest("Instantiate Parser(\"1.0-+1.0\")");
        try {
            tok = new Parser("1.0-+1.0", lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"1.0D\"");
        try {
            tok.nextToken();
            if (tok.type == 60 && new Double(1.0).equals(tok.val)) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Instantiate Parser(\"sin(1)\")");
        try {
            tok = new Parser("sin(1)", lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"sin\"");
        try {
            tok.nextToken();
            if (tok.type == 50 && "sin".equals(tok.val)) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("isCast()=false");
        try {
            if (!tok.isCast()) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"(\"");
        try {
            tok.nextToken();
            t.compare(tok.type, 41);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \"1\"");
        try {
            tok.nextToken();
            if (tok.type == 60 && new Byte(1).equals(tok.val)) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read \")\"");
        try {
            tok.nextToken();
            t.compare(tok.type, 42);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Read <EOF>");
        try {
            tok.nextToken();
            t.compare(tok.type, -1);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Instantiate Parser(\"(float)4\")");
        try {
            tok = new Parser("(float)4", lib);
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("isCast()=true");
        try {
            tok.nextToken();
            if (tok.isCast()) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
    }
}

