/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;

class IntegerStack
implements Cloneable {
    private int[] data;
    private int count = 0;

    public IntegerStack(int initCapacity) {
        this.data = new int[initCapacity];
    }

    public IntegerStack() {
        this(30);
    }

    public Object clone() {
        IntegerStack res = null;
        try {
            res = (IntegerStack)super.clone();
            res.data = (int[])res.data.clone();
        }
        catch (CloneNotSupportedException exc) {
            Debug.reportThrowable(exc);
        }
        return res;
    }

    public final void push(int what) {
        if (this.count >= this.data.length) {
            this.increaseCapacity(this.count + 1);
        }
        this.data[this.count++] = what;
    }

    public final int peek() {
        return this.data[this.count - 1];
    }

    public final int peek(int i) {
        return this.data[this.count - 1 - i];
    }

    public final void push(int what, int i) {
        if (this.count >= this.data.length) {
            this.increaseCapacity(this.count + 1);
        }
        i = this.count - i;
        System.arraycopy(this.data, i, this.data, i + 1, this.count - i);
        this.data[i] = what;
        ++this.count;
    }

    public final int pop() {
        return this.data[--this.count];
    }

    public final int size() {
        return this.count;
    }

    public final void pop_throw() {
        --this.count;
        Debug.assert(this.count >= 0, "Stack is empty when removing top.");
    }

    public static void swap(IntegerStack one, int oneLim, IntegerStack other, int otherLim) {
        boolean cf_other;
        int copyFromOne = one.count - oneLim;
        int copyFromOther = other.count - otherLim;
        boolean cf_one = copyFromOne > 0;
        boolean bl = cf_other = copyFromOther > 0;
        if (cf_one || cf_other) {
            int nSizeOne = oneLim + copyFromOther;
            int nSizeOther = otherLim + copyFromOne;
            if (nSizeOne > one.data.length) {
                one.increaseCapacity(nSizeOne);
            }
            if (nSizeOther > other.data.length) {
                other.increaseCapacity(nSizeOther);
            }
            int[] temp = null;
            if (cf_one) {
                temp = new int[copyFromOne];
                System.arraycopy(one.data, oneLim, temp, 0, copyFromOne);
            }
            if (cf_other) {
                System.arraycopy(other.data, otherLim, one.data, oneLim, copyFromOther);
            }
            if (cf_one) {
                System.arraycopy(temp, 0, other.data, otherLim, copyFromOne);
            }
            one.count = nSizeOne;
            other.count = nSizeOther;
        }
    }

    private synchronized void increaseCapacity(int minCapacity) {
        int[] old_data = this.data;
        int oldSize = this.data.length;
        int newSize = oldSize * 2;
        if (newSize < minCapacity) {
            newSize = minCapacity;
        }
        this.data = new int[newSize];
        System.arraycopy(old_data, 0, this.data, 0, this.count);
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        IntegerStack.test(t);
        t.summarize();
    }

    public static void test(Tester t) {
        IntegerStack is = null;
        try {
            t.startTest("Make a new stack.");
            is = new IntegerStack(1);
            t.testOK();
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(10)");
            is.push(10);
            t.testOK();
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("peek()==10");
            t.compare(is.peek(), 10);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(10); pop()==10");
            is.push(10);
            t.compare(is.pop(), 10);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(11)");
            is.push(11);
            t.testOK();
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("peek(0)=11");
            t.compare(is.peek(0), 11);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("peek(1)=10");
            t.compare(is.peek(1), 10);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(12,0); pop()==12");
            is.push(12, 0);
            t.compare(is.pop(), 12);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("push(12,1); pop()==11");
            is.push(12, 1);
            t.compare(is.pop(), 11);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("pop()==12");
            t.compare(is.pop(), 12);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("pop()==10");
            t.compare(is.pop(), 10);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        try {
            t.startTest("size()==0");
            t.compare(is.size(), 0);
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
    }
}

