/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import gnu.jel.reflect.Field;
import gnu.jel.reflect.LocalField;
import gnu.jel.reflect.Member;
import gnu.jel.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Library {
    private Hashtable names = new Hashtable();
    private Hashtable dynIDs = new Hashtable();
    private Hashtable stateless = new Hashtable();

    public Library(Class[] staticLib, Class[] dynamicLib) {
        if (staticLib != null) {
            this.rehash(staticLib, true);
        }
        if (dynamicLib != null) {
            this.rehash(dynamicLib, false);
        }
    }

    private String describe(String name, Class[] params) {
        String res = "";
        StringBuffer invp = new StringBuffer();
        invp.append(name);
        invp.append('(');
        if (params != null) {
            int k = 0;
            while (k < params.length) {
                if (k != 0) {
                    invp.append(',');
                }
                invp.append(params[k].toString());
                ++k;
            }
        }
        invp.append(')');
        res = invp.toString();
        return res;
    }

    public int getDynamicMethodClassID(Member m) {
        Integer id = (Integer)this.dynIDs.get(m);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public Member getMember(String name, Class[] params) throws NoSuchMethodException {
        Hashtable signatures = (Hashtable)this.names.get(name);
        if (signatures == null) {
            throw new NoSuchMethodException("The name \"" + name + "\" is not defined.");
        }
        Vector<Member> applicable_methods = new Vector<Member>();
        Enumeration e = signatures.elements();
        while (e.hasMoreElements()) {
            Member cm = (Member)e.nextElement();
            Class[] cp = cm.getParameterTypes();
            boolean applicable = false;
            if (params != null) {
                if (cp.length == params.length) {
                    applicable = true;
                    int i = 0;
                    while (i < cp.length && applicable) {
                        applicable = TypesStack.isWidening(params[i], cp[i]);
                        ++i;
                    }
                }
            } else {
                boolean bl = applicable = cp.length == 0;
            }
            if (!applicable) continue;
            applicable_methods.addElement(cm);
        }
        if (applicable_methods.size() == 0) {
            throw new NoSuchMethodException("Function \"" + name + "\" exists," + " but parameters " + this.describe(name, params) + " can not be accepted by it.");
        }
        if (applicable_methods.size() == 1) {
            return (Member)applicable_methods.firstElement();
        }
        Enumeration e2 = applicable_methods.elements();
        Member most_specific = (Member)e2.nextElement();
        Class[] most_specific_params = most_specific.getParameterTypes();
        while (e2.hasMoreElements()) {
            Member cm = (Member)e2.nextElement();
            Class[] cp = cm.getParameterTypes();
            boolean moreSpecific = true;
            boolean lessSpecific = true;
            int i = 0;
            while (i < cp.length) {
                moreSpecific = moreSpecific && TypesStack.isWidening(cp[i], most_specific_params[i]);
                lessSpecific = lessSpecific && TypesStack.isWidening(most_specific_params[i], cp[i]);
                ++i;
            }
            if (moreSpecific && !lessSpecific) {
                most_specific = cm;
                most_specific_params = cp;
            }
            if (moreSpecific ^ lessSpecific) continue;
            throw new NoSuchMethodException("Ambiguity detected between \"" + this.describe(name, most_specific_params) + "\" and \"" + this.describe(name, cp) + "\" on invocation \"" + this.describe(name, params) + "\" .");
        }
        return most_specific;
    }

    public boolean isStateless(Member o) {
        return this.stateless.containsKey(o);
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        Library.test(t);
        t.summarize();
    }

    public void markStateDependent(String name, Class[] params) throws NoSuchMethodException {
        Member m = this.getMember(name, params);
        Object removed = this.stateless.remove(m);
        Debug.assert(removed != null, "State dependent methos \"" + m + "\"is made state dependend again.");
    }

    private boolean rehash(Member m) {
        Hashtable signatures;
        String name = m.getName();
        String signature = ClassFile.getSignature(m);
        if (m instanceof Field) {
            signature = "()" + signature;
        }
        if ((signatures = (Hashtable)this.names.get(name)) == null) {
            Hashtable<String, Member> signatures_new = new Hashtable<String, Member>();
            signatures_new.put(signature, m);
            this.names.put(name, signatures_new);
            return true;
        }
        Object conflicting_method = signatures.get(signature);
        if (conflicting_method == null) {
            signatures.put(signature, m);
            return true;
        }
        Debug.println("Conflict was detected during the library initialization. Conflicting \"" + name + signature + "\", conflicting :" + conflicting_method + " and " + m + " .");
        return false;
    }

    private void rehash(Class[] arr, boolean gather_stateless) {
        int i = 0;
        while (i < arr.length) {
            Integer dynID = new Integer(i);
            java.lang.reflect.Method[] marr = arr[i].getMethods();
            java.lang.reflect.Field[] farr = arr[i].getFields();
            int totalMethods = marr.length;
            int totalMembers = totalMethods + farr.length;
            int j = 0;
            while (j < totalMembers) {
                LocalField m;
                LocalField localField = m = j < totalMethods ? new Method(marr[j]) : new Field(farr[j - totalMethods]);
                if ((m.getModifiers() & 8) > 0) {
                    if (gather_stateless && this.rehash(m)) {
                        this.stateless.put(m, Boolean.TRUE);
                    }
                } else if (!gather_stateless && this.rehash(m)) {
                    this.dynIDs.put(m, dynID);
                }
                ++j;
            }
            ++i;
        }
    }

    public static void test(Tester t) {
        Class[] par1;
        Member mf;
        Class[] par;
        Library ll = null;
        Class<?> math = null;
        try {
            math = Class.forName("java.lang.Math");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println("It is IMPOSSIBLE :)");
        }
        t.startTest("Creating the library of java.lang.Math");
        try {
            Library l;
            Class[] sl = new Class[]{math};
            ll = l = new Library(sl, null);
            t.testOK();
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(double)");
        try {
            par = new Class[]{Double.TYPE};
            mf = ll.getMember("round", par);
            if (mf != null && mf.equals(new Method(math.getMethod("round", par)))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(float)");
        try {
            par = new Class[]{Float.TYPE};
            mf = ll.getMember("round", par);
            if (mf != null && mf.equals(new Method(math.getMethod("round", par)))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation round(int) best is round(float)");
        try {
            par = new Class[]{Integer.TYPE};
            mf = ll.getMember("round", par);
            par1 = new Class[]{Float.TYPE};
            if (mf != null && mf.equals(new Method(math.getMethod("round", par1)))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(int) best is abs(int)");
        try {
            par = new Class[]{Integer.TYPE};
            mf = ll.getMember("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(new Method(math.getMethod("abs", par1)))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(byte) best is abs(int)");
        try {
            par = new Class[]{Byte.TYPE};
            mf = ll.getMember("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(new Method(math.getMethod("abs", par1)))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation abs(char) best is abs(int)");
        try {
            par = new Class[]{Character.TYPE};
            mf = ll.getMember("abs", par);
            par1 = new Class[]{Integer.TYPE};
            if (mf != null && mf.equals(new Method(math.getMethod("abs", par1)))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of invocation min(int,float) best is min(float,float)");
        try {
            par = new Class[]{Integer.TYPE, Float.TYPE};
            mf = ll.getMember("min", par);
            par1 = new Class[]{Float.TYPE, Float.TYPE};
            if (mf != null && mf.equals(new Method(math.getMethod("min", par1)))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Attempt of access to the field PI");
        try {
            par = new Class[]{};
            Member f = ll.getMember("PI", par);
            if (f != null && f.getName().equals("PI")) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
        t.startTest("Checking assignment of state dependence ");
        try {
            ll.markStateDependent("random", null);
            if (!ll.isStateless(ll.getMember("random", null))) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            Debug.reportThrowable(e);
            t.testFail();
        }
    }
}

