/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompiledExpression;
import gnu.jel.ExpressionBits;
import gnu.jel.IntegerStack;
import gnu.jel.PatchableByteArrayOutputStream;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class ExpressionImage {
    public static final int BI_PL = 0;
    public static final int BI_MI = 1;
    public static final int BI_MU = 2;
    public static final int BI_DI = 3;
    public static final int BI_RE = 4;
    public static final int BI_AN = 5;
    public static final int BI_OR = 6;
    public static final int BI_XO = 7;
    public static final int BI_EQ = 8;
    public static final int BI_NE = 9;
    public static final int BI_LT = 10;
    public static final int BI_GE = 11;
    public static final int BI_GT = 12;
    public static final int BI_LE = 13;
    public static final int BI_LS = 14;
    public static final int BI_RSS = 15;
    public static final int BI_RUS = 16;
    public static final String[] binaryNames = new String[]{"add", "substract", "multiply", "divide", "remainder", "bitwise and", "bitwise or", "bitwise xor", "equal", "not equal", "less", "greater or equal", "greater", "less or equal", "left shift", "signed right shift", "unsigned right shift"};
    public static final String[] binarySymbols = new String[]{"+", "-", "*", "/", "%", "&", "|", "^", "==", "!=", "<", ">=", ">", "<=", "<<", ">>", ">>>"};
    public static final int LOG_AN = 0;
    public static final int LOG_OR = 1;
    public static final int LOG_NO = 2;
    public static final String[] logicalNames = new String[]{"logical and", "logical or", "logical not"};
    public static final String[] logicalSymbols = new String[]{"&&", "||", "!"};
    public static final int UN_NE = 0;
    public static final int UN_NO = 1;
    public static final String[] unaryNames = new String[]{"negate", "bitwise complement"};
    public static final String[] unarySymbols = new String[]{"-", "~"};
    private static final byte[] prologue;
    private int poolEntries = 1;
    private static final byte[] cp_middle;
    private static final byte[] intermezzo1;
    private byte thetype = (byte)99;
    private static final byte[] intermezzo2;
    short nameIdx = (short)9999;
    short signIdx = (short)9999;
    private static final byte[] intermezzo3;
    int max_stack = 2;
    int max_locals = 2;
    private static final byte[] konetc;
    public static final Class[] primitiveTypes;
    private static final char[] primitiveCodes;
    public static final String[] primitiveTypeNames;
    private static Class sb_class;
    private static Class tsb_class;
    private static Class string_class;
    private static Constructor sb_constructor;
    private static Method[] sb_append_primitive;
    private static Method sb_append_String;
    private static Method sb_append_Object;
    private static Method sb_toString;
    private static final byte[] returns;
    private static final byte[] cvt_wide;
    private static final int[][] cvt1;
    private static final int[][] cvt2;
    private static final byte[] stkoccup;
    private static final int[] load_ints;
    private static final int[] load_long_ints1;
    private static final int[] load_long_ints2;
    private static final int[][] binary_promotions;
    private static final int[] unary_promotions;
    private static final int[][][] ops;
    private static final boolean[] is_promotion_binary;
    private static final int[][] openjumps;
    private static final int[] norm;
    private static final int[][][] una;
    private static final int[][] una_excess_stack;
    private static final byte[] stor;
    private static final byte[] load;
    private static final byte[] sladdr;
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private ByteArrayOutputStream constPool;
    private DataOutputStream constPoolData;
    private Hashtable Items = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    private PatchableByteArrayOutputStream methodText;
    private DataOutputStream methodTextData;
    private boolean classFinished = false;
    private int currSSW;
    private Vector objectPool = new Vector();
    private Stack typesStk = new Stack();
    int jump_progress;
    private Stack functionParams = new Stack();
    private Stack functionINTS = new Stack();
    private Stack functionRet = new Stack();
    private IntegerStack jumps0 = new IntegerStack();
    private IntegerStack jumps1 = new IntegerStack();
    private IntegerStack jumps = new IntegerStack();
    private IntegerStack blocks0 = new IntegerStack();
    private IntegerStack blocks1 = new IntegerStack();
    private IntegerStack branchStack = new IntegerStack();
    private boolean invert_next_jump = false;

    private static final byte invert_jump_bytecode(int jmp) {
        Debug.assert(jmp >= 153 && jmp <= 164, "Attempt to invert non jump bytecode (" + jmp + ")");
        return (byte)((jmp - 1 ^ 1) + 1);
    }

    public static final boolean isPromotionBinary(int binary_op) {
        return is_promotion_binary[binary_op];
    }

    public ExpressionImage() {
        this.constPool = new ByteArrayOutputStream();
        this.constPoolData = new DataOutputStream(this.constPool);
        this.methodText = new PatchableByteArrayOutputStream();
        this.methodTextData = new DataOutputStream(this.methodText);
        ++this.poolEntries;
        try {
            this.constPoolData.write(cp_middle);
            this.poolEntries += 18;
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
    }

    private final void checkAlter() {
        Debug.assert(!this.classFinished, "Attempt to modify finished class.");
    }

    private int getUTFIndex(String str) {
        Integer index = (Integer)this.UTFs.get(str);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(1);
                this.constPoolData.writeUTF(str);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.UTFs.put(str, index);
        }
        return index;
    }

    private int getLongIndex(Long val) {
        Integer index = (Integer)this.Items.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(5);
                this.constPoolData.writeLong(val);
                ++this.poolEntries;
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Items.put(val, index);
        }
        return index;
    }

    private int getIntIndex(Integer val) {
        Integer index = (Integer)this.Items.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(3);
                this.constPoolData.writeInt(val);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Items.put(val, index);
        }
        return index;
    }

    private int getFloatIndex(Float val) {
        Integer index = (Integer)this.Items.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(4);
                this.constPoolData.writeFloat(val.floatValue());
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Items.put(val, index);
        }
        return index;
    }

    private int getDoubleIndex(Double val) {
        Integer index = (Integer)this.Items.get(val);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(6);
                this.constPoolData.writeDouble(val);
                ++this.poolEntries;
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Items.put(val, index);
        }
        return index;
    }

    private int getStringIndex(String str) {
        Integer index = (Integer)this.Items.get(str);
        if (index == null) {
            int UTFIndex = this.getUTFIndex(str);
            index = new Integer(this.poolEntries++);
            try {
                this.checkAlter();
                this.constPoolData.write(8);
                this.constPoolData.writeShort(UTFIndex);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.Items.put(str, index);
        }
        return index;
    }

    private int getClassIndex(Class the_class) {
        Integer index = (Integer)this.Items.get(the_class);
        if (index == null) {
            String fqcn = the_class.getName();
            String histNameStr = ExpressionImage.toHistoricalForm(fqcn);
            int UTFIndex = this.getUTFIndex(histNameStr);
            index = new Integer(this.poolEntries++);
            this.writeClassInfo(UTFIndex);
            this.Items.put(the_class, index);
        }
        return index;
    }

    private void writeClassInfo(int nameInd) {
        try {
            this.checkAlter();
            this.constPoolData.write(7);
            this.constPoolData.writeShort(nameInd);
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
    }

    private int getMethodIndex(Method the_method) {
        Integer index = (Integer)this.Items.get(the_method);
        if (index == null) {
            index = new Integer(this.writeMethodRef(the_method.getName(), ExpressionImage.getSignature(the_method), the_method.getDeclaringClass()));
            this.Items.put(the_method, index);
        }
        return index;
    }

    private int getMethodIndex(Constructor constructor) {
        Integer index = (Integer)this.Items.get(constructor);
        if (index == null) {
            index = new Integer(this.writeMethodRef("<init>", ExpressionImage.getSignature(constructor), constructor.getDeclaringClass()));
            this.Items.put(constructor, index);
        }
        return index;
    }

    private int writeMethodRef(String name, String signature, Class declaringClass) {
        int name_ind = this.getUTFIndex(name);
        int sign_ind = this.getUTFIndex(signature);
        int cls_ind = this.getClassIndex(declaringClass);
        int nat_ind = this.poolEntries++;
        try {
            this.checkAlter();
            this.constPoolData.write(12);
            this.constPoolData.writeShort(name_ind);
            this.constPoolData.writeShort(sign_ind);
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
        int index = this.poolEntries++;
        int mtd_type = 10;
        if (declaringClass.isInterface()) {
            mtd_type = 11;
        }
        try {
            this.checkAlter();
            this.constPoolData.write(mtd_type);
            this.constPoolData.writeShort(cls_ind);
            this.constPoolData.writeShort(nat_ind);
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
        }
        return index;
    }

    public static String getSignature(Method m) {
        StringBuffer signature = new StringBuffer();
        ExpressionImage.appendParametersSignature(signature, m.getParameterTypes());
        signature.append(ExpressionImage.getSignature(m.getReturnType()));
        return signature.toString();
    }

    public static String getSignature(Constructor c) {
        StringBuffer signature = new StringBuffer();
        ExpressionImage.appendParametersSignature(signature, c.getParameterTypes());
        signature.append('V');
        return signature.toString();
    }

    private static void appendParametersSignature(StringBuffer signature, Class[] parameters) {
        signature.append('(');
        int i = 0;
        while (i < parameters.length) {
            signature.append(ExpressionImage.getSignature(parameters[i]));
            ++i;
        }
        signature.append(')');
    }

    public static String getSignature(Class cls) {
        if (cls.isPrimitive()) {
            return String.valueOf(primitiveCodes[ExpressionImage.primitiveID(cls)]);
        }
        if (cls.isArray()) {
            return String.valueOf('[') + ExpressionImage.getSignature(cls.getComponentType());
        }
        return String.valueOf('L') + ExpressionImage.toHistoricalForm(cls.getName()) + ';';
    }

    private static String toHistoricalForm(String className) {
        StringBuffer histName = new StringBuffer(className);
        int namelen = className.length();
        int i = className.indexOf(46);
        while (i > 0 && i < namelen) {
            histName.setCharAt(i, '/');
            i = className.indexOf(46, i + 1);
        }
        return histName.toString();
    }

    public ExpressionBits getBits() {
        Debug.assert(this.classFinished, "Attempt to get the code of unfinished class.");
        try {
            ByteArrayOutputStream image = new ByteArrayOutputStream();
            DataOutputStream imageData = new DataOutputStream(image);
            imageData.write(prologue);
            imageData.writeShort(this.poolEntries);
            byte[] beforeName = image.toByteArray();
            image.reset();
            this.constPool.writeTo(imageData);
            imageData.write(intermezzo1);
            imageData.write(this.thetype);
            imageData.write(intermezzo2);
            imageData.writeShort(this.nameIdx);
            imageData.writeShort(this.signIdx);
            imageData.write(intermezzo3);
            int code_len = this.methodText.size();
            imageData.writeInt(code_len + 12);
            imageData.writeShort(this.max_stack);
            imageData.writeShort(this.max_locals);
            imageData.writeInt(code_len);
            this.methodText.writeTo(imageData);
            imageData.write(konetc);
            byte[] afterName = image.toByteArray();
            Object[] objectConstants = new Object[this.objectPool.size()];
            this.objectPool.copyInto(objectConstants);
            return new ExpressionBits(beforeName, afterName, objectConstants);
        }
        catch (IOException e) {
            Debug.reportThrowable(e);
            return null;
        }
    }

    public byte[] getImage() {
        return this.getBits().getImage();
    }

    public CompiledExpression getExpression() {
        return this.getBits().getExpression();
    }

    private final void ensureStack() {
        if (this.currSSW > this.max_stack) {
            this.max_stack = this.currSSW;
        }
    }

    private final void codeOP(int op) {
        try {
            this.methodTextData.write(op);
        }
        catch (IOException iOException) {}
    }

    private final void codeINDEX(int ind) {
        try {
            this.methodTextData.writeShort(ind);
        }
        catch (IOException iOException) {}
    }

    static final int primitiveID(Class c) {
        Debug.assert(c.isPrimitive(), "PrimitiveID should be used for primitive types only.");
        int i = 0;
        while (i < primitiveTypes.length && primitiveTypes[i] != c) {
            ++i;
        }
        Debug.assert(i < primitiveTypes.length, "You didn't put _ALL_ primitive types into primitiveTypes array.");
        return i;
    }

    private static final int stackSpace(Class c) {
        if (c.isPrimitive()) {
            return stkoccup[ExpressionImage.primitiveID(c)];
        }
        return 1;
    }

    public void asm_load_object(Object o) {
        if (o == null) {
            this.typesStk.push(null);
            this.codeOP(1);
            ++this.currSSW;
            this.ensureStack();
        } else if (o instanceof String) {
            this.typesStk.push(string_class);
            int index = this.getStringIndex((String)o);
            if (index < 255) {
                this.codeOP(18);
                this.codeOP(index);
            } else {
                this.codeOP(19);
                this.codeINDEX(index);
            }
            ++this.currSSW;
            this.ensureStack();
        } else {
            int opi = this.objectPool.indexOf(o);
            if (opi == -1) {
                this.objectPool.addElement(o);
                opi = this.objectPool.size() - 1;
            }
            this.typesStk.push(o.getClass());
            this.currSSW += 2;
            this.ensureStack();
            this.codeOP(42);
            this.codeOP(180);
            this.codeINDEX(15);
            if (opi < 255) {
                this.codeOP(16);
                this.codeOP(opi);
            } else {
                int opii = this.getIntIndex(new Integer(opi));
                this.codeOP(19);
                this.codeINDEX(opii);
            }
            this.codeOP(50);
            int clsind = this.getClassIndex(o.getClass());
            this.codeOP(192);
            this.codeINDEX(clsind);
            --this.currSSW;
        }
    }

    public void asm_load_primitive(Object o) {
        this.checkAlter();
        int short_opcode1 = 0;
        int short_opcode2 = 0;
        int CP_index = -1;
        int typeid = -1;
        if (o instanceof Double) {
            Double dou = (Double)o;
            double dv = dou;
            if (dv == 0.0) {
                short_opcode1 = 14;
            } else if (dv == 1.0) {
                short_opcode1 = 15;
            } else {
                CP_index = this.getDoubleIndex(dou);
            }
            typeid = 7;
        } else if (o instanceof Long) {
            Long lo = (Long)o;
            long lv = lo;
            if (lv >= -1L && lv <= 5L) {
                short_opcode1 = load_long_ints1[(int)lv + 1];
                short_opcode2 = load_long_ints2[(int)lv + 1];
            } else {
                CP_index = this.getLongIndex(lo);
            }
            typeid = 5;
        } else if (o instanceof Float) {
            Float fo = (Float)o;
            float fv = fo.floatValue();
            if ((double)fv == 0.0) {
                short_opcode1 = 11;
            } else if ((double)fv == 1.0) {
                short_opcode1 = 12;
            } else if ((double)fv == 2.0) {
                short_opcode1 = 13;
            }
            CP_index = this.getFloatIndex(fo);
            typeid = 6;
        } else if (o instanceof Integer || o instanceof Byte || o instanceof Short || o instanceof Character) {
            typeid = 4;
            if (o instanceof Short) {
                typeid = 3;
            } else if (o instanceof Character) {
                typeid = 2;
            } else if (o instanceof Byte) {
                typeid = 1;
            }
            int iv = typeid != 2 ? ((Number)o).intValue() : (int)((Character)o).charValue();
            if (iv >= -1 && iv <= 5) {
                short_opcode1 = load_ints[iv + 1];
            } else {
                CP_index = typeid == 4 ? this.getIntIndex((Integer)o) : this.getIntIndex(new Integer(iv));
            }
        } else if (o instanceof Boolean) {
            typeid = 0;
            short_opcode1 = ((Boolean)o).booleanValue() ? 4 : 3;
        } else {
            Debug.println("Attempt to load object as a primitive type detected.");
        }
        byte stack_occupation = stkoccup[typeid];
        if (short_opcode1 == 0) {
            Debug.assert(stack_occupation == 1 || stack_occupation == 2, "Primitive types must occupy 1 or 2 words in java stack.");
            int opload = 19;
            if (stack_occupation == 2) {
                opload = 20;
            }
            if (opload == 19 && CP_index < 255) {
                this.codeOP(opload - 1);
                this.codeOP(CP_index);
            } else {
                this.codeOP(opload);
                this.codeINDEX(CP_index);
            }
        } else {
            this.codeOP(short_opcode1);
            if (short_opcode2 != 0) {
                this.codeOP(short_opcode2);
            }
        }
        this.currSSW += stack_occupation;
        this.ensureStack();
        this.typesStk.push(primitiveTypes[typeid]);
    }

    public static boolean canConvert(Class t1, Class t2) {
        boolean pt1 = t1.isPrimitive();
        boolean pt2 = t2.isPrimitive();
        if (pt2 && pt1) {
            int it1 = ExpressionImage.primitiveID(t1);
            int it2 = ExpressionImage.primitiveID(t2);
            return cvt1[it2][it1] != 255;
        }
        if (pt2 ^ pt1) {
            return false;
        }
        return t2.isAssignableFrom(t1);
    }

    public static boolean canConvertByWidening(Class t1, Class t2) {
        boolean pt1 = t1.isPrimitive();
        boolean pt2 = t2.isPrimitive();
        if (pt2 && pt1) {
            int it1 = ExpressionImage.primitiveID(t1);
            int it2 = ExpressionImage.primitiveID(t2);
            return (cvt_wide[it2] & 128 >> it1) > 0;
        }
        if (pt2 ^ pt1) {
            return false;
        }
        return t2.isAssignableFrom(t1);
    }

    public boolean asm_convert(Class type) {
        Class typeNOW = (Class)this.typesStk.peek();
        if (type == typeNOW) {
            return true;
        }
        boolean ptn = typeNOW.isPrimitive();
        boolean pt = type.isPrimitive();
        if (ptn && pt) {
            int tni = ExpressionImage.primitiveID(typeNOW);
            int ti = ExpressionImage.primitiveID(type);
            int op1 = cvt1[ti][tni];
            int op2 = cvt2[ti][tni];
            if (op1 == 255) {
                Debug.assert(false, "Incompatible types in asm_convert");
                return false;
            }
            this.currSSW = this.currSSW + stkoccup[ti] - stkoccup[tni];
            this.ensureStack();
            if (op1 != 0) {
                this.codeOP(op1);
            }
            if (op2 != 0) {
                this.codeOP(op2);
            }
            this.typesStk.pop();
            this.typesStk.push(type);
            return true;
        }
        if (ptn ^ pt) {
            Debug.println("Can't convert between pimitive and object types in this version.");
            return false;
        }
        this.typesStk.pop();
        this.typesStk.push(type);
        return true;
    }

    public static Class getBinaryPromoted(Class c1, Class c2) {
        Debug.assert(c1.isPrimitive() && c2.isPrimitive(), "Both types for the binary promotion should be primitive.");
        int ic1 = ExpressionImage.primitiveID(c1);
        int ic2 = ExpressionImage.primitiveID(c2);
        int idx = binary_promotions[ic1][ic2];
        if (idx == 255) {
            return null;
        }
        return primitiveTypes[idx];
    }

    public static Class getUnaryPromoted(Class c) {
        Debug.assert(c.isPrimitive(), "Both types for the binary promotion should be primitive.");
        int ic = unary_promotions[ExpressionImage.primitiveID(c)];
        if (ic == 255) {
            return null;
        }
        return primitiveTypes[ic];
    }

    static int getUnaryPromoted(int cid) {
        return unary_promotions[cid];
    }

    public static boolean canGenerateUnary(int op, Class type) {
        if (!type.isPrimitive()) {
            return false;
        }
        return una[0][op][ExpressionImage.primitiveID(type)] != 255;
    }

    public void asm_unary(int o) {
        this.ensure_value();
        Class a = (Class)this.typesStk.peek();
        if (!a.isPrimitive()) {
            Debug.println("Unary OPs are supported on primitive types only");
            return;
        }
        int ia = ExpressionImage.primitiveID(a);
        if (una[0][o][ia] == 255) {
            Debug.println("The unary operation requested (" + o + ") is not supported" + " for type in stack (" + ia + ").");
            return;
        }
        int i = 0;
        while (i < una.length) {
            int opc = una[i][o][ia];
            if (opc > 0) {
                this.codeOP(opc);
            }
            ++i;
        }
        int excess_stack = una_excess_stack[o][ia];
        this.currSSW += excess_stack;
        this.ensureStack();
        this.currSSW -= excess_stack;
        this.typesStk.pop();
        this.typesStk.push(primitiveTypes[unary_promotions[ia]]);
    }

    public static boolean canGenerateBinary(int op, Class t1, Class t2) {
        if (op == 0 && (t1 == string_class || t1 == tsb_class)) {
            return true;
        }
        if (!t1.isPrimitive() || !t2.isPrimitive()) {
            return false;
        }
        int it1 = ExpressionImage.primitiveID(t1);
        int it2 = ExpressionImage.primitiveID(t2);
        if (is_promotion_binary[op]) {
            int promoted_type = binary_promotions[it1][it2];
            if (promoted_type == 255) {
                return false;
            }
            return ops[0][op][promoted_type] != 255;
        }
        return it1 >= 1 && it1 <= 5 && it2 >= 1 && it2 <= 5;
    }

    private void normalize_tsb() {
        Class top = (Class)this.typesStk.peek();
        if (top != tsb_class) {
            return;
        }
        this.codeOP(182);
        this.codeINDEX(this.getMethodIndex(sb_toString));
        this.typesStk.pop();
        this.typesStk.push(string_class);
    }

    public void asm_binary(int o) {
        this.ensure_value();
        Class a2 = (Class)this.typesStk.peek();
        Object tmp = this.typesStk.pop();
        Class a1 = (Class)this.typesStk.peek();
        this.typesStk.push(tmp);
        if (o == 0 && a1 == tsb_class) {
            this.codeOP(182);
            if (a2.isPrimitive()) {
                this.codeINDEX(this.getMethodIndex(sb_append_primitive[ExpressionImage.primitiveID(a2)]));
            } else if (a2 == string_class) {
                this.codeINDEX(this.getMethodIndex(sb_append_String));
            } else {
                this.codeINDEX(this.getMethodIndex(sb_append_Object));
            }
            this.typesStk.pop();
            this.currSSW -= ExpressionImage.stackSpace(a2);
            return;
        }
        if (!a1.isPrimitive() || !a2.isPrimitive()) {
            Debug.println("Binary OPs are supported on primitive types only");
            return;
        }
        int ia1 = ExpressionImage.primitiveID(a1);
        int ia2 = ExpressionImage.primitiveID(a2);
        int restype = ia1;
        if (is_promotion_binary[o] && ia1 != ia2) {
            Debug.println("Types are not the same (" + ia1 + "!=" + ia2 + "), for operations with binary promotions " + "conversion should be done prior to OP.");
            return;
        }
        if (!is_promotion_binary[o]) {
            restype = unary_promotions[ia1];
            this.asm_convert(Integer.TYPE);
            a2 = (Class)this.typesStk.peek();
            ia2 = ExpressionImage.primitiveID(a2);
        }
        if (ops[0][o][restype] == 255) {
            Debug.println("The binary operation requested (" + o + ") is not " + "supported for types in stack (" + ia1 + ") .");
            return;
        }
        this.typesStk.pop();
        this.currSSW -= stkoccup[ia2];
        this.typesStk.pop();
        this.currSSW -= stkoccup[ia1];
        Debug.assert(this.jump_progress == 0, "Attempt to generate binary operation without finishing the jump");
        int i = 0;
        while (i < ops.length) {
            int opc = ops[i][o][restype];
            if (opc > 0) {
                this.codeOP(opc);
            }
            ++i;
        }
        this.jump_progress = openjumps[o][restype];
        if (this.jump_progress == 0) {
            this.typesStk.push(primitiveTypes[restype]);
            this.currSSW += stkoccup[restype];
        }
    }

    public void asm_func_start(Method f, int id) {
        Class<?>[] params = f.getParameterTypes();
        this.functionParams.push(params);
        boolean isStatic = Modifier.isStatic(f.getModifiers());
        int[] nArray = new int[5];
        nArray[0] = this.getMethodIndex(f);
        nArray[1] = isStatic ? 1 : 0;
        nArray[2] = params.length;
        nArray[4] = this.currSSW;
        int[] descr = nArray;
        this.functionINTS.push(descr);
        this.functionRet.push(f.getReturnType());
        if (!isStatic) {
            this.checkAlter();
            this.currSSW += 2;
            this.ensureStack();
            this.codeOP(43);
            if (id < 255) {
                this.codeOP(16);
                this.codeOP(id);
            } else {
                int idi = this.getIntIndex(new Integer(id));
                this.codeOP(19);
                this.codeINDEX(idi);
            }
            this.codeOP(50);
            int cls_CP = this.getClassIndex(f.getDeclaringClass());
            this.codeOP(192);
            this.codeINDEX(cls_CP);
            descr[4] = --this.currSSW;
        }
        this.asm_logical_block();
    }

    public void asm_func_param() {
        Debug.assert(!this.functionParams.empty(), "No function call being generated.");
        this.ensure_value();
        this.asm_logical_unblock();
        this.normalize_tsb();
        Class[] params = (Class[])this.functionParams.peek();
        int[] descr = (int[])this.functionINTS.peek();
        int currpar = descr[3];
        Debug.assert(currpar < descr[2], "Too many parameters for function");
        boolean converted = this.asm_convert(params[currpar]);
        if (!converted) {
            Debug.println("Can't convert to the required formal parameter type.");
            return;
        }
        Debug.assert(this.currSSW == descr[4] + ExpressionImage.stackSpace(params[currpar]), "Stack mismatch. Something was left in the stack in between of function formal parameters.");
        descr[4] = this.currSSW;
        descr[3] = descr[3] + 1;
        this.asm_logical_block();
    }

    public void asm_func_call() {
        this.asm_logical_unblock();
        Debug.assert(!this.functionParams.empty(), "No function call being generated.");
        Class[] params = (Class[])this.functionParams.pop();
        int[] descr = (int[])this.functionINTS.pop();
        Class retType = (Class)this.functionRet.pop();
        int currpar = descr[3];
        if (currpar != descr[2]) {
            Debug.println("Wrong number of parameters supplied to a function.");
            return;
        }
        boolean isStatic = descr[1] == 1;
        int totstk = isStatic ? 0 : 1;
        this.checkAlter();
        if (isStatic) {
            this.codeOP(184);
        } else {
            this.codeOP(182);
        }
        this.codeINDEX(descr[0]);
        int i = 0;
        while (i < params.length) {
            totstk += ExpressionImage.stackSpace(params[i]);
            this.typesStk.pop();
            ++i;
        }
        this.currSSW -= totstk;
        this.typesStk.push(retType);
        this.currSSW += ExpressionImage.stackSpace(retType);
        this.ensureStack();
    }

    public void asm_branch_start_true() {
        this.ensure_jump();
        if (!this.invert_next_jump) {
            this.jump_progress = ExpressionImage.invert_jump_bytecode(this.jump_progress);
        }
        this.invert_next_jump = false;
        this.codeOP(this.jump_progress);
        this.jump_progress = 0;
        this.mkLabel(this.jumps0);
        this.landLabels(this.jumps1, this.blocks1);
        this.blockLabels(this.jumps0, this.blocks0);
        this.branchStack.push(this.typesStk.size());
    }

    public void asm_branch_start_false() {
        this.ensure_value();
        this.unblockLabels(this.jumps0, this.blocks0);
        int beforeStk = this.branchStack.pop();
        this.branchStack.push(this.currSSW);
        while (beforeStk < this.typesStk.size()) {
            this.currSSW -= ExpressionImage.stackSpace((Class)this.typesStk.pop());
        }
        this.codeOP(167);
        this.mkLabel(this.jumps);
        this.landLabels(this.jumps0, this.blocks0);
    }

    public void asm_branch_end() {
        this.ensure_value();
        Debug.assert(this.branchStack.pop() == this.currSSW, "Stack mismatch when compiling conditional");
        this.landLabel(this.jumps);
    }

    private final void mkLabel(IntegerStack jumps) {
        int currpos = this.methodText.size();
        jumps.push(currpos);
        try {
            this.methodTextData.writeShort(0);
        }
        catch (IOException iOException) {}
    }

    private final void landLabel(IntegerStack jumps) {
        int currpos = this.methodText.size();
        int addrpos = jumps.pop();
        this.methodText.patchAddress(addrpos, currpos - addrpos + 1);
    }

    private final void landLabels(IntegerStack jumps, IntegerStack blocks) {
        int blocked_at = 0;
        if (blocks.size() > 0) {
            blocked_at = blocks.peek();
        }
        while (jumps.size() > blocked_at) {
            this.landLabel(jumps);
        }
    }

    private final void blockLabels(IntegerStack jumps, IntegerStack blocks) {
        blocks.push(jumps.size());
    }

    private final void unblockLabels(IntegerStack jumps, IntegerStack blocks) {
        blocks.pop_throw();
    }

    public void asm_binary_param(int opc) {
        this.ensure_value();
        if (opc == 0 && this.typesStk.peek() == string_class) {
            this.codeOP(187);
            this.codeINDEX(this.getClassIndex(sb_class));
            this.codeOP(90);
            this.codeOP(90);
            this.codeOP(87);
            this.codeOP(183);
            this.codeINDEX(this.getMethodIndex(sb_constructor));
            this.typesStk.pop();
            this.typesStk.push(tsb_class);
            this.currSSW += 3;
            this.ensureStack();
            this.currSSW -= 3;
        }
    }

    public void asm_logical_binary_param(int opc) {
        switch (opc) {
            case 0: {
                this.asm_logical_binary_param_and();
                break;
            }
            case 1: {
                this.asm_logical_binary_param_or();
                break;
            }
            default: {
                Debug.println("Wrong operation code (" + opc + ") for logical operation.");
            }
        }
    }

    public void asm_logical_binary(int opc) {
        switch (opc) {
            case 0: {
                this.asm_logical_binary_and();
                break;
            }
            case 1: {
                this.asm_logical_binary_or();
                break;
            }
            default: {
                Debug.println("Wrong operation code (" + opc + ") for logical operation.");
            }
        }
    }

    private final void asm_logical_binary_param_and() {
        this.logical_param(true, this.jumps0, this.jumps1, this.blocks0, this.blocks1);
    }

    private final void asm_logical_binary_param_or() {
        this.logical_param(false, this.jumps1, this.jumps0, this.blocks1, this.blocks0);
    }

    private void logical_param(boolean and, IntegerStack jumps0, IntegerStack jumps1, IntegerStack blocks0, IntegerStack blocks1) {
        this.ensure_jump();
        if (this.invert_next_jump ^ and) {
            this.jump_progress = ExpressionImage.invert_jump_bytecode(this.jump_progress);
        }
        this.invert_next_jump = false;
        this.codeOP(this.jump_progress);
        this.jump_progress = 0;
        this.mkLabel(jumps0);
        this.landLabels(jumps1, blocks1);
        this.blockLabels(jumps0, blocks0);
    }

    private final void asm_logical_binary_and() {
        this.unblockLabels(this.jumps0, this.blocks0);
    }

    private final void asm_logical_binary_or() {
        this.unblockLabels(this.jumps1, this.blocks1);
    }

    public void asm_logical_block() {
        this.blockLabels(this.jumps0, this.blocks0);
        this.blockLabels(this.jumps1, this.blocks1);
    }

    private void asm_logical_unblock() {
        this.unblockLabels(this.jumps0, this.blocks0);
        this.unblockLabels(this.jumps1, this.blocks1);
    }

    public void asm_logical_unblock_not() {
        this.ensure_jump();
        IntegerStack.swap(this.jumps1, this.blocks1.pop(), this.jumps0, this.blocks0.pop());
        this.invert_next_jump = !this.invert_next_jump;
    }

    private final void ensure_jump() {
        if (this.jump_progress != 0) {
            return;
        }
        Class a1 = (Class)this.typesStk.pop();
        Debug.assert(a1 == Boolean.TYPE, "Only booleans can generate jumps in ensurejump()");
        this.currSSW -= stkoccup[0];
        this.jump_progress = 157;
    }

    private final void ensure_value() {
        if (this.jump_progress == 0 && this.noPendingJumps()) {
            return;
        }
        this.asm_branch_start_true();
        this.asm_load_primitive(Boolean.TRUE);
        this.asm_branch_start_false();
        this.asm_load_primitive(Boolean.FALSE);
        this.asm_branch_end();
    }

    private final boolean noPendingJumps() {
        int blocked0 = 0;
        if (this.blocks0.size() > 0) {
            blocked0 = this.blocks0.peek();
        }
        int blocked1 = 0;
        if (this.blocks1.size() > 0) {
            blocked1 = this.blocks1.peek();
        }
        return this.jumps0.size() == blocked0 && this.jumps1.size() == blocked1;
    }

    public void asm_return() {
        this.checkAlter();
        this.ensure_value();
        this.normalize_tsb();
        Debug.assert(this.jumps0.size() == 0 && this.blocks0.size() == 0 && this.jumps1.size() == 0 && this.blocks1.size() == 0 && this.jumps.size() == 0, "Some labels were not landed and/or blocks removed.");
        Class typeout = null;
        boolean returnvoid = false;
        try {
            typeout = (Class)this.typesStk.peek();
        }
        catch (EmptyStackException emptyStackException) {
            this.asm_load_object(null);
            returnvoid = true;
        }
        int prid = primitiveTypes.length;
        int instruction = -80;
        if (!returnvoid) {
            ++prid;
            if (typeout != null && typeout.isPrimitive()) {
                prid = ExpressionImage.primitiveID(typeout);
                instruction = returns[prid];
            }
        }
        StringBuffer mname = new StringBuffer("evaluate");
        StringBuffer signature = new StringBuffer("([Ljava/lang/Object;)");
        if (prid < primitiveTypes.length) {
            mname.append('_');
            mname.append(primitiveTypeNames[prid]);
            signature.append(primitiveCodes[prid]);
        } else {
            signature.append("Ljava/lang/Object;");
        }
        this.nameIdx = (short)this.getUTFIndex(mname.toString());
        this.signIdx = (short)this.getUTFIndex(signature.toString());
        this.thetype = (byte)prid;
        this.typesStk.pop();
        Debug.assert(this.typesStk.size() == 0, "Stack is not empty when returning.");
        Debug.assert(prid > 7 || this.currSSW == stkoccup[prid], "Words left in stack = " + this.currSSW + "should be 1.");
        this.codeOP(instruction);
        this.classFinished = true;
    }

    public void asm_throw_return() {
        this.checkAlter();
        Class typeout = null;
        try {
            typeout = (Class)this.typesStk.pop();
        }
        catch (EmptyStackException e) {
            Debug.reportThrowable(e);
        }
        try {
            Class<?> thr = Class.forName("java.lang.Throwable");
            Debug.assert(thr.isAssignableFrom(typeout), "Attempt to throw non throwable.");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        this.codeOP(191);
        this.classFinished = true;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        ExpressionImage.test(t);
        t.summarize();
    }

    static void dumpImage(ExpressionImage ei) {
        try {
            FileOutputStream fos = new FileOutputStream("dump.class");
            fos.write(ei.getImage());
            fos.close();
        }
        catch (Exception exception) {
            Debug.println("Can't dump generated class file.");
        }
    }

    private static boolean transmitPrimitive(Object obj, Object tobe) throws Throwable {
        ExpressionImage ei = null;
        Object res = null;
        try {
            ei = new ExpressionImage();
            ei.asm_load_primitive(obj);
            ei.asm_return();
            CompiledExpression cex = ei.getExpression();
            res = cex.evaluate(null);
        }
        catch (Throwable e) {
            ExpressionImage.dumpImage(ei);
            throw e;
        }
        boolean success = res.equals(tobe);
        if (!success) {
            Debug.println("Transmit of \"" + obj.getClass().getName() + "\" failed.");
            Debug.println("Expected \"" + tobe.toString() + "\",  encountered \"" + res.toString() + "\".");
            ExpressionImage.dumpImage(ei);
        }
        return success;
    }

    public static void test(Tester t) {
        ExpressionImage e;
        ExpressionImage e2;
        t.startTest("toHistoricalForm(\"java.lang.String\")");
        t.compare(ExpressionImage.toHistoricalForm("java.lang.String"), "java/lang/String");
        t.startTest("getSignature((\"a string\").getClass())");
        t.compare(ExpressionImage.getSignature("a string".getClass()), "Ljava/lang/String;");
        t.startTest("getSignature((new int[10]).getClass())");
        t.compare(ExpressionImage.getSignature(new int[10].getClass()), "[I");
        t.startTest("getSignature((new Object[10]).getClass())");
        t.compare(ExpressionImage.getSignature(new Object[10].getClass()), "[Ljava/lang/Object;");
        ExpressionImage ei = new ExpressionImage();
        t.startTest("Add UTF twice");
        String s1 = "some string";
        int si = ei.getUTFIndex(s1);
        int sii = ei.getUTFIndex(s1);
        t.compare(sii, si);
        t.startTest("Checking the index of added UTF");
        t.compare(si, 20);
        t.startTest("Add Long twice");
        int li = ei.getLongIndex(new Long(15L));
        int lii = ei.getLongIndex(new Long(15L));
        t.compare(lii, li);
        t.startTest("Add Integer twice");
        int ii = ei.getIntIndex(new Integer(15));
        int iii = ei.getIntIndex(new Integer(15));
        t.compare(iii, ii);
        t.startTest("Add Float twice");
        int ff = ei.getFloatIndex(new Float(15.0f));
        int fff = ei.getFloatIndex(new Float(15.0f));
        t.compare(fff, ff);
        t.startTest("Add Double twice");
        int di = ei.getDoubleIndex(new Double(15.0));
        int dii = ei.getDoubleIndex(new Double(15.0));
        t.compare(dii, di);
        t.startTest("Add a new String twice");
        String s2 = "some other string";
        int s2i = ei.getStringIndex(s2);
        int s2ii = ei.getStringIndex(s2);
        t.compare(s2ii, s2i);
        t.startTest("Add a string with existing UTF twice");
        int s3i = ei.getStringIndex(s1);
        int s3ii = ei.getStringIndex(s1);
        t.compare(s3ii, s3i);
        t.startTest("Add a class twice.");
        int ci = ei.getClassIndex(ei.getClass());
        int cii = ei.getClassIndex(ei.getClass());
        t.compare(cii, ci);
        t.startTest("Add a method twice.");
        Class[] params = new Class[1];
        try {
            params[0] = Class.forName("gnu.jel.debug.Tester");
            Method a_method = ei.getClass().getMethod("test", params);
            int mi = ei.getMethodIndex(a_method);
            int mii = ei.getMethodIndex(a_method);
            t.compare(mii, mi);
        }
        catch (Exception e3) {
            t.testFail();
            Debug.reportThrowable(e3);
        }
        t.startTest("Counting added entries ");
        t.compare(ei.poolEntries, 36);
        t.startTest("Loading and executing via getExpression");
        try {
            boolean ok = true;
            ei.asm_load_object(null);
            ei.asm_return();
            CompiledExpression cell = ei.getExpression();
            boolean bl = ok = ok && cell.evaluate(null) == null;
            if (!ok) {
                ExpressionImage.dumpImage(ei);
            }
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e4) {
            Debug.reportThrowable(e4);
            t.testFail();
        }
        t.startTest("Check transmission of Object constants");
        try {
            boolean ok;
            e2 = new ExpressionImage();
            e2.asm_load_object(e2);
            e2.asm_return();
            CompiledExpression cell = e2.getExpression();
            boolean bl = ok = cell.evaluate(null) == e2;
            if (!ok) {
                ExpressionImage.dumpImage(e2);
            }
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e5) {
            Debug.reportThrowable(e5);
            t.testFail();
        }
        t.startTest("Check load/return of primitives (Z,B,C,S,I,J,F,D)");
        try {
            if (!ExpressionImage.transmitPrimitive(new Long(0L), new Long(0L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Long(1L), new Long(1L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Long(-1L), new Long(-1L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Long(2L), new Long(2L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Long(3L), new Long(3L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Long(5L), new Long(5L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Long(6L), new Long(6L))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Double(0.0), new Double(0.0))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Double(1.0), new Double(1.0))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Double(2.0), new Double(2.0))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Double(3.0), new Double(3.0))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(0), new Integer(0))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(1), new Integer(1))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(-1), new Integer(-1))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(2), new Integer(2))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(3), new Integer(3))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(4), new Integer(4))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(5), new Integer(5))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Integer(6), new Integer(6))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Byte(1), new Byte(1))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Character(' '), new Character(' '))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Short(-3), new Short(-3))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(Boolean.TRUE, Boolean.TRUE)) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(Boolean.FALSE, Boolean.FALSE)) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Float(1.0f), new Float(1.0f))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Float(0.0f), new Float(0.0f))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Float(2.0f), new Float(2.0f))) {
                t.testFail();
            } else if (!ExpressionImage.transmitPrimitive(new Float(3.0f), new Float(3.0f))) {
                t.testFail();
            } else {
                t.testOK();
            }
        }
        catch (Throwable e6) {
            Debug.reportThrowable(e6);
            t.testFail();
        }
        t.startTest("Evaluating 2L*2L=4L");
        try {
            e2 = new ExpressionImage();
            e2.asm_load_primitive(new Long(2L));
            e2.asm_binary_param(2);
            e2.asm_load_primitive(new Long(2L));
            e2.asm_binary(2);
            e2.asm_return();
            CompiledExpression cell = e2.getExpression();
            if ((Long)cell.evaluate(null) == 4L) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e7) {
            Debug.reportThrowable(e7);
            t.testFail();
        }
        t.startTest("Evaluating 2D*2D=4D");
        try {
            e2 = new ExpressionImage();
            e2.asm_load_primitive(new Double(2.0));
            e2.asm_binary_param(2);
            e2.asm_load_primitive(new Double(2.0));
            e2.asm_binary(2);
            e2.asm_return();
            CompiledExpression cell = e2.getExpression();
            if ((Double)cell.evaluate(null) == 4.0) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e8) {
            Debug.reportThrowable(e8);
            t.testFail();
        }
        CompiledExpression cell_store = null;
        t.startTest("Evaluating Math.sin(2L+2L-4L+Math.round(1.2F))=Math.sin(1.0)");
        try {
            CompiledExpression cell;
            ExpressionImage e9 = new ExpressionImage();
            Class<?> math = Class.forName("java.lang.Math");
            Class[] prs = new Class[]{Double.TYPE};
            Method sinus = math.getDeclaredMethod("sin", prs);
            prs[0] = Float.TYPE;
            Method round = math.getDeclaredMethod("round", prs);
            e9.asm_func_start(sinus, 0);
            e9.asm_load_primitive(new Long(2L));
            e9.asm_binary_param(0);
            e9.asm_load_primitive(new Long(2L));
            e9.asm_binary(0);
            e9.asm_binary_param(1);
            e9.asm_load_primitive(new Long(4L));
            e9.asm_binary(1);
            e9.asm_binary_param(0);
            e9.asm_func_start(round, 0);
            e9.asm_load_primitive(new Double(1.2));
            e9.asm_func_param();
            e9.asm_func_call();
            e9.asm_convert(Long.TYPE);
            e9.asm_binary(0);
            e9.asm_func_param();
            e9.asm_func_call();
            e9.asm_return();
            cell_store = cell = e9.getExpression();
            double result = (Double)cell.evaluate(null);
            if (Math.abs(result - Math.sin(1.0)) < 0.001) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e10) {
            Debug.reportThrowable(e10);
            t.testFail();
        }
        t.startTest("Evaluating last expression 100000 times");
        try {
            int i = 0;
            while (i < 100000) {
                cell_store.evaluate(null);
                ++i;
            }
            cell_store = null;
            t.testOK();
        }
        catch (Throwable e11) {
            Debug.reportThrowable(e11);
            t.testFail();
        }
        t.startTest("Evaluating (true && false)|| !(false && true)||false=true");
        try {
            e = new ExpressionImage();
            e.asm_load_primitive(Boolean.TRUE);
            e.asm_logical_binary_param_and();
            e.asm_load_primitive(Boolean.FALSE);
            e.asm_logical_binary_and();
            e.asm_logical_binary_param_or();
            e.asm_logical_block();
            e.asm_load_primitive(Boolean.FALSE);
            e.asm_logical_binary_param_and();
            e.asm_load_primitive(Boolean.TRUE);
            e.asm_logical_binary_and();
            e.asm_logical_unblock_not();
            e.asm_logical_binary_or();
            e.asm_logical_binary_param_or();
            e.asm_load_primitive(Boolean.FALSE);
            e.asm_logical_binary_or();
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean result = (Boolean)cell.evaluate(null);
            if (result) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e12) {
            Debug.reportThrowable(e12);
            t.testFail();
        }
        ExpressionImage.testComparizons(new Byte(1), new Byte(2), "bytes", t);
        ExpressionImage.testComparizons(new Byte(2), new Byte(1), "bytes", t);
        ExpressionImage.testComparizons(new Byte(1), new Byte(1), "bytes", t);
        ExpressionImage.testComparizons(new Short(1), new Short(2), "shorts", t);
        ExpressionImage.testComparizons(new Short(2), new Short(1), "shorts", t);
        ExpressionImage.testComparizons(new Short(1), new Short(1), "shorts", t);
        ExpressionImage.testComparizons(new Character('a'), new Character('b'), "characters", t);
        ExpressionImage.testComparizons(new Character('b'), new Character('a'), "characters", t);
        ExpressionImage.testComparizons(new Character('a'), new Character('a'), "characters", t);
        ExpressionImage.testComparizons(new Integer(1), new Integer(2), "integers", t);
        ExpressionImage.testComparizons(new Integer(2), new Integer(1), "integers", t);
        ExpressionImage.testComparizons(new Integer(1), new Integer(1), "integers", t);
        ExpressionImage.testComparizons(new Long(1L), new Long(2L), "long integers", t);
        ExpressionImage.testComparizons(new Long(2L), new Long(1L), "long integers", t);
        ExpressionImage.testComparizons(new Long(1L), new Long(1L), "long integers", t);
        ExpressionImage.testComparizons(new Float(1.0f), new Float(2.0f), "floats", t);
        ExpressionImage.testComparizons(new Float(2.0f), new Float(1.0f), "floats", t);
        ExpressionImage.testComparizons(new Float(1.0f), new Float(1.0f), "floats", t);
        ExpressionImage.testComparizons(new Double(1.0), new Double(2.0), "doubles", t);
        ExpressionImage.testComparizons(new Double(2.0), new Double(1.0), "doubles", t);
        ExpressionImage.testComparizons(new Double(1.0), new Double(1.0), "doubles", t);
        t.startTest("Evaluating ((1+2>2)==true)=true ");
        try {
            e = new ExpressionImage();
            e.asm_load_primitive(new Integer(1));
            e.asm_binary_param(0);
            e.asm_load_primitive(new Integer(2));
            e.asm_binary(0);
            e.asm_binary_param(12);
            e.asm_load_primitive(new Integer(2));
            e.asm_binary(12);
            e.asm_binary_param(8);
            e.asm_load_primitive(Boolean.TRUE);
            e.asm_binary(8);
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean result = (Boolean)cell.evaluate(null);
            if (result) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e13) {
            Debug.reportThrowable(e13);
            t.testFail();
        }
        t.startTest("Evaluating (true?(true?true:false):false)=true ");
        try {
            e = new ExpressionImage();
            e.asm_load_primitive(Boolean.TRUE);
            e.asm_branch_start_true();
            e.asm_load_primitive(Boolean.TRUE);
            e.asm_branch_start_true();
            e.asm_load_primitive(Boolean.TRUE);
            e.asm_branch_start_false();
            e.asm_load_primitive(Boolean.FALSE);
            e.asm_branch_end();
            e.asm_branch_start_false();
            e.asm_load_primitive(Boolean.FALSE);
            e.asm_branch_end();
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean result = (Boolean)cell.evaluate(null);
            if (result) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e14) {
            Debug.reportThrowable(e14);
            t.testFail();
        }
        t.startTest("Evaluating (1==1)&&(max(~(1<=2?1:0),~(2>=3:1:0))==-1) =true");
        try {
            e = new ExpressionImage();
            Class<?> math = Class.forName("java.lang.Math");
            Class[] prs = new Class[]{Integer.TYPE, Integer.TYPE};
            Method maximum = math.getDeclaredMethod("max", prs);
            e.asm_load_primitive(new Integer(1));
            e.asm_binary_param(8);
            e.asm_load_primitive(new Integer(1));
            e.asm_binary(8);
            e.asm_logical_binary_param_and();
            e.asm_func_start(maximum, 0);
            e.asm_load_primitive(new Integer(1));
            e.asm_binary_param(13);
            e.asm_load_primitive(new Integer(2));
            e.asm_binary(13);
            e.asm_branch_start_true();
            e.asm_load_primitive(new Integer(1));
            e.asm_branch_start_false();
            e.asm_load_primitive(new Integer(0));
            e.asm_branch_end();
            e.asm_unary(1);
            e.asm_func_param();
            e.asm_load_primitive(new Integer(2));
            e.asm_binary_param(11);
            e.asm_load_primitive(new Integer(3));
            e.asm_binary(11);
            e.asm_branch_start_true();
            e.asm_load_primitive(new Integer(1));
            e.asm_branch_start_false();
            e.asm_load_primitive(new Integer(0));
            e.asm_branch_end();
            e.asm_unary(1);
            e.asm_func_param();
            e.asm_func_call();
            e.asm_binary_param(8);
            e.asm_load_primitive(new Integer(-1));
            e.asm_binary(8);
            e.asm_logical_binary_and();
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean result = (Boolean)cell.evaluate(null);
            if (result) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e15) {
            Debug.reportThrowable(e15);
            t.testFail();
        }
        t.startTest("Evaluating \"aa\"+\"bb\"+\"cc\" = \"aabbcc\"");
        try {
            e = new ExpressionImage();
            e.asm_load_object("aa");
            e.asm_binary_param(0);
            e.asm_load_object("bb");
            e.asm_binary(0);
            e.asm_binary_param(0);
            e.asm_load_object("cc");
            e.asm_binary(0);
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean result = cell.evaluate(null).equals("aabbcc");
            if (result) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e16) {
            Debug.reportThrowable(e16);
            t.testFail();
        }
        t.startTest("Evaluating \"str\"+true+2B+'!'+3I+4L+5.0F = \"strtrue2!345.0\"");
        try {
            e = new ExpressionImage();
            e.asm_load_object("str");
            e.asm_binary_param(0);
            e.asm_load_primitive(Boolean.TRUE);
            e.asm_binary(0);
            e.asm_binary_param(0);
            e.asm_load_primitive(new Byte(2));
            e.asm_binary(0);
            e.asm_binary_param(0);
            e.asm_load_primitive(new Character('!'));
            e.asm_binary(0);
            e.asm_binary_param(0);
            e.asm_load_primitive(new Integer(3));
            e.asm_binary(0);
            e.asm_binary_param(0);
            e.asm_load_primitive(new Long(4L));
            e.asm_binary(0);
            e.asm_binary_param(0);
            e.asm_load_primitive(new Float(5.0f));
            e.asm_binary(0);
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean result = cell.evaluate(null).equals("strtrue2!345.0");
            if (result) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e17) {
            Debug.reportThrowable(e17);
            t.testFail();
        }
        t.startTest("Evaluating \"str\"+6.0D+new Double(7.0D) = \"str6.07.0\"");
        try {
            e = new ExpressionImage();
            e.asm_load_object("str");
            e.asm_binary_param(0);
            e.asm_load_primitive(new Double(6.0));
            e.asm_binary(0);
            e.asm_binary_param(0);
            e.asm_load_object(new Double(7.0));
            e.asm_binary(0);
            e.asm_return();
            CompiledExpression cell = e.getExpression();
            boolean result = cell.evaluate(null).equals("str6.07.0");
            if (result) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e18) {
            Debug.reportThrowable(e18);
            t.testFail();
        }
    }

    private static void testComparizons(Object v1, Object v2, String type, Tester t) {
        int op = 8;
        String[] sgn = new String[]{"==", "!=", "<", ">=", ">", "<="};
        while (op <= 12) {
            t.startTest("Evaluating " + type + " " + v1 + sgn[op - 8] + v2 + " || " + v1 + sgn[op - 8 + 1] + v2 + " = true");
            try {
                ExpressionImage e = new ExpressionImage();
                e.asm_load_primitive(v1);
                e.asm_binary_param(op);
                e.asm_load_primitive(v2);
                e.asm_binary(op);
                e.asm_logical_binary_param_or();
                e.asm_load_primitive(v1);
                e.asm_binary_param(op + 1);
                e.asm_load_primitive(v2);
                e.asm_binary(op + 1);
                e.asm_logical_binary_or();
                e.asm_return();
                CompiledExpression cell = e.getExpression();
                boolean result = (Boolean)cell.evaluate(null);
                if (result) {
                    t.testOK();
                } else {
                    t.testFail();
                }
            }
            catch (Throwable e) {
                Debug.reportThrowable(e);
                t.testFail();
            }
            op += 2;
        }
    }

    static {
        byte[] byArray = new byte[8];
        byArray[0] = -54;
        byArray[1] = -2;
        byArray[2] = -70;
        byArray[3] = -66;
        byArray[5] = 3;
        byArray[7] = 45;
        prologue = byArray;
        byte[] byArray2 = new byte[182];
        byArray2[0] = 7;
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[5] = 26;
        byArray2[6] = 103;
        byArray2[7] = 110;
        byArray2[8] = 117;
        byArray2[9] = 47;
        byArray2[10] = 106;
        byArray2[11] = 101;
        byArray2[12] = 108;
        byArray2[13] = 47;
        byArray2[14] = 67;
        byArray2[15] = 111;
        byArray2[16] = 109;
        byArray2[17] = 112;
        byArray2[18] = 105;
        byArray2[19] = 108;
        byArray2[20] = 101;
        byArray2[21] = 100;
        byArray2[22] = 69;
        byArray2[23] = 120;
        byArray2[24] = 112;
        byArray2[25] = 114;
        byArray2[26] = 101;
        byArray2[27] = 115;
        byArray2[28] = 115;
        byArray2[29] = 105;
        byArray2[30] = 111;
        byArray2[31] = 110;
        byArray2[32] = 7;
        byArray2[34] = 3;
        byArray2[35] = 1;
        byArray2[37] = 1;
        byArray2[38] = 101;
        byArray2[39] = 1;
        byArray2[41] = 19;
        byArray2[42] = 91;
        byArray2[43] = 76;
        byArray2[44] = 106;
        byArray2[45] = 97;
        byArray2[46] = 118;
        byArray2[47] = 97;
        byArray2[48] = 47;
        byArray2[49] = 108;
        byArray2[50] = 97;
        byArray2[51] = 110;
        byArray2[52] = 103;
        byArray2[53] = 47;
        byArray2[54] = 79;
        byArray2[55] = 98;
        byArray2[56] = 106;
        byArray2[57] = 101;
        byArray2[58] = 99;
        byArray2[59] = 116;
        byArray2[60] = 59;
        byArray2[61] = 1;
        byArray2[63] = 6;
        byArray2[64] = 60;
        byArray2[65] = 105;
        byArray2[66] = 110;
        byArray2[67] = 105;
        byArray2[68] = 116;
        byArray2[69] = 62;
        byArray2[70] = 1;
        byArray2[72] = 22;
        byArray2[73] = 40;
        byArray2[74] = 91;
        byArray2[75] = 76;
        byArray2[76] = 106;
        byArray2[77] = 97;
        byArray2[78] = 118;
        byArray2[79] = 97;
        byArray2[80] = 47;
        byArray2[81] = 108;
        byArray2[82] = 97;
        byArray2[83] = 110;
        byArray2[84] = 103;
        byArray2[85] = 47;
        byArray2[86] = 79;
        byArray2[87] = 98;
        byArray2[88] = 106;
        byArray2[89] = 101;
        byArray2[90] = 99;
        byArray2[91] = 116;
        byArray2[92] = 59;
        byArray2[93] = 41;
        byArray2[94] = 86;
        byArray2[95] = 1;
        byArray2[97] = 10;
        byArray2[98] = 69;
        byArray2[99] = 120;
        byArray2[100] = 99;
        byArray2[101] = 101;
        byArray2[102] = 112;
        byArray2[103] = 116;
        byArray2[104] = 105;
        byArray2[105] = 111;
        byArray2[106] = 110;
        byArray2[107] = 115;
        byArray2[108] = 1;
        byArray2[110] = 4;
        byArray2[111] = 67;
        byArray2[112] = 111;
        byArray2[113] = 100;
        byArray2[114] = 101;
        byArray2[115] = 1;
        byArray2[117] = 3;
        byArray2[118] = 40;
        byArray2[119] = 41;
        byArray2[120] = 86;
        byArray2[121] = 12;
        byArray2[123] = 7;
        byArray2[125] = 11;
        byArray2[126] = 10;
        byArray2[128] = 4;
        byArray2[130] = 12;
        byArray2[131] = 12;
        byArray2[133] = 5;
        byArray2[135] = 6;
        byArray2[136] = 9;
        byArray2[138] = 2;
        byArray2[140] = 14;
        byArray2[141] = 1;
        byArray2[143] = 7;
        byArray2[144] = 103;
        byArray2[145] = 101;
        byArray2[146] = 116;
        byArray2[147] = 84;
        byArray2[148] = 121;
        byArray2[149] = 112;
        byArray2[150] = 101;
        byArray2[151] = 1;
        byArray2[153] = 3;
        byArray2[154] = 40;
        byArray2[155] = 41;
        byArray2[156] = 73;
        byArray2[157] = 1;
        byArray2[159] = 19;
        byArray2[160] = 106;
        byArray2[161] = 97;
        byArray2[162] = 118;
        byArray2[163] = 97;
        byArray2[164] = 47;
        byArray2[165] = 108;
        byArray2[166] = 97;
        byArray2[167] = 110;
        byArray2[168] = 103;
        byArray2[169] = 47;
        byArray2[170] = 84;
        byArray2[171] = 104;
        byArray2[172] = 114;
        byArray2[173] = 111;
        byArray2[174] = 119;
        byArray2[175] = 97;
        byArray2[176] = 98;
        byArray2[177] = 108;
        byArray2[178] = 101;
        byArray2[179] = 7;
        byArray2[181] = 18;
        cp_middle = byArray2;
        byte[] byArray3 = new byte[95];
        byArray3[1] = 33;
        byArray3[3] = 2;
        byArray3[5] = 4;
        byArray3[9] = 1;
        byArray3[11] = 2;
        byArray3[13] = 5;
        byArray3[15] = 6;
        byArray3[19] = 3;
        byArray3[21] = 1;
        byArray3[23] = 7;
        byArray3[25] = 8;
        byArray3[27] = 2;
        byArray3[29] = 9;
        byArray3[33] = 2;
        byArray3[37] = 10;
        byArray3[41] = 22;
        byArray3[43] = 2;
        byArray3[45] = 2;
        byArray3[49] = 10;
        byArray3[50] = 42;
        byArray3[51] = -73;
        byArray3[53] = 13;
        byArray3[54] = 42;
        byArray3[55] = 43;
        byArray3[56] = -75;
        byArray3[58] = 15;
        byArray3[59] = -79;
        byArray3[65] = 1;
        byArray3[67] = 16;
        byArray3[69] = 17;
        byArray3[71] = 2;
        byArray3[73] = 9;
        byArray3[77] = 2;
        byArray3[81] = 10;
        byArray3[85] = 15;
        byArray3[87] = 1;
        byArray3[89] = 1;
        byArray3[93] = 3;
        byArray3[94] = 16;
        intermezzo1 = byArray3;
        byte[] byArray4 = new byte[7];
        byArray4[0] = -84;
        byArray4[6] = 1;
        intermezzo2 = byArray4;
        byte[] byArray5 = new byte[14];
        byArray5[1] = 2;
        byArray5[3] = 9;
        byArray5[7] = 4;
        byArray5[9] = 1;
        byArray5[11] = 19;
        byArray5[13] = 10;
        intermezzo3 = byArray5;
        konetc = new byte[6];
        primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
        primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'V'};
        primitiveTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
        sb_class = null;
        tsb_class = null;
        string_class = null;
        sb_constructor = null;
        sb_append_primitive = new Method[primitiveTypes.length - 1];
        sb_append_String = null;
        sb_append_Object = null;
        sb_toString = null;
        try {
            sb_class = Class.forName("java.lang.StringBuffer");
            tsb_class = Class.forName("gnu.jel.TempStringBuffer");
            string_class = Class.forName("java.lang.String");
            Class[] meth_par = new Class[]{};
            sb_toString = sb_class.getMethod("toString", meth_par);
            meth_par = new Class[]{string_class};
            sb_constructor = sb_class.getConstructor(meth_par);
            sb_append_String = sb_class.getMethod("append", meth_par);
            meth_par[0] = Class.forName("java.lang.Object");
            sb_append_Object = sb_class.getMethod("append", meth_par);
            int i = 0;
            while (i < primitiveTypes.length - 1) {
                meth_par[0] = primitiveTypes[i == 1 ? 4 : (i == 3 ? 4 : i)];
                ExpressionImage.sb_append_primitive[i] = sb_class.getMethod("append", meth_par);
                ++i;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Debug.println("Get Yourself a real JAVA.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.println("Get Yourself a real JAVA.");
        }
        returns = new byte[]{-84, -84, -84, -84, -84, -83, -82, -81};
        cvt_wide = new byte[]{-128, 64, 96, 80, 120, 92, 94, 95};
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[8];
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 255;
        nArray[4] = 255;
        nArray[5] = 255;
        nArray[6] = 255;
        nArray[7] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 145;
        nArray2[2] = 145;
        nArray2[3] = 145;
        nArray2[4] = 145;
        nArray2[5] = 136;
        nArray2[6] = 139;
        nArray2[7] = 142;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 146;
        nArray3[1] = 146;
        nArray3[3] = 146;
        nArray3[4] = 146;
        nArray3[5] = 136;
        nArray3[6] = 139;
        nArray3[7] = 142;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 147;
        nArray4[1] = 147;
        nArray4[2] = 147;
        nArray4[4] = 147;
        nArray4[5] = 136;
        nArray4[6] = 139;
        nArray4[7] = 142;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[8];
        nArray5[5] = 136;
        nArray5[6] = 139;
        nArray5[7] = 142;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 133;
        nArray6[1] = 133;
        nArray6[2] = 133;
        nArray6[3] = 133;
        nArray6[4] = 133;
        nArray6[6] = 140;
        nArray6[7] = 143;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 134;
        nArray7[1] = 134;
        nArray7[2] = 134;
        nArray7[3] = 134;
        nArray7[4] = 134;
        nArray7[5] = 137;
        nArray7[7] = 144;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[0] = 135;
        nArray8[1] = 135;
        nArray8[2] = 135;
        nArray8[3] = 135;
        nArray8[4] = 135;
        nArray8[5] = 138;
        nArray8[6] = 141;
        nArrayArray[7] = nArray8;
        cvt1 = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        nArrayArray2[0] = new int[8];
        int[] nArray9 = new int[8];
        nArray9[5] = 145;
        nArray9[6] = 145;
        nArray9[7] = 145;
        nArrayArray2[1] = nArray9;
        int[] nArray10 = new int[8];
        nArray10[5] = 146;
        nArray10[6] = 146;
        nArray10[7] = 146;
        nArrayArray2[2] = nArray10;
        int[] nArray11 = new int[8];
        nArray11[5] = 147;
        nArray11[6] = 147;
        nArray11[7] = 147;
        nArrayArray2[3] = nArray11;
        nArrayArray2[4] = new int[8];
        nArrayArray2[5] = new int[8];
        nArrayArray2[6] = new int[8];
        nArrayArray2[7] = new int[8];
        cvt2 = nArrayArray2;
        stkoccup = new byte[]{1, 1, 1, 1, 1, 2, 1, 2};
        load_ints = new int[]{2, 3, 4, 5, 6, 7, 8};
        load_long_ints1 = new int[]{2, 9, 10, 5, 6, 7, 8};
        int[] nArray12 = new int[7];
        nArray12[0] = 133;
        nArray12[3] = 133;
        nArray12[4] = 133;
        nArray12[5] = 133;
        nArray12[6] = 133;
        load_long_ints2 = nArray12;
        int[][] nArrayArray3 = new int[8][];
        int[] nArray13 = new int[8];
        nArray13[1] = 255;
        nArray13[2] = 255;
        nArray13[3] = 255;
        nArray13[4] = 255;
        nArray13[5] = 255;
        nArray13[6] = 255;
        nArray13[7] = 255;
        nArrayArray3[0] = nArray13;
        nArrayArray3[1] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[2] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[3] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[4] = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        nArrayArray3[5] = new int[]{255, 5, 5, 5, 5, 5, 6, 7};
        nArrayArray3[6] = new int[]{255, 6, 6, 6, 6, 6, 6, 7};
        nArrayArray3[7] = new int[]{255, 7, 7, 7, 7, 7, 7, 7};
        binary_promotions = nArrayArray3;
        unary_promotions = new int[]{255, 4, 4, 4, 4, 5, 6, 7};
        int[][][] nArrayArray4 = new int[1][][];
        int[][] nArrayArray5 = new int[17][];
        nArrayArray5[0] = new int[]{255, 96, 255, 96, 96, 97, 98, 99};
        nArrayArray5[1] = new int[]{255, 100, 255, 100, 100, 101, 102, 103};
        nArrayArray5[2] = new int[]{255, 104, 255, 104, 104, 105, 106, 107};
        nArrayArray5[3] = new int[]{255, 108, 255, 108, 108, 109, 110, 111};
        nArrayArray5[4] = new int[]{255, 112, 255, 112, 112, 113, 114, 115};
        nArrayArray5[5] = new int[]{126, 126, 255, 126, 126, 127, 255, 255};
        nArrayArray5[6] = new int[]{128, 128, 255, 128, 128, 129, 255, 255};
        nArrayArray5[7] = new int[]{130, 130, 255, 130, 130, 131, 255, 255};
        int[] nArray14 = new int[8];
        nArray14[5] = 148;
        nArray14[6] = 150;
        nArray14[7] = 152;
        nArrayArray5[8] = nArray14;
        int[] nArray15 = new int[8];
        nArray15[5] = 148;
        nArray15[6] = 150;
        nArray15[7] = 152;
        nArrayArray5[9] = nArray15;
        int[] nArray16 = new int[8];
        nArray16[5] = 148;
        nArray16[6] = 150;
        nArray16[7] = 152;
        nArrayArray5[10] = nArray16;
        int[] nArray17 = new int[8];
        nArray17[5] = 148;
        nArray17[6] = 149;
        nArray17[7] = 151;
        nArrayArray5[11] = nArray17;
        int[] nArray18 = new int[8];
        nArray18[5] = 148;
        nArray18[6] = 149;
        nArray18[7] = 151;
        nArrayArray5[12] = nArray18;
        int[] nArray19 = new int[8];
        nArray19[5] = 148;
        nArray19[6] = 150;
        nArray19[7] = 152;
        nArrayArray5[13] = nArray19;
        nArrayArray5[14] = new int[]{120, 120, 120, 120, 120, 121, 255, 255};
        nArrayArray5[15] = new int[]{122, 122, 122, 122, 122, 123, 255, 255};
        nArrayArray5[16] = new int[]{124, 124, 124, 124, 124, 125, 255, 255};
        nArrayArray4[0] = nArrayArray5;
        ops = nArrayArray4;
        boolean[] blArray = new boolean[17];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        is_promotion_binary = blArray;
        openjumps = new int[][]{new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], new int[8], {159, 159, 159, 159, 159, 153, 153, 153}, {160, 160, 160, 160, 160, 154, 154, 154}, {161, 161, 161, 161, 161, 155, 155, 155}, {162, 162, 162, 162, 162, 156, 156, 156}, {163, 163, 163, 163, 163, 157, 157, 157}, {164, 164, 164, 164, 164, 158, 158, 158}, new int[8], new int[8], new int[8]};
        int[] nArray20 = new int[8];
        nArray20[1] = 145;
        nArray20[2] = 146;
        nArray20[3] = 147;
        norm = nArray20;
        int[][][] nArrayArray6 = new int[3][][];
        nArrayArray6[0] = new int[][]{{116, 116, 255, 116, 116, 117, 118, 119}, {255, 2, 2, 2, 2, 2, 255, 255}};
        int[][] nArrayArray7 = new int[2][];
        nArrayArray7[0] = new int[8];
        int[] nArray21 = new int[8];
        nArray21[1] = 130;
        nArray21[2] = 130;
        nArray21[3] = 130;
        nArray21[4] = 130;
        nArray21[5] = 133;
        nArrayArray7[1] = nArray21;
        nArrayArray6[1] = nArrayArray7;
        int[][] nArrayArray8 = new int[2][];
        nArrayArray8[0] = new int[8];
        int[] nArray22 = new int[8];
        nArray22[5] = 131;
        nArrayArray8[1] = nArray22;
        nArrayArray6[2] = nArrayArray8;
        una = nArrayArray6;
        int[][] nArrayArray9 = new int[2][];
        nArrayArray9[0] = new int[8];
        int[] nArray23 = new int[8];
        nArray23[1] = 1;
        nArray23[2] = 1;
        nArray23[3] = 1;
        nArray23[4] = 1;
        nArray23[5] = 2;
        nArrayArray9[1] = nArray23;
        una_excess_stack = nArrayArray9;
        stor = new byte[]{54, 54, 54, 54, 54, 55, 56, 57, 58};
        load = new byte[]{21, 21, 21, 21, 21, 22, 23, 24, 25};
        sladdr = new byte[]{4, 4, 4, 4, 4, 5, 7, 8, 10};
    }
}

