/*-------------------------------------------------------------------------*/
/* GNU Prolog                                                              */
/*                                                                         */
/* Part  : line-edit library                                               */
/* File  : char_io.c                                                       */
/* Descr.: basic character input/output                                    */
/* Author: Daniel Diaz                                                     */
/*                                                                         */
/* Copyright (C) 1999 Daniel Diaz                                          */
/*                                                                         */
/* GNU Prolog is free software; you can redistribute it and/or modify it   */
/* under the terms of the GNU General Public License as published by the   */
/* Free Software Foundation; either version 2, or any later version.       */
/*                                                                         */
/* GNU Prolog is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of              */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        */
/* General Public License for more details.                                */
/*                                                                         */
/* You should have received a copy of the GNU General Public License along */
/* with this program; if not, write to the Free Software Foundation, Inc.  */
/* 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     */
/*-------------------------------------------------------------------------*/
#include <ctype.h>

#if defined(__unix__) || defined(__CYGWIN__)
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <termio.h>

#else

#include <io.h>
#include <conio.h>

#endif

#include "char_io.h"
#include "stty.h"




/*---------------------------------*/
/* Constants                       */
/*---------------------------------*/

/*---------------------------------*/
/* Type Definitions                */
/*---------------------------------*/

/*---------------------------------*/
/* Global Variables                */
/*---------------------------------*/

/*---------------------------------*/
/* Function Prototypes             */
/*---------------------------------*/



/*-------------------------------------------------------------------------*/
/* LE_PUT_CHAR                                                             */
/*                                                                         */
/*-------------------------------------------------------------------------*/
void LE_Put_Char(int c,int fd_out)

{
#if defined(__unix__) || defined(__CYGWIN__)

 char c0=c;

 write(fd_out,&c0,1);

#else

 int row,col;

 if (c=='\b' && wherex()==1)                       /* goto 1 char backward */
    {
     LE_Screen_Size(0,&row,&col);
     gotoxy(col,wherey()-1);
    }
  else
     putch(c);

#endif
}




/*-------------------------------------------------------------------------*/
/* LE_GET_CHAR0                                                            */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int LE_Get_Char0(int fd_in)

{
 unsigned char c;

#if defined(__unix__) || defined(__CYGWIN__)

 if (read(fd_in,&c,1)!=1)
     return KEY_EOF;

#else

 c=getch();

#endif

 return (int) c;
}




/*-------------------------------------------------------------------------*/
/* LE_GET_CHAR                                                             */
/*                                                                         */
/*-------------------------------------------------------------------------*/
int LE_Get_Char(int fd_in)

{
 int esc_c;
 int c;


 c=LE_Get_Char0(fd_in);

#ifdef __msdos__                                              /* for MSDOS */

 if (c==0x00 || c==0xe0)
     return (1<<8)|LE_Get_Char0(fd_in);

#endif

 if (c==0x1b)                                         /* ANSI ESC sequence */
    {
     esc_c=LE_Get_Char0(fd_in);
     if (esc_c=='[')
        {
         c=LE_Get_Char0(fd_in);
         if (isdigit(c))
            {
             esc_c=c;
             c=0;
             while(esc_c!='~')
                {
                 c=c*10+esc_c-'0';
                 esc_c=LE_Get_Char0(fd_in);
                }
            }
         c=(1<<8)|c;
        }
      else
         c=KEY_ESC(esc_c);
    }

 return c;
}
