/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.database;

import gnu.prolog.database.Predicate;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.HashSet;
import java.util.Iterator;

public class Predicate_current_predicate
extends ExecuteOnlyCode {
    CompoundTermTag divideTag = CompoundTermTag.get("/", 2);

    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            CurrentPredicateBacktrackInfo bi = (CurrentPredicateBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return Predicate_current_predicate.nextSolution(interpreter, bi);
        }
        Term pi = args[0];
        if (!(pi instanceof VariableTerm)) {
            if (pi instanceof CompoundTerm) {
                CompoundTerm ct = (CompoundTerm)pi;
                if (ct.tag != this.divideTag) {
                    PrologException.typeError(TermConstants.predicateIndicatorAtom, pi);
                }
                Term n = ct.args[0].dereference();
                Term a = ct.args[1].dereference();
                if (!(n instanceof VariableTerm) && !(n instanceof AtomTerm)) {
                    PrologException.typeError(TermConstants.predicateIndicatorAtom, pi);
                }
                if (!(a instanceof VariableTerm) && !(a instanceof IntegerTerm)) {
                    PrologException.typeError(TermConstants.predicateIndicatorAtom, pi);
                }
            } else {
                PrologException.typeError(TermConstants.predicateIndicatorAtom, pi);
            }
        }
        HashSet<CompoundTermTag> tagSet = new HashSet<CompoundTermTag>(interpreter.getEnvironment().getModule().getPredicateTags());
        CurrentPredicateBacktrackInfo bi = new CurrentPredicateBacktrackInfo();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.pi = pi;
        bi.tagsIterator = tagSet.iterator();
        return Predicate_current_predicate.nextSolution(interpreter, bi);
    }

    private static int nextSolution(Interpreter interpreter, CurrentPredicateBacktrackInfo bi) throws PrologException {
        while (bi.tagsIterator.hasNext()) {
            int rc;
            CompoundTermTag tag = bi.tagsIterator.next();
            Predicate p = interpreter.getEnvironment().getModule().getDefinedPredicate(tag);
            if (p == null || p.getType() != Predicate.TYPE.USER_DEFINED && p.getType() != Predicate.TYPE.EXTERNAL || (rc = interpreter.unify(bi.pi, tag.getPredicateIndicator())) != 1) continue;
            interpreter.pushBacktrackInfo(bi);
            return 0;
        }
        return -1;
    }

    private static class CurrentPredicateBacktrackInfo
    extends BacktrackInfo {
        int startUndoPosition;
        Iterator<CompoundTermTag> tagsIterator;
        Term pi;

        CurrentPredicateBacktrackInfo() {
            super(-1, -1);
        }
    }
}

