/*
 This file is part of GNUnet.
 (C) 2011, 2012 Christian Grothoff (and other contributing authors)

 GNUnet is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published
 by the Free Software Foundation; either version 3, or (at your
 option) any later version.

 GNUnet is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with GNUnet; see the file COPYING.  If not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 */

package org.gnunet.dht;

import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.HashCode;
import org.gnunet.util.PeerIdentity;

import java.util.List;

/**
 * Callback object for requests to the dht
 */
public interface ResultCallback {
    /**
     * Called when the dht returns a result
     *
     * @param expiration expiration of the returned entry
     * @param key        key of the returned entry
     * @param getPath    put path of the returned entry
     * @param putPath    put path of the returned entry
     * @param type       type of data in the entry
     * @param data       data of the returned entry
     */
    public void handleResult(AbsoluteTime expiration, HashCode key,
                             List<PeerIdentity> getPath, List<PeerIdentity> putPath,
                             BlockType type, byte[] data);
}
