/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.Strings;
import org.gnunet.util.crypto.Ed25519;
import org.gnunet.util.crypto.EddsaPublicKey;

public class EddsaSignature
implements Message {
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] r;
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] s;

    public EddsaSignature() {
        this.r = new byte[32];
        this.s = new byte[32];
    }

    public EddsaSignature(Ed25519 r, BigInteger s) {
        this.r = r.encode();
        this.s = Ed25519.encodeScalar(s);
    }

    public boolean verifyRaw(byte[] m, EddsaPublicKey publicKey) {
        Ed25519 R = Ed25519.decode(this.r);
        if (!R.isOnCurve()) {
            return false;
        }
        Ed25519 A = publicKey.asPoint();
        BigInteger S = Ed25519.decodeScalar(this.s);
        ByteBuffer Stemp = ByteBuffer.allocate(64 + m.length);
        Stemp.put(R.encode()).put(A.encode()).put(m);
        BigInteger h = Ed25519.Hint(Stemp.array());
        Ed25519 ra = Ed25519.B.scalarmult(S);
        Ed25519 rb = R.add(A.scalarmult(h));
        if (!A.isOnCurve()) {
            throw new AssertionError();
        }
        if (!R.isOnCurve()) {
            throw new AssertionError();
        }
        if (!ra.isOnCurve()) {
            throw new AssertionError();
        }
        if (!rb.isOnCurve()) {
            throw new AssertionError();
        }
        return ra.equals(rb);
    }

    public static EddsaSignature fromString(String value) {
        byte[] data = new byte[64];
        if (!Strings.stringToData(value, data)) {
            throw new AssertionError();
        }
        EddsaSignature sig = new EddsaSignature();
        System.arraycopy(data, 0, sig.r, 0, 32);
        System.arraycopy(data, 32, sig.s, 0, 32);
        return sig;
    }

    public boolean verify(byte[] data, int purpose, EddsaPublicKey publicKey) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(data.length + 8);
        DataOutputStream dos = new DataOutputStream(os);
        try {
            dos.writeInt(data.length);
            dos.writeInt(purpose);
            dos.write(data);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.verifyRaw(os.toByteArray(), publicKey);
    }

    public static EddsaSignature randomGarbage() {
        EddsaSignature sig = new EddsaSignature();
        SecureRandom r = new SecureRandom();
        r.nextBytes(sig.r);
        r.nextBytes(sig.s);
        return sig;
    }

    public String toString() {
        byte[] sigData = new byte[64];
        System.arraycopy(this.r, 0, sigData, 0, 32);
        System.arraycopy(this.s, 0, sigData, 32, 32);
        return Strings.dataToString(sigData);
    }
}

