/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static Pattern section = Pattern.compile("\\[(.*?)\\]");
    private static Pattern tag = Pattern.compile("\\s*(\\S+?)\\s*=(.*?)");
    private static Pattern whitspace = Pattern.compile("\\s*");
    private final Table<String, String, String> sections = HashBasedTable.create();
    private final Map<String, Set<String>> sectionSources = new HashMap<String, Set<String>>(20);

    public String expandDollar(String orig) {
        Optional<String> path;
        String outside;
        String defaultVal;
        String substVal;
        if (orig.length() < 2 || !orig.startsWith("$")) {
            return orig;
        }
        if (orig.charAt(1) == '{') {
            int open = 1;
            int p = 2;
            while (open != 0) {
                if (orig.length() == p) {
                    logger.debug("unclosed '{'");
                    break;
                }
                if (orig.charAt(p) == '{') {
                    ++open;
                } else if (orig.charAt(p) == '}') {
                    --open;
                }
                ++p;
            }
            if (p != 2) {
                String inside = orig.substring(2, p - 1);
                String[] parts = inside.split(Pattern.quote(":-"), 2);
                if (parts.length == 1) {
                    substVal = orig.substring(2, p - 1);
                    defaultVal = "";
                } else {
                    substVal = parts[0];
                    defaultVal = parts[1];
                }
                outside = orig.length() > p ? orig.substring(p, orig.length()) : "";
            } else {
                outside = "";
                substVal = "";
                defaultVal = "";
            }
        } else {
            int p;
            defaultVal = "";
            for (p = 1; p < orig.length() && orig.charAt(p) != '\\' && orig.charAt(p) != '/'; ++p) {
            }
            if (p != orig.length()) {
                substVal = orig.substring(1, p);
                outside = orig.substring(p, orig.length());
            } else {
                substVal = orig.substring(1, orig.length());
                outside = "";
            }
        }
        Map<String, String> env = System.getenv();
        String result = env.containsKey(substVal) ? env.get(substVal) : ((path = this.getValueString("PATHS", substVal)).isPresent() ? (String)path.get() : this.expandDollar(defaultVal));
        return result + outside;
    }

    public Map<String, String> getSection(String s) {
        Map m = this.sections.row((Object)s);
        return Collections.unmodifiableMap(m);
    }

    public Set<String> getSections() {
        return this.sections.rowKeySet();
    }

    public Optional<String> getValueChoice(String section, String option, Iterable<String> choices) {
        Optional<String> value = this.getValueString(section, option);
        if (!value.isPresent()) {
            return value;
        }
        for (String c : choices) {
            if (!c.equals(value.get())) continue;
            return value;
        }
        logger.error("Failure in configuration section {}: invalid value", (Object)section);
        return Optional.absent();
    }

    public Optional<Long> getValueNumber(String section, String option) {
        Optional<String> num_str = this.getValueString(section, option);
        if (!num_str.isPresent()) {
            this.logSectionSources(section);
            return Optional.absent();
        }
        try {
            return Optional.of((Object)Long.parseLong((String)num_str.get()));
        }
        catch (NumberFormatException e) {
            logger.error("Failure in configuration section " + section + " option " + option + ": " + e.getMessage(), (Throwable)e);
            return Optional.absent();
        }
    }

    private void logSectionSources(String section) {
        Set<String> sources = this.sectionSources.get(section);
        if (sources == null) {
            logger.info("No sources for section '{}'", (Object)section);
        } else {
            logger.info("Sources for section '{}': {}", (Object)section, sources);
        }
    }

    public Optional<String> getValueString(String section, String option) {
        if (this.haveValue(section, option)) {
            return Optional.of((Object)this.sections.get((Object)section, (Object)option));
        }
        return Optional.absent();
    }

    public Optional<Boolean> getValueYesNo(String section, String option) {
        Optional<String> v = this.getValueChoice(section, option, Arrays.asList("YES", "NO"));
        if (!v.isPresent()) {
            Set<String> sources = this.sectionSources.get(section);
            if (sources == null) {
                logger.info("No sources for section '{}'", (Object)section);
            } else {
                logger.info("Sources for section '{}': {}", (Object)section, sources);
            }
            logger.error(String.format("Failure in configuration section '%s': option '%s' not found", section, option));
            return Optional.absent();
        }
        if (((String)v.get()).equalsIgnoreCase("YES")) {
            return Optional.of((Object)true);
        }
        if (((String)v.get()).equalsIgnoreCase("NO")) {
            return Optional.of((Object)false);
        }
        logger.error(String.format("Configuration error: section '%s', option '%s' not recognized as YES or NO", section, option));
        return Optional.absent();
    }

    public boolean haveValue(String section, String option) {
        return this.sections.contains((Object)section, (Object)option);
    }

    private void parseFromLines(Iterator<String> it, String filename) {
        String current_section = "";
        int lineNumber = 1;
        while (it.hasNext()) {
            String line = it.next();
            String[] split_line = line.split("#");
            if (split_line.length == 0) continue;
            line = split_line[0];
            Matcher m = tag.matcher(line);
            if (m.matches()) {
                String option = m.group(1).trim();
                String value = m.group(2).trim();
                if (value.length() != 0 && value.charAt(0) == '\"') {
                    int pos = value.indexOf(34, 1);
                    if (pos == -1) {
                        logger.warn("incorrecly quoted config value");
                        continue;
                    }
                    value = value.substring(1, pos);
                }
                this.setValueString(current_section, option, value);
            } else {
                m = section.matcher(line);
                if (m.matches()) {
                    current_section = m.group(1).trim();
                    if (this.sectionSources.containsKey(current_section)) {
                        this.sectionSources.get(current_section).add(filename);
                    } else {
                        this.sectionSources.put(current_section, new HashSet<String>(Collections.singleton(filename)));
                    }
                } else if (!whitspace.matcher(line).matches()) {
                    logger.warn(String.format("skipped unreadable line %s in configuration file '%s': '%s'", lineNumber, filename, line));
                }
            }
            ++lineNumber;
        }
    }

    public void parse(String filename) {
        Iterator<String> it;
        filename = this.replaceHome(filename);
        try {
            List lines = Files.readLines((File)new File(filename), (Charset)Charset.defaultCharset());
            it = lines.iterator();
        }
        catch (IOException e) {
            throw new ParsingError("Cannot read configuration file '" + filename + "'");
        }
        this.parseFromLines(it, filename);
    }

    private String replaceHome(String filename) {
        String home = System.getenv("HOME");
        return home != null ? filename.replace("~", home) : filename;
    }

    public void removeSection(String section) {
        this.sections.row((Object)section).clear();
    }

    public void setValueNumber(String section, String option, long value) {
        this.setValueString(section, option, "" + value);
    }

    public void setValueString(String section, String option, String value) {
        this.sections.put((Object)section, (Object)option, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String filename) throws IOException {
        BufferedWriter w = Files.newWriter((File)new File(filename), (Charset)Charsets.UTF_8);
        try {
            for (String section : this.sections.rowKeySet()) {
                w.write("[" + section + "]");
                w.newLine();
                for (Map.Entry e : this.sections.row((Object)section).entrySet()) {
                    w.write((String)e.getKey() + " = " + (String)e.getValue());
                    w.newLine();
                }
            }
        }
        finally {
            w.close();
        }
    }

    public String serialize() {
        StringBuffer buf = new StringBuffer();
        for (Map.Entry section : this.sections.rowMap().entrySet()) {
            buf.append("[" + (String)section.getKey() + "]\n");
            for (Map.Entry option : ((Map)section.getValue()).entrySet()) {
                buf.append((String)option.getKey() + " = " + (String)option.getValue() + "\n");
            }
        }
        return buf.toString();
    }

    public String serialize(String ... sectionNames) {
        StringBuffer buf = new StringBuffer();
        for (String sectionName : sectionNames) {
            buf.append("[" + sectionName + "]\n");
            for (Map.Entry option : this.sections.row((Object)sectionName).entrySet()) {
                buf.append((String)option.getKey() + " = " + (String)option.getValue() + "\n");
            }
        }
        return buf.toString();
    }

    public void loadDefaults() {
        ArrayList<File> dirs = new ArrayList<File>();
        String pfx = System.getenv("GNUNET_PREFIX");
        if (pfx != null) {
            dirs.add(new File(pfx, "share/gnunet/config.d/"));
            dirs.add(new File(pfx, "config.d/"));
            dirs.add(new File(pfx, "gnunet/config.d/"));
        }
        for (File dir : dirs) {
            File[] files;
            if (!dir.exists() || !dir.isDirectory() || (files = dir.listFiles()) == null) continue;
            for (File f : files) {
                this.parse(f.getAbsolutePath());
            }
        }
    }

    public Optional<String> getValueFilename(String section, String option) {
        return this.getValueString(section, option).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return Configuration.this.expandDollar(input);
            }
        });
    }

    public void deserialize(String str) {
        String[] linesArray = str.split("\\r?\\n");
        this.parseFromLines(Arrays.asList(linesArray).iterator(), "<serialized-config>");
    }

    public File writeTemp() {
        File f;
        try {
            f = File.createTempFile("gnunet-config", ".conf");
            f.deleteOnExit();
            Files.write((CharSequence)this.serialize(), (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return f;
    }

    public Configuration clone() {
        Configuration cfg = new Configuration();
        cfg.sections.putAll(this.sections);
        cfg.sectionSources.putAll(this.sectionSources);
        return cfg;
    }

    public static class ConfigurationException
    extends RuntimeException {
        public ConfigurationException(String string) {
            super(string);
        }
    }

    public static class ParsingError
    extends RuntimeException {
        ParsingError(String msg) {
            super(msg);
        }

        ParsingError(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

