/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.requests;

import com.google.common.collect.Maps;
import java.util.Map;
import org.gnunet.mq.MessageQueue;
import org.gnunet.requests.Request;
import org.gnunet.requests.RequestContainer;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.requests.SimpleRequestIdentifier;
import org.gnunet.util.Cancelable;

public class MatchingRequestContainer<K, T extends Request>
extends RequestContainer {
    private Map<K, Identifier> requests = Maps.newHashMap();
    private final MessageQueue mq;

    public MatchingRequestContainer(MessageQueue mq) {
        this.mq = mq;
    }

    public Cancelable addRequest(K key, T request) {
        if (this.requests.containsKey(key)) {
            throw new AssertionError((Object)"key already present in getRequestIdentifier container");
        }
        Identifier identifier = new Identifier(this, request, key);
        this.requests.put(key, identifier);
        identifier.send(this.mq);
        return identifier;
    }

    @Override
    public void restart() {
        Map<K, Identifier> requestsOld = this.requests;
        this.requests = Maps.newHashMap();
        for (Map.Entry<K, Identifier> e : requestsOld.entrySet()) {
            this.addRequest(e.getKey(), e.getValue().getRequest());
        }
    }

    public RequestIdentifier<T> getRequestIdentifier(K key) {
        return this.requests.get(key);
    }

    public T getAndRetireRequest(K key) {
        RequestIdentifier<T> i = this.getRequestIdentifier(key);
        if (null == i) {
            return null;
        }
        i.retire();
        return i.getRequest();
    }

    private static class Identifier
    extends SimpleRequestIdentifier<T> {
        final K key;
        final /* synthetic */ MatchingRequestContainer this$0;

        public Identifier(T request, K key) {
            this.this$0 = var1_1;
            super(request);
            this.key = key;
        }

        @Override
        public void retire() {
            super.retire();
            this.this$0.requests.remove(this.key);
        }
    }
}

