/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.core;

import com.google.common.collect.Maps;
import java.util.HashMap;
import org.gnunet.construct.Construct;
import org.gnunet.construct.MessageLoader;
import org.gnunet.construct.MessageUnion;
import org.gnunet.core.ConnectHandler;
import org.gnunet.core.DisconnectHandler;
import org.gnunet.core.HeaderNotify;
import org.gnunet.core.InitCallback;
import org.gnunet.core.MessageNotify;
import org.gnunet.core.PeerIdentityContinuation;
import org.gnunet.core.RequestIdentification;
import org.gnunet.core.messages.ConnectNotifyMessage;
import org.gnunet.core.messages.DisconnectNotifyMessage;
import org.gnunet.core.messages.InitMessage;
import org.gnunet.core.messages.InitReplyMessage;
import org.gnunet.core.messages.NotifyInboundTrafficMessage;
import org.gnunet.core.messages.NotifyOutboundTrafficMessage;
import org.gnunet.core.messages.SendMessage;
import org.gnunet.core.messages.SendMessageReady;
import org.gnunet.core.messages.SendMessageRequest;
import org.gnunet.mq.Envelope;
import org.gnunet.requests.MatchingRequestContainer;
import org.gnunet.requests.Request;
import org.gnunet.requests.RequestIdentifier;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Client;
import org.gnunet.util.Configuration;
import org.gnunet.util.Connection;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.MessageTransmitter;
import org.gnunet.util.PeerIdentity;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.RunaboutUtil;
import org.grothoff.Runabout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Core {
    private static final Logger logger = LoggerFactory.getLogger(Core.class);
    private final Client client;
    private InitCallback initCallback;
    private HeaderNotify notifyOutboundHeaders;
    private HeaderNotify notifyInboundHeaders;
    private MessageNotify notifyOutboundMessages;
    private MessageNotify notifyInboundMessages;
    private ConnectHandler connectHandler;
    private DisconnectHandler disconnectHandler;
    private int[] interested = new int[0];
    private Runabout messageHandler;
    private HashMap<PeerIdentity, Integer> connectedPeers = Maps.newHashMap();
    private MatchingRequestContainer<RequestIdentification, NotifyTransmitReadyRequest> ntrRequests;

    public Core(Configuration cfg) {
        this.client = new Client("core", cfg);
        this.client.installReceiver(new CoreReceiver());
        this.ntrRequests = new MatchingRequestContainer(this.client);
    }

    public void init(InitCallback initCallback) {
        this.initCallback = initCallback;
        InitMessage initMessage = new InitMessage();
        initMessage.interested = this.interested;
        initMessage.options = 0L;
        for (int i : this.interested) {
            logger.debug("we are interested in " + i);
        }
        this.client.sendPreferred(initMessage);
    }

    public Cancelable notifyTransmitReady(int priority, RelativeTime maxdelay, PeerIdentity target, int size, MessageTransmitter transmitter) {
        if (!this.connectedPeers.containsKey(target)) {
            throw new AssertionError((Object)"notifyTransmitReady called for unconnected peer");
        }
        int id = this.connectedPeers.get(target);
        this.connectedPeers.put(target, id + 1);
        NotifyTransmitReadyRequest notifyRequest = new NotifyTransmitReadyRequest(priority, size, target, maxdelay, transmitter);
        notifyRequest.smrId = id;
        RequestIdentification rid = new RequestIdentification(notifyRequest.smrId, target);
        return this.ntrRequests.addRequest(rid, notifyRequest);
    }

    public static void withPeerIdentity(Configuration cfg, final PeerIdentityContinuation cont) {
        final Core core = new Core(cfg);
        core.init(new InitCallback(){

            @Override
            public void onInit(PeerIdentity myIdentity) {
                core.disconnect();
                cont.cont(myIdentity);
            }
        });
    }

    public void observeOutboundHeaders(HeaderNotify h) {
        this.notifyOutboundHeaders = h;
    }

    public void observeInboundHeaders(HeaderNotify h) {
        this.notifyInboundHeaders = h;
    }

    public void observeInboundMessages(MessageNotify h) {
        this.notifyInboundMessages = h;
    }

    public void observeOutboundMessages(MessageNotify h) {
        this.notifyOutboundMessages = h;
    }

    public void observeConnect(ConnectHandler connectHandler) {
        this.connectHandler = connectHandler;
    }

    public void observeDisconnect(DisconnectHandler disconnectHandler) {
        this.disconnectHandler = disconnectHandler;
    }

    public void setMessageHandler(Runabout runabout) {
        if (this.messageHandler != null) {
            throw new AssertionError((Object)"Core can have only on message handler");
        }
        if (this.client.isConnected()) {
            throw new AssertionError((Object)"can set message handler only if not yet connected");
        }
        this.messageHandler = runabout;
        this.interested = RunaboutUtil.getRunaboutMessageTypes(runabout);
    }

    public void disconnect() {
        this.client.disconnect();
    }

    public final class CoreReceiver
    extends RunaboutMessageReceiver {
        public void visit(InitReplyMessage m) {
            PeerIdentity myIdentity = m.myIdentity;
            Core.this.connectedPeers.put(myIdentity, 1);
            if (Core.this.initCallback != null) {
                Core.this.initCallback.onInit(m.myIdentity);
                Core.this.initCallback = null;
            }
        }

        public void visit(ConnectNotifyMessage m) {
            if (Core.this.connectHandler != null) {
                Core.this.connectHandler.onConnect(m.peer);
            }
        }

        public void visit(DisconnectNotifyMessage m) {
            if (Core.this.disconnectHandler != null) {
                Core.this.disconnectHandler.onDisconnect(m.peer);
            }
        }

        public void visit(NotifyInboundTrafficMessage m) {
            boolean found = false;
            if (Core.this.notifyInboundHeaders != null) {
                Core.this.notifyInboundHeaders.notify(m.payloadHeader);
            }
            if (Core.this.notifyInboundMessages != null) {
                // empty if block
            }
            for (int i : Core.this.interested) {
                if (i != m.payloadHeader.messageType) continue;
                found = true;
                break;
            }
            if (found) {
                Class<? extends MessageUnion> bodyClass = MessageLoader.getUnionClass(GnunetMessage.Body.class, m.payloadHeader.messageType);
                GnunetMessage.Body b = (GnunetMessage.Body)Construct.parseAs(m.payloadBody, bodyClass);
                Core.this.messageHandler.visitAppropriate(b);
            }
        }

        public void visit(NotifyOutboundTrafficMessage m) {
            if (Core.this.notifyOutboundHeaders != null) {
                Core.this.notifyOutboundHeaders.notify(m.payloadHeader);
            }
            if (Core.this.notifyOutboundMessages != null) {
                // empty if block
            }
        }

        public void visit(SendMessageReady m) {
            logger.debug("got SendMessageReady");
            RequestIdentification rid = new RequestIdentification(m.smrId, m.peer);
            RequestIdentifier reqId = Core.this.ntrRequests.getRequestIdentifier(rid);
            NotifyTransmitReadyRequest req = (NotifyTransmitReadyRequest)reqId.getRequest();
            final SendMessage sm = new SendMessage();
            sm.cork = 0;
            sm.peer = req.target;
            sm.priority = req.priority;
            sm.deadline = req.deadline.asMessage();
            req.transmitter.transmit(new Connection.MessageSink(){
                boolean sent;

                @Override
                public void send(GnunetMessage.Body m) {
                    if (this.sent) {
                        throw new AssertionError((Object)"sending multiple messages not supported");
                    }
                    sm.payloadMessage = GnunetMessage.fromBody(m);
                    this.sent = true;
                }
            });
            if (sm.payloadMessage == null) {
                throw new AssertionError();
            }
            Core.this.client.send(sm);
        }

        @Override
        public void visitDefault(Object o) {
            logger.warn("received unexpected message from core: {}", o.getClass());
        }

        @Override
        public void handleError() {
            logger.warn("Error receiving from the transport service.");
            if (Core.this.disconnectHandler != null) {
                for (PeerIdentity e : Core.this.connectedPeers.keySet()) {
                    Core.this.disconnectHandler.onDisconnect(e);
                }
            }
            Core.this.connectedPeers.clear();
        }
    }

    public static class NotifyTransmitReadyRequest
    extends Request {
        private final int size;
        public final PeerIdentity target;
        public final long priority;
        public int smrId;
        public final MessageTransmitter transmitter;
        public final AbsoluteTime deadline;

        public NotifyTransmitReadyRequest(int priority, int size, PeerIdentity target, RelativeTime timeout, MessageTransmitter transmitter) {
            this.deadline = timeout.toAbsolute();
            this.priority = priority;
            this.size = size;
            this.target = target;
            this.transmitter = transmitter;
        }

        @Override
        public Envelope assembleRequest() {
            SendMessageRequest m = new SendMessageRequest();
            m.peer = this.target;
            m.smrId = this.smrId;
            m.priority = this.priority;
            m.size = this.size;
            m.deadline = this.deadline.asMessage();
            return new Envelope(m);
        }

        public void onCancel() {
        }
    }
}

