/* -*- mode: c++ -*- 
*/
/* 

    GIFT, a flexible content based image retrieval system.
    Copyright (C) 1998, 1999, 2000 CUI, University of Geneva

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
// -*- mode: c++ -*-
#ifndef _CQMULTIPLE
#define _CQMULTIPLE


/* -*- mode: c++ -*- 
*/
/**
 *
 * CQMultiple.h
 * A CQuery structure which has several children
 * queries them one after another,
 * weights them, and obtains a common result
 *
 *
 *
 * modification history:
 *
 * WM 20000205 creation
 *
 *
 *
 * compiler defines used:
 * _CQMULTIPLE avoids double inclusion
 *
 */
#include <memory>
#include <map>
#include <list>
#include "CQuery.h"
#include "CSelfDestroyPointer.h"
#include "CIDRelevanceLevelPairList.h"
#include "CRelevanceLevelList.h"

//#include "CWeightingFunctionPointerList.h"
//#include "CWeightingFunctionPointerHash.h"

#include "CAlgorithm.h"
#include "CAccessor.h"
#include "CAccessorCollection.h"
#include "CAccessorProxy.h"

#include <hash_map>

class CScoreBoard;
class CAccessor;


/** 

    This is going to be one of our main building blocks.
    It is a structure which contains a couple of 
    CQuery structures, hands a query through to them,
    and then unifies the result. In fact this is the center of 
    all this query tree business.

    Probably we will put another layer into the class tree:
    The CQTreeNode, but let's first start.

    Important: The basic assumption here is, that all children 
    operate on the same collections. If this is not the case we 
    have to be more careful, and most of all: we have to operate using
    URLs.

    @Author: Wolfgang Mller

 */
class CQMultiple:public CQuery{
protected:
  void init();

 public:
  /**
   *
   * default constructor
   * 
   */
  CQMultiple();
  /**
   *
   * we need to unregister the accessors used
   * 
   */
  ~CQMultiple();
  /**
   * In fact, what we are doing here is to get ourselves
   * an accessor ACURL2FTS to do a proper fastQuery
   */
  CQMultiple(CAccessorCollection& inAccessorCollection,
	     CAlgorithm&          inAlgorithm);
    
  /**
   *
   * calls fastQuery for every child, merges the results
   *
   */
  virtual CIDRelevanceLevelPairList* fastQuery(const CXMLElement& inQuery,
					       int inNumberOfInterestingImages,
					       double inDifferenceToBest);

  /**
   *
   * set the Algorithm.
   * same scheme as in setCollection
   *
   */
  virtual bool setAlgorithm(CAlgorithm& inAlgorithm);

}; /* end of class */

#endif

