$!
$!	This command procedure makes the necessary definitions for GNU CC
$!	to run.
$!
$! Find the directory spec. for the install procedure
$!
$ Procedure:='f$environment("PROCEDURE")'
$ Device:='f$parse(Procedure,,,"DEVICE","NO_CONCEAL")'
$ Directory:='f$parse(Procedure,,,"DIRECTORY","NO_CONCEAL")'
$ Path:="''Device'''Directory'"
$!
$! Check for "rooted" directory specs
$!
$ l = 'f$length(Path)'
$ tmp = 'f$locate(".][",Path)'
$ if 'tmp' .ne. 'l' then goto 10$
$ tmp = 'f$locate(".><",Path)'
$ if 'tmp' .ne. 'l' then goto 10$
$ goto 100$
$!
$! Eliminate rooted directory specs
$!
$ 10$:
$ if "''f$extract(tmp,255,Path)'" .eqs. ".][000000]" then goto 20$
$ if "''f$extract(tmp,255,Path)'" .eqs. ".><000000>" then goto 20$
$ l = tmp + 3
$ Path:="''f$extract(0,tmp,Path)'.''f$extract(l,255,Path)'"
$ goto 100$
$ 20$:
$ l = tmp + 1
$ Path:="''f$extract(0,tmp,Path)'''f$extract(l,1,Path)'"
$ 100$:
$!
$! Calculate the prefix and suffix (used in generating desired paths)
$!
$ l = 'f$length(Path)' - 1
$ Prefix:='f$Extract(0,l,Path)'
$ Suffix:='f$extract(l,1,Path)'
$!
$!	Setup the values for the GNU CC logical names
$!
$ gnu_cc_path:="''Prefix'.''Suffix'"
$ gnu_include_path:="''Prefix'.INCLUDE.''Suffix'"
$ gpp_include_path:="''Prefix'.GXX_INCLUDE.''Suffix'"
$!
$ system = "/job"
$ if f$priv("SYSNAM").eqs."TRUE" then system = "/system"
$ if f$priv("SYSPRV").eqs."TRUE" then system = "/system"
$!
$!	Assign GNU_CC
$!
$ assign'system' 'gnu_cc_path' GNU_CC/tran=(conc)
$!
$!	Assign GNU_CC_INCLUDE
$!
$ assign'system' 'gnu_include_path' GNU_CC_INCLUDE/tran=(conc)
$ assign'system' 'gpp_include_path' GNU_GXX_INCLUDE/tran=(conc)
$!
$!	Calculate the GCC version number
$!	(we get it from the GCC pre-processor)
$!
$ Version_File_Name="sys$scratch:gcc-version-" + f$getjpi("","pid") +".tmp"
$!
$! make sure case where sys$scratch not being defined is handled with grace.
$!
$ if f$trnlnm("sys$scratch").eqs."" then -
       Version_File_Name="gcc-version-" + f$getjpi("","pid") +".tmp"
$!
$ Version:=""
$ cpp:=$gnu_cc:[000000]gcc-cpp
$ assign/user nla0: sys$output
$ assign/user 'Version_File_Name' sys$error
$ cpp -v
$ open/read/error=Version_File_Not_Found Version_File 'Version_File_Name'
$ read/error=Read_Error/end_of_file=Read_Error Version_File Line
$ 1000$:
$ tmp = 'f$locate(".", Line)'
$ if 'f$length(Line)' .eq. tmp then goto 1020$
$ 1001$:
$ tmp = tmp - 1
$ if f$extract(tmp,1,Line).nes." " then goto 1001$
$ tmp = tmp + 1
$ Line:="''f$extract(tmp, 255, Line)'"
$ tmp = 'f$locate(" ", Line)'
$ if 'f$length(Line)' .ne. tmp then Line = f$extract(0,tmp,Line)
$ 1020$:
$ Version:="''Line'"
$!
$ Read_Error:
$ close Version_File
$ delete/nolog/noconfirm 'Version_File_Name';*
$!
$ Version_File_Not_Found:
$ if "''Version'" .eqs. "" then Version:="Unknown"
$ define'system' GNU_CC_VERSION "''Version'"
$!
$! Make it easier to have libg++ in the gnu_cc directory tree.
$!
$ if f$search("gnu_cc:[000000]libgxx_shr.exe").nes."" then -
	define'system' libgxx_shr gnu_cc:[000000]libgxx_shr.exe
