// g++ 1.37.1 bug 900428_01

// g++ fails to issue error messages for cases where an incomplete type
// object must be evaluated if the value of such an evaluation is not
// actually used in the given context.

// In the case where such an object is volatile, it is obvious that this
// could be a problem, however I believe that errors should be issued
// for such cases regardless of whether or not such values are volatile
// because the abstract semantics seem to require the evaluation of such
// values whether they are volatile or not.

// keywords: incomplete types, evaluation, volatile qualifier

int i;

void *pv;
volatile void *pvv;
struct s;
extern struct s es, *ps;
extern volatile struct s evs, *pvs;

void pv_test ()
{
  *pv;			/* ERROR -  */
  (i ? *pv : *pv);	/* ERROR -  */
  *pv, *pv;		/* ERROR -  */

  *pvv;			/* ERROR -  */
  (i ? *pvv : *pvv);	/* ERROR -  */
  *pvv, *pvv;		/* ERROR -  */

  es;			/* ERROR -  */
  (i ? es : es);	/* ERROR -  */
  es, es;		/* ERROR -  */

  evs;			/* ERROR -  */
  (i ? evs : evs);	/* ERROR -  */
  evs, evs;		/* ERROR -  */

  *ps;			/* ERROR -  */
  (i ? *ps : *ps);	/* ERROR -  */
  *ps, *ps;		/* ERROR -  */

  *pvs;			/* ERROR -  */
  (i ? *pvs : *pvs);	/* ERROR -  */
  *pvs, *pvs;		/* ERROR -  */
}

int main () { return 0; }
