/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.patterns;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.patterns.PJob;
import com.sun.electric.tool.util.concurrent.patterns.PTask;

public class PWhileJob<T>
extends PJob {
    private IStructure<T> items;
    private PWhileTask<T> task;

    public PWhileJob(IStructure<T> items, PWhileTask<T> task) {
        this.items = items;
        this.task = task;
    }

    @Override
    public void execute() {
        int numOfThreads = this.pool.getPoolSize();
        for (int i = 0; i < numOfThreads; ++i) {
            this.add(new WhileTaskWrapper<T>(this, this.task, this.items), i);
        }
        super.execute();
    }

    public static abstract class PWhileTask<T>
    extends PTask
    implements Cloneable {
        public PWhileTask(PJob job) {
            super(job);
        }

        public PWhileTask() {
            super(null);
        }

        public abstract void execute(T var1);

        @Override
        public final void execute() {
        }
    }

    public static final class WhileTaskWrapper<T>
    extends PTask {
        private IStructure<T> items;
        private PWhileTask<T> task;

        public WhileTaskWrapper(PJob job, PWhileTask<T> task, IStructure<T> items) {
            super(job);
            this.items = items;
            this.task = task;
        }

        @Override
        public void execute() {
            Object item = null;
            item = this.items.remove();
            while (item != null) {
                try {
                    PWhileTask tmp = (PWhileTask)this.task.clone();
                    tmp.execute(item);
                    item = this.items.remove();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

