/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.ACL2Complex;
import com.sun.electric.util.acl2.ACL2Integer;
import com.sun.electric.util.acl2.ACL2Object;
import com.sun.electric.util.acl2.HonsManager;
import com.sun.electric.util.acl2.Rational;
import java.util.Map;

class ACL2Rational
extends ACL2Object {
    final Rational v;

    ACL2Rational(Rational v) {
        this(null, v);
    }

    private ACL2Rational(HonsManager hm, Rational v) {
        super(v.hashCode(), hm);
        if (v.isInteger()) {
            throw new IllegalArgumentException();
        }
        this.v = v;
    }

    static ACL2Rational intern(Rational v, HonsManager hm) {
        Map<Rational, ACL2Rational> allNormed = hm.rationals;
        ACL2Rational result = allNormed.get(v);
        if (result == null) {
            result = new ACL2Rational(hm, v);
            allNormed.put(v, result);
        }
        return result;
    }

    @Override
    boolean isACL2Number() {
        return true;
    }

    @Override
    Rational ratfix() {
        return this.v;
    }

    @Override
    ACL2Object unaryMinus() {
        return ACL2Rational.valueOf(this.v.negate());
    }

    @Override
    ACL2Object unarySlash() {
        return ACL2Rational.valueOf(this.v.inverse());
    }

    @Override
    ACL2Object binaryPlus(ACL2Object y) {
        return y.binaryPlus(this);
    }

    @Override
    ACL2Object binaryPlus(ACL2Integer y) {
        return new ACL2Rational(this.v.add(y.v));
    }

    @Override
    ACL2Object binaryPlus(ACL2Rational y) {
        return ACL2Rational.valueOf(this.v.add(y.v));
    }

    @Override
    ACL2Object binaryPlus(ACL2Complex y) {
        return y.binaryPlus(this);
    }

    @Override
    ACL2Object binaryStar(ACL2Object y) {
        return y.binaryStar(this);
    }

    @Override
    ACL2Object binaryStar(ACL2Integer y) {
        return ACL2Rational.valueOf(this.v.mul(y.v));
    }

    @Override
    ACL2Object binaryStar(ACL2Rational y) {
        return ACL2Rational.valueOf(this.v.mul(y.v));
    }

    @Override
    ACL2Object binaryStar(ACL2Complex y) {
        return y.binaryStar(this);
    }

    @Override
    int signum() {
        return this.v.signum();
    }

    @Override
    int compareTo(ACL2Object y) {
        return -y.compareTo(this);
    }

    @Override
    int compareTo(ACL2Integer y) {
        return this.v.compareTo(y.v);
    }

    @Override
    int compareTo(ACL2Rational y) {
        return this.v.compareTo(y.v);
    }

    @Override
    int compareTo(ACL2Complex y) {
        return -y.compareTo(this);
    }

    @Override
    public String rep() {
        return this.v.toString();
    }

    @Override
    ACL2Object internImpl(HonsManager hm) {
        return ACL2Rational.intern(this.v, hm);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ACL2Rational) {
            ACL2Rational that = (ACL2Rational)o;
            if (this.hashCode == that.hashCode && (this.honsOwner == null || this.honsOwner != that.honsOwner)) {
                return this.v.equals(that.v);
            }
        }
        return false;
    }
}

