/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.map;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNodeBase;
import java.util.Vector;

public class FieldMap<T extends AStarNodeBase<T>>
extends AStarMapBase<T> {
    protected int wx;
    protected int wy;
    protected int wz;
    protected boolean[] blockages;
    protected Vector<T> nodes;

    protected FieldMap(FieldMap<T> clone2) {
        this.wx = clone2.wx;
        this.wy = clone2.wy;
        this.wz = clone2.wz;
        int sz = this.wx * this.wy * this.wz;
        this.blockages = new boolean[sz];
        for (int i = 0; i < sz; ++i) {
            this.blockages[i] = clone2.blockages[i];
        }
        this.nodes = new Vector(sz);
        this.nodes.setSize(sz);
        this.objectPool = clone2.objectPool;
    }

    public FieldMap(int wx, int wy, int wz, int ox, int oy, int oz) {
        assert (ox == 0 && oy == 0 && oz == 0);
        this.wx = wx;
        this.wy = wy;
        this.wz = wz;
        int sz = this.wx * this.wy * this.wz;
        this.blockages = new boolean[sz];
        this.nodes = new Vector(sz);
        this.nodes.setSize(sz);
    }

    @Override
    public void visitNeighboursOf(T origin, AStarMapVisitorBase<T> visitor) {
        this.visitNeighboursOf4(origin, visitor);
    }

    public boolean inRange(int x2, int y, int z) {
        return x2 >= 0 && y >= 0 && z >= 0 && x2 < this.wx && y < this.wy && z < this.wz;
    }

    private int getOff(int x2, int y, int z) {
        if (x2 < 0 || y < 0 || z < 0 || x2 >= this.wx || y >= this.wy || z >= this.wz) {
            return -1;
        }
        int off = x2 + y * this.wx + z * this.wx * this.wy;
        return off;
    }

    @Override
    public boolean isTileBlocked(int x2, int y, int z) {
        int off = this.getOff(x2, y, z);
        if (off == -1) {
            return true;
        }
        return this.blockages[off];
    }

    @Override
    public void setTileBlocked(int x2, int y, int z, boolean blockedStatus) {
        int off = this.getOff(x2, y, z);
        assert (off != -1);
        this.blockages[off] = blockedStatus;
    }

    @Override
    public T nodeAt(int x2, int y, int z) {
        int off = this.getOff(x2, y, z);
        if (off == -1) {
            return null;
        }
        AStarNodeBase node = (AStarNodeBase)this.nodes.elementAt(off);
        if (node == null) {
            node = (AStarNodeBase)this.objectPool.acquire();
            node.initialize(null, 0, 0, 0, x2, y, z);
            this.nodes.setElementAt(node, off);
        }
        return (T)node;
    }

    public T getNode(int x2, int y, int z) {
        int off = this.getOff(x2, y, z);
        if (off == -1) {
            return null;
        }
        return (T)((AStarNodeBase)this.nodes.elementAt(off));
    }

    public void setNode(int x2, int y, int z, T node) {
        int off = this.getOff(x2, y, z);
        assert (off != -1);
        this.nodes.setElementAt(node, off);
    }

    @Override
    public void clearMapKeepBlocks() {
        for (int i = 0; i < this.wx * this.wy * this.wz; ++i) {
            this.nodes.setElementAt(null, i);
        }
    }

    @Override
    public AStarMapBase<T> clone() {
        return new FieldMap<T>(this);
    }

    @Override
    public int getMaxXNodes() {
        return this.wx;
    }

    @Override
    public int getMaxYNodes() {
        return this.wy;
    }

    @Override
    public int getMaxZNodes() {
        return this.wz;
    }
}

