/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config.model;

import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.config.model.ConfigEntries;
import com.sun.electric.util.config.model.ConfigEntry;
import com.sun.electric.util.config.model.Parameter;
import com.sun.electric.util.config.model.ParameterEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Injection {
    private String name;
    private String implementation;
    private String factoryMethod;
    private List<Parameter> parameters;
    private boolean singleton = false;

    public Injection(String name, String implementation, String factoryMethod, boolean singleton) {
        this.name = name;
        this.implementation = implementation;
        this.factoryMethod = factoryMethod;
        this.singleton = singleton;
        this.setParameters(null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public ConfigEntry<?> createConfigEntry(Map<String, Injection> allInjections) throws ClassNotFoundException, LinkageError {
        ConfigEntry<?> entry = null;
        ArrayList<ParameterEntry> paramEntries = null;
        ParameterEntry[] entries = null;
        if (this.parameters != null) {
            paramEntries = CollectionFactory.createArrayList();
            for (Parameter param2 : this.parameters) {
                paramEntries.add(param2.createParameter(allInjections));
            }
            entries = paramEntries.toArray(new ParameterEntry[paramEntries.size()]);
        }
        entry = this.factoryMethod == null ? ConfigEntry.createForConstructor(Class.forName(this.implementation), this.singleton, entries) : ConfigEntry.createForFactoryMethod(Class.forName(this.implementation), this.factoryMethod, this.singleton, entries);
        ConfigEntries.getEntries().put(this.name, entry);
        return entry;
    }

    public static enum Attributes {
        name,
        implementation,
        factoryMethod,
        singleton;

    }
}

