/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class PortFilter {
    public static final PortFilter SCHEMATIC = new SchemPortFilter();

    public abstract boolean skipPort(PortInst var1);

    public final Iterator<PortInst> filter(Iterator<PortInst> ports) {
        ArrayList<PortInst> filtered = new ArrayList<PortInst>();
        while (ports.hasNext()) {
            PortInst pi = ports.next();
            if (this.skipPort(pi)) continue;
            filtered.add(pi);
        }
        return filtered.iterator();
    }

    public static class SchemPortFilter
    extends PortFilter {
        @Override
        public boolean skipPort(PortInst pi) {
            NodeInst ni = pi.getNodeInst();
            if (ni.isIconOfParent()) {
                return true;
            }
            NodeProto np = ni.getProto();
            String nm = np.getName();
            return !ni.isCellInstance() && (nm.equals("Wire_Pin") || nm.equals("Bus_Pin") || nm.equals("Off-Page") || nm.equals("Facet-Center") || nm.equals("Invisible-Pin"));
        }
    }
}

