/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Equipment;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.Logger;

class Pst3202
extends Equipment {
    String s = new String("null");
    private static final float[] VOLTAGE_RESOLUTION = new float[]{0.01f, 0.01f, 0.002f};
    public static final int NUM_CHANNELS = 3;
    public static final float GPIB_DELAY = 0.2f;
    public static final int MAX_NUM_ERRORS = 20;

    public Pst3202(String name) {
        super(name);
        Pst3202.logInit("  Initializing Pst3202 " + name);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.writeAndWait(":*CLS");
        this.testConnection();
    }

    public String getState(int channel) {
        Pst3202.checkChannel(channel);
        String result = "Set " + this.getVoltageSetpoint(channel) + " V, " + this.getCurrentSetpoint(channel) + " A\n";
        result = result + "Got " + this.readVoltage(channel) + " V, " + this.readCurrent(channel) + " A";
        return result;
    }

    static void checkChannel(int channel) {
        if (channel < 1 || channel > 3) {
            throw new IllegalArgumentException("Channel " + channel + " outside allowed range 1.." + 3);
        }
    }

    private void writeAndWait(String data) {
        super.write(data);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void write(String data) {
        this.writeAndWait(data);
    }

    public static float getVoltageResolution(int channel) {
        Pst3202.checkChannel(channel);
        return VOLTAGE_RESOLUTION[channel - 1];
    }

    void testConnection() {
        this.writeAndWait("*idn?");
        this.s = this.read(200).trim();
        System.out.println("idn " + this.s);
    }

    String readError() {
        this.write("SYST:ERR?");
        this.s = this.read(200);
        return this.s;
    }

    void handleError() {
        if (this.isDisabled()) {
            return;
        }
        for (int ind = 0; ind < 20; ++ind) {
            String error = this.readError();
            if (error.length() <= 0) {
                System.err.println("Pst3202.handleError() no reply from supply");
            }
            System.err.println("PST 3202 reports error " + error);
            if (!error.equals("0, \"No error\"")) continue;
            return;
        }
        Infrastructure.nonfatal("Printed 20 errors from PST 3202");
    }

    public float readVoltage(int channel) {
        Pst3202.checkChannel(channel);
        this.write(":CHAN" + channel + ":MEAS:VOLT ?");
        this.s = this.read(200);
        if (this.s.length() <= 0) {
            this.handleError();
            return -1.0f;
        }
        return Float.parseFloat(this.s);
    }

    public float getVoltageSetpoint(int channel) {
        Pst3202.checkChannel(channel);
        this.logOther("Reading voltage setpoint on Pst3202 " + this.getName() + ", channel " + channel);
        this.write(":CHAN" + channel + ":VOLT?");
        this.s = this.read(200).trim();
        if (this.s.length() <= 0) {
            this.handleError();
            return -1.0f;
        }
        return Float.parseFloat(this.s);
    }

    public boolean setVoltage(int channel, float setVolts) {
        Pst3202.checkChannel(channel);
        this.writeAndWait(":CHAN" + channel + ":VOLT " + setVolts);
        return true;
    }

    public boolean setVoltageCheck(int channel, float setVolts) {
        Pst3202.checkChannel(channel);
        this.write(":CHAN" + channel + ":VOLT " + setVolts + ";VOLT?");
        this.s = this.read(200);
        if (this.s.length() <= 0) {
            this.handleError();
            return false;
        }
        float volts = Float.parseFloat(this.s);
        if ((double)Math.abs(volts - setVolts) > 1.0001 * (double)Pst3202.getVoltageResolution(channel)) {
            Infrastructure.nonfatal(this + ": requested voltage setpoint is" + setVolts + " V, but setpoint obtained is " + volts + " V");
            return false;
        }
        return true;
    }

    public float readCurrent(int channel) {
        Pst3202.checkChannel(channel);
        this.write(":CHAN" + channel + ":MEAS:CURR ?");
        String s = this.read(10);
        if (s.length() <= 0) {
            this.handleError();
            return -1.0f;
        }
        return Float.parseFloat(s);
    }

    public float getCurrentSetpoint(int channel) {
        Pst3202.checkChannel(channel);
        this.write(":CHAN" + channel + ":CURR ?");
        String s = this.read(10);
        if (s.length() <= 0) {
            this.handleError();
            return -1.0f;
        }
        return Float.parseFloat(s);
    }

    public void clear() {
        super.clear();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setCurrent(int channel, float setAmps) {
        Pst3202.checkChannel(channel);
        this.writeAndWait(":CHAN" + channel + ":CURR " + setAmps);
    }

    public void switchOnOff(int state) {
        this.write(":OUTPUT:STATE " + state);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.write(":OUTPUT:STATE?");
        this.s = this.read(200).trim();
        System.out.println("state " + this.s);
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{1};
        Logger.setLogInits(true);
        Pst3202 supply = new Pst3202("hPst3202");
        supply.clear();
        System.out.println("Error1: " + supply.readError());
        System.out.println("Error2: " + supply.readError());
        System.out.println("Error3: " + supply.readError());
        System.out.println("Error4: " + supply.readError());
        System.out.println("Error5: " + supply.readError());
        supply.testConnection();
        float voltageSetpoint = supply.getVoltageSetpoint(1);
        System.out.println(supply.getState(1));
        if (voltageSetpoint < 0.2f) {
            voltageSetpoint = 0.2f;
        }
        for (int chan = 1; chan <= 3; ++chan) {
            System.out.println("Chan " + chan + " resolution: " + Pst3202.getVoltageResolution(chan) + " V");
        }
        float dv = 0.0f;
        while ((double)dv < 0.014) {
            supply.setVoltage(1, voltageSetpoint - dv);
            System.out.println(voltageSetpoint - dv + ": " + supply.getState(1) + "\n");
            dv = (float)((double)dv + 0.002);
        }
        for (float volts = 1.8f; volts >= 1.6f; volts -= 0.01f) {
            System.out.println(volts);
            supply.setVoltage(1, volts);
            supply.setVoltage(3, volts);
        }
        System.out.println("Error6: " + supply.readError());
        System.out.println(supply.getState(1));
        supply.setVoltage(1, voltageSetpoint);
        supply.setVoltage(3, voltageSetpoint);
        System.out.println("Error7: " + supply.readError());
        System.out.println(supply.getState(1));
        System.out.println("Error8: " + supply.readError());
    }
}

