/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class InvV {
    private static final double wellOverhangDiff = 6.0;
    private static final double inY = 0.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double pSz, double nSz, StdCellParams stdCell) {
        int i;
        TechType tech = stdCell.getTechType();
        String nm = "invV_p" + pSz + "_n" + nSz + "{lay}";
        double outsideSpace = stdCell.getDoubleStrapGate() ? 8.5 : 6.0;
        double spaceAvail = stdCell.getCellTop() - outsideSpace - 6.0;
        double lamPerSz = 6.0;
        double totWidP = pSz * lamPerSz;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWidP, 1);
        InvV.error(fwP == null, "can't make " + nm + " this small: " + pSz);
        spaceAvail = -6.0 - (stdCell.getCellBot() + outsideSpace);
        lamPerSz = 3.0;
        double totWidN = nSz * lamPerSz;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWidN, 1);
        InvV.error(fwN == null, "can't make " + nm + " this small: " + nSz);
        Cell inv = stdCell.findPart(nm);
        if (inv != null) {
            return inv;
        }
        inv = stdCell.newPart(nm);
        double inX = 3.5;
        LayoutLib.newExport(inv, "in", PortCharacteristic.IN, tech.m1(), 4.0, inX, 0.0);
        double mosX = inX + 2.0 + 3.0 + 2.0;
        double nmosY = -6.0 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, nmosY, fwN.nbFolds, 1, fwN.gateWid, inv, tech);
        double pmosY = 6.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(mosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, inv, tech);
        double outX = StdCellParams.getRightDiffX(nmos, pmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(inv, "out", PortCharacteristic.OUT, tech.m1(), 4.0, outX, 0.0);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, inv);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, inv);
        TrackRouterH in = new TrackRouterH(tech.m1(), 3.0, 0.0, tech, inv);
        in.connect(inv.findExport("in"));
        for (i = 0; i < pmos.nbGates(); ++i) {
            in.connect(pmos.getGate(i, 'B'));
        }
        for (i = 0; i < nmos.nbGates(); ++i) {
            in.connect(nmos.getGate(i, 'T'));
        }
        if (stdCell.getDoubleStrapGate()) {
            double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
            double inLoFromGnd = gndBot - 3.0 - 2.0;
            double nmosBot = nmosY - fwN.physWid / 2.0;
            double inLoFromMos = nmosBot - 2.0 - 2.5;
            double inLoY = Math.min(inLoFromGnd, inLoFromMos);
            TrackRouterH inLo = new TrackRouterH(tech.m1(), 3.0, inLoY, tech, inv);
            inLo.connect(inv.findExport("in"));
            for (int i2 = 0; i2 < nmos.nbGates(); ++i2) {
                inLo.connect(nmos.getGate(i2, 'B'));
            }
            double vddTop = stdCell.getVddY() + stdCell.getVddWidth() / 2.0;
            double inHiFromVdd = vddTop + 3.0 + 2.0;
            double pmosTop = pmosY + fwP.physWid / 2.0;
            double inHiFromMos = pmosTop + 2.0 + 2.5;
            double inHiY = Math.max(inHiFromVdd, inHiFromMos);
            TrackRouterH inHi = new TrackRouterH(tech.m1(), 3.0, inHiY, tech, inv);
            inHi.connect(inv.findExport("in"));
            for (int i3 = 0; i3 < pmos.nbGates(); ++i3) {
                inHi.connect(pmos.getGate(i3, 'T'));
            }
        }
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, inv);
        outHi.connect(inv.findExport("out"));
        for (int i4 = 1; i4 < pmos.nbSrcDrns(); i4 += 2) {
            outHi.connect(pmos.getSrcDrn(i4));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, inv);
        outLo.connect(inv.findExport("out"));
        for (int i5 = 1; i5 < nmos.nbSrcDrns(); i5 += 2) {
            outLo.connect(nmos.getSrcDrn(i5));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, inv);
        stdCell.addPmosWell(wellMinX, wellMaxX, inv);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, inv);
        stdCell.doNCC(inv, "inv{sch}");
        return inv;
    }
}

