/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.tool.user.ncc.CellEditor;
import com.sun.electric.tool.user.ncc.CellMouseMotionAdapter;
import com.sun.electric.tool.user.ncc.CellRenderer;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;

abstract class ExportTable
extends JTable
implements PropertyChangeListener,
ActionListener {
    static final int MAXROWS = 200;
    static final int WIDTHMARGIN = 11;
    static final int HEIGHTMARGIN = 16;
    static final int LINEHEIGHT = 17;
    static final int SCRLBARHEIGHT = 17;
    static final int MAX_VISIBLE_LINES = 6;
    protected static final String RED = "red";
    protected static final String GREEN = "green";
    protected int height;
    protected int numCols;
    protected int[][] cellPrefHeights;
    protected int[][] cellPrefWidths;
    protected JPopupMenu cellPopup;
    protected String clipboard;
    protected NccGuiInfo result;

    public ExportTable(NccGuiInfo res, int cols) {
        this.result = res;
        this.numCols = cols;
    }

    protected void setup() {
        this.setDefaultRenderer(JScrollPane.class, new CellRenderer());
        this.setDefaultEditor(JScrollPane.class, new CellEditor());
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setGridColor(Color.GRAY);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseMotionListener(new CellMouseMotionAdapter());
        this.createCellPopup();
        this.cellPrefHeights = new int[this.height][this.numCols];
        this.cellPrefWidths = new int[this.height][this.numCols];
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                this.cellPrefHeights[row][col] = 16;
            }
        }
    }

    void adjustRowHeights() {
        int[] colWidth = new int[this.numCols];
        for (int col = 0; col < this.numCols; ++col) {
            colWidth[col] = this.getColumnModel().getColumn(col).getWidth();
        }
        for (int row = 0; row < this.height; ++row) {
            int oldHeight = this.getRowHeight(row);
            int newHeight = 0;
            int pref = 16;
            for (int col = 0; col < this.numCols; ++col) {
                pref = this.cellPrefHeights[row][col];
                if (colWidth[col] < this.cellPrefWidths[row][col]) {
                    pref += 17;
                }
                newHeight = Math.max(newHeight, pref);
            }
            if (newHeight == oldHeight) continue;
            this.setRowHeight(row, newHeight);
        }
        this.doLayout();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("width")) {
            this.adjustRowHeights();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(this.clipboard);
        cb.setContents(ss, ss);
    }

    protected void createCellPopup() {
        this.cellPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy Cell Text To Clipboard");
        menuItem.addActionListener(this);
        this.cellPopup.add(menuItem);
    }
}

