#!/bin/sh
#
#   EDMA: Entorno de Desarrollo Modular y Abierto
#   Object Oriented and Componentware Framework  
#
#   Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
#             by David Martínez Oliveira
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

BASEDIR=/usr/local
EXT=so

export EDMA_SYSTEM_PATH=${BASEDIR}
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH}:${EDMA_SYSTEM_PATH}/lib
export PATH=${PATH}:${EDMA_SYSTEM_PATH}/bin

# Start emerald daemon

./src/sally --daemon

FILES=$(cat class_list.lst)
TEST_FILES=$(cat class_test_list.lst)
EX_FILES=$(cat class_ex_list.lst)

# Install GNU/EDMA base classes
for i in $FILES
do
	LD_PRELOAD=${BASEDIR}/lib/libEDMA.${EXT} ${BASEDIR}/bin/ines_class_register $i
done

# Install GNU/EDMA Example classes
REPO_DIR=${BASEDIR}/share/
REPO_NAME=edma_examples.cfg

install -m 0666 ${REPO_NAME} ${REPO_DIR}/.

for i in $EX_FILES
do
	ines_class_register --repo ${REPO_DIR} ${REPO_NAME} $i
done

# Install GNU/EDMA Test classes
REPO_DIR=${BASEDIR}/share/
REPO_NAME=edma_test.cfg

install -m 0666 ${REPO_NAME} ${REPO_DIR}/.

for i in $TEST_FILES
do
	ines_class_register --repo ${REPO_DIR} ${REPO_NAME} $i
done
