/* AMD pp. 285 - 289
 * Mixed model, balanced
 */

#include <dap.h>

void main()
{
  infile("amd285.dat", " ")
    {
      char machine[2], person[2], rep[2];
      double productivity, prod[3];
      int r;
      input("machine person prod");
      outset("amd285", "machine person rep productivity");
      rep[1] = '\0';
      skip(1);
      while (step())
        {
          for (r = 0; r < 3; r++)
            {
              rep[0] = '1' + r;
              productivity = prod[r];
              output();
            }
        }
    }
  sort("amd285", "machine person rep", "");
  
  means("amd285.srt", "productivity", "N MEAN VAR", "machine person");
  
  effects("amd285.srt.mns", "productivity machine person",
                          "machine person machine*person", "");
  
  ftest("amd285.srt.mns.con", "productivity machine person", "machine*person", "", "");
  
  ftest("amd285.srt.mns.con", "productivity machine person", "person", "machine*person", "");
  lsmeans("amd285.srt.mns.tst", "TUKEY", 0.05,
                  "productivity machine person", "person", "", "8.4");
  
  ftest("amd285.srt.mns.con", "productivity machine person", "machine", "machine*person", "");
  lsmeans("amd285.srt.mns.tst", "TUKEY", 0.05,
                  "productivity machine person", "machine", "", "8.4");
}
