/* LocaleInformation_so.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_so extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "KES";

  private static final String currenciesDisplayNameValues = "KES";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "KES";

  private static final String currenciesSymbolValues = "Ksh";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Kob",
    "Lab",
    "Sad",
    "Afr",
    "Sha",
    "Lix",
    "Tod",
    "Sid",
    "Sag",
    "Tob",
    "KIT",
    "LIT",
    null,
  };

  private static final String[] months = {
    "Bisha Koobaad",
    "Bisha Labaad",
    "Bisha Saddexaad",
    "Bisha Afraad",
    "Bisha Shanaad",
    "Bisha Lixaad",
    "Bisha Todobaad",
    "Bisha Sideedaad",
    "Bisha Sagaalaad",
    "Bisha Tobnaad",
    "Bisha Kow iyo Tobnaad",
    "Bisha Laba iyo Tobnaad",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Axa",
    "Isn",
    "Sal",
    "Arb",
    "Kha",
    "Jim",
    "Sab",
  };

  private static final String[] weekdays = {
    null,
    "Axad",
    "Isniin",
    "Salaaso",
    "Arbaco",
    "Khamiis",
    "Jimco",
    "Sabti",
  };

  private static final String[] eras = {
    "Ciise ka hor",
    "Ciise ka dib",
  };

  private static final String[] ampms = {
    "sn",
    "gn",
  };

  private static final String territoriesKeys = "AU|TD|AT|MZ|AO|MX|MW|GR|AM|ZA|MV|SY|MT|GN|MR|AF|AE|ML|MK|SO|GD|SL|MC|MA|SE|SD|SA|YE|LY|FR|LV|LU|LS|LR|RU|FI|LK|RO|LB|KZ|ET|ES|KW|KR|KP|EG|KH|KE|QA|JP|DK|PT|JO|DJ|JM|DE|PL|PK|VN|PH|VE|CU|VA|IT|IS|CN|IR|CM|IQ|CL|IN|CH|IL|US|OM|CA|IE|ID|UG|BR|NZ|HU|HR|TZ|BJ|BH|NO|BE|BD|ZW|TR|BB|BA|TN|NI|NG|ZM|TH|TG|NA";

  private static final String territoriesValues = "Awstraaliya|Jaad|Osteeriya|Musambiig|Angoola|Meksiko|Malaawi|Giriigga|Armeeniya|Koonfur Afrika|Maaldiqeen|Suuriya|Maalda|Gini|Muritaaniya|Afgaanistaan|Imaaraadka Carabta ee Midoobay|Maali|Makadooniya|Soomaaliya|Giriinaada|Siraaliyoon|Moonako|Marooko|Iswidhan|Sudaan|Sacuudi Carabiya|Yaman|Liibiya|Faransiis|Laatfiya|Luksemboorg|Losooto|Laybeeriya|Ruush|Fiinlaand|Siirilaanka|Rumaaniya|Lubnaan|Kasaakhistaan|Itoobiya|Isbeyn|Kuwayt|Kuuriyada Koonfureed|Kuuriyada Waqooyi|Masar|Kamboodiya|Kiiniya|Qadar|Jabbaan|Danmaark|Bortuqaal|Urdun|Jabuuti|Jameyka|Jarmal|Booland|Bakistaan|Fiyetnaam|Filibiin|Fenisuweela|Kuuba|Faatikaan|Talyaani|Iislaand|Shiinaha|Iiraan|Kameruun|Ciraaq|Jili|Hindiya|Swiiserlaand|Israa'iil|Qaramada Midoobey ee Maraykanka|Cumaan|Kanada|Ayrlaanda|Indoneesiya|Ugaanda|Braasiil|Neyuusilaand|Hangeri|Korweeshiya|Tansaaniya|Beniin|Baxrayn|Noorweey|Beljiyam|Bangaala-Deesh|Simbaabwe|Turki|Baarbadoos|Boosniya Heersigoviina|Tuniisiya|Nikaraaguwa|Nayjeeriya|Saambiya|Taylaand|Toogo|Namiibiya";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "so";

  private static final String languagesValues = "Soomaali";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "dd/MM/yy" },
    { "mediumDateFormat", "dd-MMM-yyyy" },
    { "longDateFormat", "dd MMMM yyyy" },
    { "fullDateFormat", "EEEE, MMMM dd, yyyy" },
    { "shortTimeFormat", "h:mm a" },
    { "mediumTimeFormat", "h:mm:ss a" },
    { "longTimeFormat", "h:mm:ss a" },
    { "fullTimeFormat", "h:mm:ss a" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
