/* LocaleInformation_dz.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_dz extends ListResourceBundle
{
  private static final String[] shortMonths = {
    "\u0f5f\u0fb3\u0f0b \u0f21",
    "\u0f5f\u0fb3\u0f0b \u0f22",
    "\u0f5f\u0fb3\u0f0b \u0f23",
    "\u0f5f\u0fb3\u0f0b \u0f24",
    "\u0f5f\u0fb3\u0f0b \u0f25",
    "\u0f5f\u0fb3\u0f0b \u0f26",
    "\u0f5f\u0fb3\u0f0b \u0f27",
    "\u0f5f\u0fb3\u0f0b \u0f28",
    "\u0f5f\u0fb3\u0f0b \u0f29",
    "\u0f5f\u0fb3\u0f0b \u0f21\u0f20",
    "\u0f5f\u0fb3\u0f0b \u0f21\u0f21",
    "\u0f5f\u0fb3\u0f0b \u0f21\u0f22",
    null,
  };

  private static final String[] months = {
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f51\u0f44\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f42\u0f49\u0f72\u0f66\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f42\u0f66\u0f74\u0f58\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f56\u0f5e\u0f72\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f63\u0f94\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f51\u0fb2\u0f74\u0f42\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f56\u0f51\u0f74\u0f53\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f56\u0f62\u0f92\u0fb1\u0f51\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f51\u0f42\u0f74\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f56\u0f45\u0f74\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f56\u0f45\u0f74\u0f0b\u0f42\u0f45\u0f72\u0f42\u0f0b\u0f54\u0f0b",
    "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f5f\u0fb3\u0f5d\u0f0b\u0f56\u0f45\u0f74\u0f0b\u0f42\u0f49\u0f72\u0f66\u0f0b\u0f54\u0f0b",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u0f5f\u0fb3\u0f0b",
    "\u0f58\u0f72\u0f62\u0f0b",
    "\u0f63\u0fb7\u0f42\u0f0b",
    "\u0f55\u0f74\u0f62\u0f0b",
    "\u0f66\u0f44\u0f66\u0f0b",
    "\u0f66\u0fa4\u0f7a\u0f53\u0f0b",
    "\u0f49\u0f72\u0f0b",
  };

  private static final String[] weekdays = {
    null,
    "\u0f42\u0f5f\u0f60\u0f0b\u0f5f\u0fb3\u0f0b\u0f56\u0f0b",
    "\u0f42\u0f5f\u0f60\u0f0b\u0f58\u0f72\u0f42\u0f0b\u0f51\u0f58\u0f62\u0f0b",
    "\u0f42\u0f5f\u0f60\u0f0b\u0f63\u0fb7\u0f42\u0f0b\u0f54\u0f0b",
    "\u0f42\u0f5f\u0f60\u0f0b\u0f55\u0f74\u0f62\u0f0b\u0f56\u0f74\u0f0b",
    "\u0f42\u0f5f\u0f60\u0f0b\u0f54\u0f0b\u0f66\u0f44\u0f66\u0f0b",
    "\u0f42\u0f5f\u0f60\u0f0b\u0f66\u0fa4\u0f7a\u0f53\u0f0b\u0f54\u0f0b",
    "\u0f42\u0f5f\u0f60\u0f0b\u0f49\u0f72\u0f0b\u0f58\u0f0b",
  };

  private static final String[] ampms = {
    "\u0f66\u0f94\u0f0b\u0f46\u0f0b",
    "\u0f55\u0fb1\u0f72\u0f0b\u0f46\u0f0b",
  };

  private static final String[][] zoneStrings =
  {
    { "BST", "Bhutan Standard Time", "BST", "Bhutan Standard Time",  "Asia/Thimphu" },
  };

  private static final String territoriesKeys = "PT|JP|PS|DK|JM|MN|AF|MM|AE|DE|PK|VN|GB|SI|SE|CZ|PA|SA|CU|IT|FR|IS|UZ|IR|CN|IQ|IN|IL|CH|US|FI|LK|IE|CA|LB|LA|BT|NZ|BR|KW|ES|KR|TW|KP|NP|BH|ZW|NO|HK|EG|BE|NL|BD|KH|KE|TJ|ZM|TH|QA|AU|AT|AR|MY|AQ|ZA|MX|MV|GR|MU|MS";

  private static final String territoriesValues = "\u0f54\u0f7c\u0f62\u0f0b\u0f45\u0f74\u0f0b\u0f42\u0f63|\u0f47\u0f0b\u0f54\u0f71\u0f53|\u0f54\u0f7a\u0f0b\u0f63\u0f72\u0f66\u0f72\u0f0b\u0f4a\u0f72\u0f0b\u0f53\u0f72\u0f61 \u0f53\u0f0b\u0f4a\u0f7a\u0f0b\u0f62\u0f72\u0f0b\u0f44\u0f7c\u0f0b\u0f62\u0f72|\u0f4c\u0f7a\u0f53\u0f0b\u0f58\u0f71\u0f40|\u0f47\u0f0b\u0f58\u0f60\u0f72\u0f0b\u0f40|\u0f66\u0f7c\u0f42\u0f0b\u0f54\u0f7c|\u0f68\u0f55\u0f0b\u0f42\u0f0b\u0f53\u0f72\u0f66\u0f72\u0f0b\u0f4f\u0f71\u0f53|\u0f58\u0f7a\u0f0b\u0f58\u0f62|\u0f61\u0f74\u0f0b\u0f53\u0f60\u0f72\u0f0b\u0f4a\u0f7a\u0f4a\u0f0b\u0f68\u0f0b\u0f62 \u0f56\u0f0b\u0f68\u0f7a\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f7a\u0f4a\u0f66\u0f72|\u0f47\u0f71\u0f62\u0f0b\u0f58\u0f0b\u0f53\u0f72|\u0f54\u0f0b\u0f40\u0f72\u0f66\u0f72\u0f0b\u0f4f\u0f71\u0f53|\u0f56\u0f7a\u0f4a\u0f0b\u0f53\u0f71\u0f58|\u0f61\u0f74\u0f0b\u0f53\u0f60\u0f72\u0f0b\u0f4a\u0f7a\u0f4a\u0f0b\u0f40\u0f72\u0f44\u0f0b\u0f4c\u0f58|\u0f66\u0f72\u0f63\u0f7c\u0f0b\u0f56\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f61|\u0f66\u0f74\u0f60\u0f72\u0f0b\u0f4c\u0f53|\u0f45\u0f7a\u0f40\u0f0b\u0f62\u0f72\u0f0b\u0f54\u0f56\u0f0b\u0f63\u0f72\u0f40|\u0f54\u0f0b\u0f53\u0f0b\u0f58\u0f71|\u0f66\u0f60\u0f74\u0f0b\u0f51\u0f72\u0f0b\u0f68\u0f7a\u0f0b\u0f62\u0f0b\u0f66 \u0fa6\u0f72\u0f0b\u0f61|\u0f40\u0f72\u0f60\u0f74\u0f0b\u0f66\u0fa6|\u0f68\u0f80\u0f4a\u0f0b\u0f63\u0f72|\u0f55\u0f62\u0f71\u0f53\u0f66\u0f72|\u0f68\u0f60\u0f72\u0f66\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c|\u0f68\u0f74\u0f5b\u0f0b\u0f56\u0f7a\u0f0b\u0f40\u0f72\u0f66\u0f72\u0f0b\u0f4f\u0f71\u0f53|\u0f68\u0f72\u0f0b\u0f62\u0f71\u0f53|\u0f62\u0f92\u0fb1\u0f0b\u0f58\u0f72|\u0f68\u0f72\u0f0b\u0f62\u0f40|\u0f62\u0f92\u0fb1\u0f0b\u0f42\u0f62|\u0f68\u0f72\u0f5b\u0f0b\u0f62\u0f71\u0f7a\u0f63|\u0f66\u0f74\u0f60\u0f72\u0f4a\u0f0b\u0f5b\u0f62\u0f0b\u0f63\u0f7a\u0f53|\u0f61\u0f74\u0f0b\u0f53\u0f60\u0f72\u0f4a\u0f7a\u0f4a\u0f0b\u0f66\u0f72\u0f0b\u0f4a\u0f7a\u0f66\u0f72|\u0f55\u0f72\u0f53\u0f0b\u0f63\u0f7a\u0f53\u0f4c|\u0f64\u0fb2\u0f71\u0f80\u0f0b\u0f63\u0f44\u0f40|\u0f68\u0f60\u0f72\u0f62\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c|\u0f40\u0f7a\u0f0b\u0f53\u0f0b\u0f4c|\u0f63\u0f7a\u0f0b\u0f56\u0f71\u0f0b\u0f53\u0f71\u0f7c\u0f53|\u0f63\u0f0b\u0f60\u0f7c\u0f66\u0f74|\u0f60\u0f56\u0fb2\u0f74\u0f42|\u0f53\u0f72\u0f60\u0f74\u0f0b\u0f5b\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c|\u0f56\u0f71\u0f62\u0f71\u0f0b\u0f5b\u0f72\u0f63|\u0f40\u0f74\u0f0b\u0f5d\u0f7a\u0f4a|\u0f66\u0f72\u0f54\u0f71\u0f7a\u0f53|\u0f63\u0fb7\u0f7c\u0f0b\u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61|\u0f4f\u0f60\u0f72\u0f0b\u0f5d\u0f71\u0f53|\u0f56\u0fb1\u0f44\u0f0b\u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61|\u0f56\u0f63\u0f0b\u0f61\u0f74\u0f63|\u0f56\u0f67\u0f0b\u0f62\u0f7a\u0f53|\u0f5b\u0f72\u0f58\u0f0b\u0f56\u0f56\u0f0b\u0f5d\u0f7a|\u0f53\u0f7c\u0f0b\u0f5d\u0f7a|\u0f67\u0f7c\u0f44\u0f0b\u0f40\u0f7c\u0f44|\u0f68\u0f72\u0f0b\u0f47\u0f72\u0f54\u0f4a|\u0f56\u0f7a\u0f63\u0f0b\u0f47\u0f72\u0f61\u0f58|\u0f53\u0f7a\u0f0b\u0f51\u0f62\u0f0b\u0f63\u0f7a\u0f53\u0f4c\u0f66\u0f72|\u0f56\u0f44\u0f92\u0f0b\u0f63\u0f0b\u0f51\u0f7a\u0f64|\u0f40\u0f58\u0f0b\u0f56\u0f7c\u0f0b\u0f4c\u0f72\u0f0b\u0f61|\u0f40\u0f7a\u0f0b\u0f53\u0f72\u0f0b\u0f61|\u0f4f\u0f0b\u0f47\u0f42\u0f0b\u0f40\u0f72\u0f66\u0f72\u0f0b\u0f4f\u0f71\u0f53|\u0f5b\u0f58\u0f0b\u0f56\u0f72\u0f0b\u0f61|\u0f50\u0f71\u0f60\u0f72\u0f0b\u0f63\u0f7a\u0f53\u0f4c|\u0f40\u0f0b\u0f4f\u0f62|\u0f68\u0f66\u0f0b\u0f4a\u0f7a\u0f61\u0f7a\u0f0b\u0f63\u0f72\u0f0b\u0f61|\u0f68\u0f66\u0f0b\u0f4a\u0f72\u0f0b\u0f61|\u0f68\u0f62\u0f0b\u0f47\u0f7a\u0f53\u0f0b\u0f4a\u0f72\u0f0b\u0f53|\u0f58\u0f0b\u0f63\u0f7a\u0f0b\u0f64\u0f72\u0f0b\u0f61|\u0f68\u0f7a\u0f53\u0f0b\u0f4a\u0f71\u0f42\u0f0b\u0f4a\u0f72\u0f0b\u0f40|\u0f66\u0f60\u0f74\u0f50\u0f0b\u0f68\u0f55\u0f0b\u0f62\u0f72\u0f0b\u0f40|\u0f58\u0f7a\u0f40\u0f66\u0f72\u0f0b\u0f40\u0f7c|\u0f58\u0f71\u0f63\u0f0b\u0f4c\u0f72\u0f56\u0f66|\u0f42\u0f72\u0f62\u0f72\u0f66\u0f72|\u0f58\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f64\u0f72\u0f61\u0f66\u0f72|\u0f58\u0f7c\u0f53\u0f0b\u0f66\u0f0b\u0f62\u0f4a\u0f72";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ne|th|new|te|dz|zh|ta|dv|as|ar|my|mr|mn|ml|de|pi|da|art|si|ga|mni|egy|pa|mnc|sa|cs|it|fr|him|ru|or|lo|ur|fa|grc|es|bo|bn|ks|en|el|inc|ko|kn|bh|no|km|hi|nl|he";

  private static final String languagesValues = "\u0f53\u0f7a\u0f0b\u0f54\u0f0b\u0f63\u0f72|\u0f50\u0f71\u0f60\u0f7a|\u0f53\u0f72\u0f0b\u0f5d\u0f0b\u0f62\u0f72|\u0f4f\u0f7a\u0f0b\u0f63\u0f74\u0f0b\u0f42\u0f74|\u0f62\u0fab\u0f7c\u0f44\u0f0b\u0f41|\u0f62\u0f42\u0fb1\u0f0b\u0f58\u0f72\u0f0b\u0f41|\u0f4f\u0f0b\u0f58\u0f72\u0f63|\u0f51\u0f72\u0f0b\u0f56\u0f7a\u0f0b\u0f67\u0f72|\u0f68\u0f0b\u0f66\u0f0b\u0f58\u0f72\u0f0b\u0f66\u0f72|\u0f68\u0f7a\u0f0b\u0f62\u0f0b\u0f66\u0fa6\u0f72\u0f42|\u0f56\u0f62\u0f0b\u0f58\u0f72\u0f66\u0f72|\u0f58\u0f0b\u0f62\u0f0b\u0f50\u0f72|\u0f66\u0f7c\u0f42\u0f0b\u0f54\u0f7c\u0f60\u0f72\u0f0b\u0f41|\u0f58\u0f0b\u0f63\u0f0b\u0f61\u0f0b\u0f63\u0f58|\u0f47\u0f71\u0f62\u0f0b\u0f58\u0f71\u0f53|\u0f54\u0f0b\u0f63\u0f72|\u0f4c\u0f7a\u0f0b\u0f53\u0f72\u0f64|\u0f56\u0f5f\u0f7c\u0f0b\u0f56\u0f5f\u0f7c\u0f5d (\u0f42\u0f5e\u0f53)|\u0f66\u0f72\u0f53\u0f0b\u0f67\u0f0b\u0f63\u0f72\u0f66\u0f72|\u0f68\u0f60\u0f72\u0f0b\u0f62\u0f72\u0f64|\u0f58\u0f0b\u0f53\u0f72\u0f0b\u0f54\u0f74\u0f0b\u0f62\u0f72|\u0f68\u0f72\u0f0b\u0f47\u0f72\u0f54\u0f0b\u0f64\u0f71\u0f53 (\u0f66\u0f94\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f40\u0fb1\u0f72)|\u0f54\u0f71\u0f53\u0f0b\u0f47\u0f0b\u0f56\u0f72|\u0f58\u0f71\u0f53\u0f0b\u0f45\u0f74|\u0f66\u0f7e\u0f66\u0f90\u0fb2\u0f80\u0f4f|\u0f45\u0f7a\u0f40|\u0f68\u0f72\u0f0b\u0f4a\u0f0b\u0f63\u0f72\u0f0b\u0f62\u0f53|\u0f55\u0f7a\u0f0b\u0f62\u0f7a\u0f53\u0f46\u0f7a|\u0f67\u0f72\u0f0b\u0f58\u0f0b\u0f45\u0f0b\u0f63\u0f72|\u0f62\u0f0b\u0f64\u0f72\u0f0b\u0f61\u0f53|\u0f68\u0f7c\u0f0b\u0f62\u0f72\u0f0b\u0f61|\u0f63\u0f60\u0f7c|\u0f68\u0f74\u0f62\u0f0b\u0f51\u0f74|\u0f54\u0f62\u0f0b\u0f64\u0f72\u0f0b\u0f61\u0f53|\u0f42\u0f72\u0f62\u0f72\u0f40, \u0f66\u0f94\u0f0b\u0f51\u0f74\u0f66\u0f0b\u0f40\u0fb1\u0f72 (\u0f21\u0f24\u0f25\u0f23)|\u0f66\u0f72\u0f54\u0f7a\u0f0b\u0f53\u0f72\u0f64|\u0f56\u0f7c\u0f51\u0f0b\u0f41|\u0f56\u0f7a\u0f44\u0f92\u0f0b\u0f63\u0f72|\u0f40\u0f7a\u0f64\u0f0b\u0f58\u0f72\u0f0b\u0f62\u0f72|\u0f68\u0f72\u0f44\u0f0b\u0f63\u0f72\u0f64|\u0f42\u0f72\u0f62\u0f72\u0f40|\u0f68\u0f72\u0f53\u0f0b\u0f4c\u0f72\u0f40 (\u0f42\u0f5e\u0f53)|\u0f40\u0f7c\u0f0b\u0f62\u0f72\u0f61\u0f53|\u0f40\u0f0b\u0f53\u0f0b\u0f4c|\u0f56\u0f72\u0f0b\u0f67\u0f0b\u0f63\u0f72|\u0f53\u0f7c\u0f62\u0f0b\u0f5d\u0f72\u0f0b\u0f47\u0f72\u0f0b\u0f61\u0f53|\u0f41\u0f7a\u0f0b\u0f58\u0f62|\u0f67\u0f72\u0f53\u0f0b\u0f51\u0f72|\u0f4c\u0f46|\u0f67\u0f72\u0f0b\u0f56\u0f74\u0f62\u0f74";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "ampms", ampms },
    { "shortDateFormat", "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f63\u0f7c\u0f0b yyyy \u0f5f\u0fb3\u0f0b MMM \u0f5a\u0f7a\u0f66\u0f0b dd" },
    { "mediumDateFormat", "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f63\u0f7c\u0f0byyyy \u0f5f\u0fb3\u0f0b MMM \u0f5a\u0f7a\u0f66\u0f0b dd" },
    { "longDateFormat", "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f63\u0f7c\u0f0byyyy \u0f5f\u0fb3\u0f0b MMMM \u0f5a\u0f7a\u0f66\u0f0b dd" },
    { "fullDateFormat", "\u0f66\u0fa4\u0fb1\u0f72\u0f0b\u0f63\u0f7c\u0f0byyyy \u0f5f\u0fb3\u0f0b MMMM \u0f5a\u0f7a\u0f66\u0f0b dd" },
    { "shortTimeFormat", "\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51\u0f0b h \u0f66\u0f90\u0f62\u0f0b\u0f58\u0f0b mm a" },
    { "mediumTimeFormat", "\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51\u0f0bh:mm:ss a" },
    { "longTimeFormat", "\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51\u0f0b h \u0f66\u0f90\u0f62\u0f0b\u0f58\u0f0b mm \u0f66\u0f90\u0f62\u0f0b\u0f46\u0f71\u0f0b ss a zzz" },
    { "fullTimeFormat", "\u0f46\u0f74\u0f0b\u0f5a\u0f7c\u0f51\u0f0b h \u0f66\u0f90\u0f62\u0f0b\u0f58\u0f0b mm \u0f66\u0f90\u0f62\u0f0b\u0f46\u0f71\u0f0b ss a zzzz" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
