// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
#include "driver.h"

#include <pthread.h>

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

bool VPBTrunk::dialHandler(TrunkEvent *event)
{
	int rtn;
	VPB_CALL cpp;
	VPB_DETECT toned;
	const char *dp;

	switch(event->id)
	{
	case TRUNK_CPA_NODIALTONE:
	case TRUNK_CPA_FAILURE:
		endTimer();
		setSymbol(SYM_TONE, "fail");
		if(!trunkSignal(TRUNK_SIGNAL_CANCEL))
			if(!trunkSignal(TRUNK_SIGNAL_TONE))
				trunkSignal(TRUNK_SIGNAL_STEP);
		event->id = TRUNK_TIMER_EXPIRED;
		return false;
	case TRUNK_CPA_NORINGBACK:
		setSymbol(SYM_TONE, "silence");
		if(!trunkSignal(TRUNK_SIGNAL_SILENCE))
			trunkSignal(TRUNK_SIGNAL_STEP);
		event->id = TRUNK_TIMER_EXPIRED;
		return false;
	case TRUNK_CPA_NOANSWER:
		endTimer();
		setSymbol(SYM_TONE, "ring");
		if(!trunkSignal(TRUNK_SIGNAL_NOANSWER))
			trunkSignal(TRUNK_SIGNAL_STEP);
		event->id = TRUNK_TIMER_EXPIRED;
		return false;
	case TRUNK_CPA_BUSYTONE:
		endTimer();
		setSymbol(SYM_TONE, "busy");
		if(!trunkSignal(TRUNK_SIGNAL_BUSY))
			if(!trunkSignal(TRUNK_SIGNAL_TONE))
				trunkSignal(TRUNK_SIGNAL_STEP);
		event->id = TRUNK_TIMER_EXPIRED;
		return false;
	case TRUNK_ENTER_STATE:
		enterState("dial");
		status[id] = 'd';
		flags.offhook = true;
		setSymbol(SYM_TONE, "none");

		// DR 3/10/01 switch DTMF detection off while dialing to
		// prevent outbound digits being detected
		vpb_disable_event(handle, VPB_MDTMF);

		if(data.dialxfer.timeout)
		{
			// reset dialtone detect
			vpb_gettonedet(handle, VPB_DIAL, &toned);
 	                vpb_settonedet(handle, &toned);

                	vpb_get_call(handle, &cpp);
			dp = group->getLast("noringback");
			if(dp)
				cpp.ringback_timeout = getMSTimeout(dp);
			else
	                	cpp.ringback_timeout = 8000;
			dp = group->getLast("cpringback");
			if(dp)
				cpp.inter_ringback_timeout = getMSTimeout(dp);
			else
	                	cpp.inter_ringback_timeout = 4000;
                	cpp.answer_timeout = data.dialxfer.timeout;
                	vpb_set_call(handle, &cpp);
                	rtn = vpb_call_async(handle, data.dialxfer.digits);
		}
		else
			rtn = vpb_dial_async(handle, data.dialxfer.digits);

		if(rtn)
		{
			setSymbol(SYM_ERROR, "dial-failed");
			if(!trunkSignal(TRUNK_SIGNAL_ERROR))
				trunkSignal(TRUNK_SIGNAL_STEP);				

			handler = &VPBTrunk::stepHandler;
		}

		// setTimer(data.dialxfer.timeout);
		// thread = new VPBDialer(this, handle);
		// thread->start();
		return true;

	case TRUNK_EXIT_STATE:
		if(data.dialxfer.timeout)
			return false;
	case TRUNK_SERVICE_SUCCESS:
		trunkSignal(TRUNK_SIGNAL_STEP);
	case TRUNK_STOP_STATE:
		vpb_enable_event(handle, VPB_MDTMF);
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_CPA_DIALTONE:
		return true;
	case TRUNK_CPA_REORDER:
		return true;
	}

	return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif






