%define _release 1
%define _version 1.0.11
%define _dsopath %{_libdir}/bayonne/%{_version}
%define __spec_install_post /usr/lib/rpm/brp-compress

Summary: bayonne - the telephony server of the GNU project
Name: bayonne
Version: %{_version}
Release: %{_release}
Group: Communications
URL: http://www.gnu.org/software/bayonne
Source: ftp://ftp.gnu.org/gnu/bayonne/bayonne-%{PACKAGE_VERSION}.tar.gz
Prefix: %{_prefix}
Vendor: Open Source Telecom
Copyright: GPL
BuildRoot: %{_tmppath}/bayonne-root
Packager: David Sugar <dyfet@ostel.com>

%description
Bayonne offers a script programmable modular server for deploying
multi-line telephony voice response and computer telephony applications.

%package Russian
Summary: bayonne-Russian - voice library for Russian speakers
Group: Communications
Requires: bayonne

%package UsEng
Summary: bayonne-UsEng - voice library for US English speakers
Group: Communications
Requires: bayonne

%package French
Summary: bayonne-French - international voice library for French
Group: Communications
Requires: bayonne

%package Italian
Summary: bayonne-Italian - voice library for Italian speakers
Group: Communications
Requires: bayonne

%package Bengali
Summary: bayonne-Bengali - voice library for Bengali speakers
Group: Communications
Requires: bayonne

%package sunrpc
Summary: bayonne bindings and libs for sun rpc services
Group: Communications
Requires: bayonne

%description sunrpc
This provides sunrpc services for use with a Bayonne server.

%description UsEng
The US English speaker library offers default voice prompts
for the Bayonne telephony server.

%description French
The French international speaker library offers default French
language voice prompts for the Bayonne telephony server.  Contributed
by Mariza Nicole and Wilane Ousmane.

%description Russian
The Russuan language speaker library offers default Russian language voice 
prompts for the Bayonne telephony server.  Contributed by Dmitry Krasnov
and Natalia Pacyuk.

%description Italian
The Italian language speaker library offers default Italian language voice
promots for the Bayonne telephony server.  Contributed by Wireless
Solutions SpA and under the GPL.

%description Bengali
The Bengali language speaker library offers default Bengali language voice
prompts for the Bayonne telephony server.  Contributed by Abul Kalam
<abul_kalam@yahoo.com>.

%prep
rm -rf $RPM_BUILD_ROOT

%setup

# NOTE: in Common C++, compiler options are retreived from config.def
# and should not be overriden here!

./configure --prefix=%{_prefix} --without-unsafe

%build
uname -a|grep SMP && make -j 2 || make

%install
mkdir -p $RPM_BUILD_ROOT/var/bayonne
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/%{_prefix}/bin
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man3
make prefix=$RPM_BUILD_ROOT/%{_prefix} etc_prefix=$RPM_BUILD_ROOT/etc \
	mandir=$RPM_BUILD_ROOT/%{_mandir} etc_suffix="" install
make prefix=$RPM_BUILD_ROOT/%{_prefix} \
	mandir=$RPM_BUILD_ROOT/%{_mandir} man

%files
%defattr(-,root,root)
%doc AUTHORS COPYING NEWS README TODO ChangeLog BAYONNE.FAQ
%doc doc/manual.*
%config %attr(0640,bayonne,bayonne) /etc/bayonne.conf
%config %attr(0640,bayonne,bayonne) /etc/bayonne.sched
%dir %{_datadir}/aaprompts
/etc/rc.d/init.d/bayonne
%{_mandir}/man8/bayonne.8*
%{_mandir}/man3/*.3cc*
%{_prefix}/libexec/bayonne
%{_dsopath}
%{_prefix}/include/cc++/bayonne.h
%{_datadir}/aascripts
%{_prefix}/sbin/bayonne
%{_prefix}/sbin/bayonne_policy
%{_prefix}/sbin/bayonne_apache
%{_prefix}/sbin/bayonne_setup
%{_prefix}/sbin/bayonne_admin
%{_prefix}/sbin/bayonne_start
%{_prefix}/bin/bayonne_install
%{_prefix}/bin/bayonne_control
%{_prefix}/bin/bayonne_down
%{_prefix}/bin/bayonne_status
%{_prefix}/bin/bayonne_update
%{_datadir}/aaprompts/sys
%attr(06755,root,root) %{_prefix}/bin/bayonne_wrapper
%attr(0770,bayonne,bayonne) /var/bayonne

%files sunrpc
%{_prefix}/include/rpcsvc/bayonne.x
%{_prefix}/include/rpcsvc/bayonne.h
%{_libdir}/libbayonnerpc.*

%files UsEng
%defattr(-,root,root)
%{_datadir}/aaprompts/UsEngM
%{_datadir}/aaprompts/UsEngF

%files French
%defattr(-,root,root)
%{_datadir}/aaprompts/FrenchM
%{_datadir}/aaprompts/FrenchF

%files Russian
%defattr(-,root,root)
%{_datadir}/aaprompts/RussianM
%{_datadir}/aaprompts/RussianF

%files Italian
%defattr(-,root,root)
%{_datadir}/aaprompts/ItalianM
%{_datadir}/aaprompts/ItalianF

%files Bengali
%defattr(-,root,root)
%{_datadir}/aaprompts/BengaliM

%clean
rm -rf $RPM_BUILD_ROOT

%pre
grep '^bayonne:' /etc/passwd >/dev/null || /usr/sbin/adduser -r bayonne

%post
/sbin/chkconfig bayonne reset
if test -d /etc/httpd ; then /usr/sbin/bayonne_apache ; fi

%preun
/etc/rc.d/init.d/bayonne stop
/sbin/chkconfig --level 0123456 bayonne off

%changelog
* Sat Apr 21 2001 David Sugar <dyfet@ostel.com> 0.5-5
- merged driver and bayonne package to simplify install.
- bayonne manual

* Tue Jul 25 2000 David Sugar <dyfet@ostel.com> 0.4-3
- added changes suggested by Lenny Cartier <lenny@mandrakesoft.com>.
- made into a relocatable package.

* Wed Mar 27 2000 David Sugar <dyfet@ostel.com> 0.5-4
- added userid management to create Bayonne user.
- changed config file ownership to bayonne.

