(define (block-row-aux x y width type)
  (if (> width 0)
    (begin
      (level-add-block x y type)
      (block-row-aux (+ x (get-block-type-width type)) y 
                     (- width 1) type))))

(define (block-row x y width type)
  (block-row-aux x y width type))

(define (block-rect-aux x y width height type)
  (if (> height 0)
    (begin
      (block-row x y width type)
      (block-rect-aux x (+ y (get-block-type-height type)) 
                        width (- height 1) type))))

(define (block-rect x y width height type)
  (block-rect-aux x y width height type))

(define (block-spaced-row-aux x y width space type)
  (if (> width 0)
    (begin
      (level-add-block x y type)
      (block-spaced-row-aux (+ x space) y 
                     (- width 1) space type))))

(define (block-spaced-row x y width space type)
  (block-spaced-row-aux x y width space type))

(define (block-spaced-rect-aux x y width height xspace yspace type)
  (if (> height 0)
    (begin
      (block-spaced-row x y width xspace type)
      (block-spaced-rect-aux x (+ y yspace) 
                        width (- height 1) xspace yspace type))))

(define (block-spaced-rect x y width height xspace yspace type)
  (block-spaced-rect-aux x y width height xspace yspace type))

