untrusted comment: verify with openbsd-74-base.pub
RWRoyQmAD08ajcXNlno8mTIw7unrBjvHapVQjvo1+lHZEXLMGX/q49a8IFffBoRx01Cv2bwBL2yjb9FnnC4A/fmL8cxEPsdJ3As=

OpenBSD 7.4 errata 014, February 29, 2024:

vmm(4) did not restore GDTR limits properly on Intel (VMX) CPUs.

Apply by doing:
    signify -Vep /etc/signify/openbsd-74-base.pub -x 014_vmm.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/vmm_machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/vmm_machdep.c,v
diff -u -p -r1.8.2.1 vmm_machdep.c
--- sys/arch/amd64/amd64/vmm_machdep.c	10 Dec 2023 00:30:01 -0000	1.8.2.1
+++ sys/arch/amd64/amd64/vmm_machdep.c	28 Feb 2024 00:43:22 -0000
@@ -3954,9 +3954,8 @@ vcpu_run_vmx(struct vcpu *vcpu, struct v
 	struct schedstate_percpu *spc;
 	struct vmx_invvpid_descriptor vid;
 	uint64_t eii, procbased, int_st;
-	uint16_t irq, ldt_sel;
+	uint16_t irq;
 	u_long s;
-	struct region_descriptor idtr;
 
 	rw_assert_wrlock(&vcpu->vc_lock);
 
@@ -4169,9 +4168,6 @@ vcpu_run_vmx(struct vcpu *vcpu, struct v
 			break;
 		}
 
-		sidt(&idtr);
-		sldt(&ldt_sel);
-
 		TRACEPOINT(vmm, guest_enter, vcpu, vrp);
 
 		/* Restore any guest PKRU state. */
@@ -4189,8 +4185,14 @@ vcpu_run_vmx(struct vcpu *vcpu, struct v
 			wrpkru(PGK_VALUE);
 		}
 
-		lidt(&idtr);
-		lldt(ldt_sel);
+		/*
+		 * VM exit restores the GDT and IDT bases, but gives
+		 * them high limits.  Reload with the correct limits here.
+		 * 'gdt' is set above first time through and reset there
+		 * whenever this thread switches CPU.
+		 */
+		bare_lgdt(&gdt);
+		cpu_init_idt();
 
 		/*
 		 * On exit, interrupts are disabled, and we are running with
