untrusted comment: verify with openbsd-65-base.pub
RWSZaRmt1LEQT5jdy/6F3qFgmPxEWw3eQZqiJzKgTRVSrIGKqbq0+NbVNzDOEGVRWEPX82FNqP8Ij+v5yudzLa92hbpKp4B4RQk=

OpenBSD 6.5 errata 034, April 7, 2020:

dhcpd could reference freed memory after releasing a lease with
an unusually long uid.

Apply by doing:
    signify -Vep /etc/signify/openbsd-65-base.pub -x 034_dhcpd.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install dhcpd:
    cd /usr/src/usr.sbin/dhcpd
    make clean
    make
    make install

Index: usr.sbin/dhcpd/memory.c
===================================================================
RCS file: /cvs/src/usr.sbin/dhcpd/memory.c,v
diff -u -p -r1.28 memory.c
--- usr.sbin/dhcpd/memory.c	13 Feb 2017 23:04:05 -0000	1.28
+++ usr.sbin/dhcpd/memory.c	5 Apr 2020 17:15:44 -0000
@@ -502,7 +502,8 @@ supersede_lease(struct lease *comp, stru
 			uid_hash_delete(comp);
 			enter_uid = 1;
 			if (comp->uid != &comp->uid_buf[0]) {
-				free(comp->uid);
+				if (comp->uid != lease->uid)
+					free(comp->uid);
 				comp->uid_max = 0;
 				comp->uid_len = 0;
 			}
