untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ4cryj2ELe5IomTbKgPI18JZme4WueuBAnf/RdLPRg5Vj+pm63Jws8zy4u+6NuDYKZwoNVMYrQBTzpkqsiebGAo=

OpenBSD 6.0 errata 027, June 12, 2017:

Fix an integer overflow in two range checks of the sti(4) display driver.
This issue only affects the hppa architecture.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 027_sti.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/ic/sti.c
===================================================================
RCS file: /cvs/src/sys/dev/ic/sti.c,v
retrieving revision 1.77
diff -u -p -r1.77 sti.c
--- sys/dev/ic/sti.c	9 Sep 2015 18:23:39 -0000	1.77
+++ sys/dev/ic/sti.c	11 Jun 2017 02:32:04 -0000
@@ -1130,7 +1130,7 @@ sti_ioctl(void *v, u_long cmd, caddr_t d
 		cmapp = (struct wsdisplay_cmap *)data;
 		idx = cmapp->index;
 		count = cmapp->count;
-		if (idx >= STI_NCMAP || idx + count > STI_NCMAP)
+		if (idx >= STI_NCMAP || count > STI_NCMAP - idx)
 			return EINVAL;
 		if ((ret = copyout(&scr->scr_rcmap[idx], cmapp->red, count)))
 			break;
@@ -1146,7 +1146,7 @@ sti_ioctl(void *v, u_long cmd, caddr_t d
 		cmapp = (struct wsdisplay_cmap *)data;
 		idx = cmapp->index;
 		count = cmapp->count;
-		if (idx >= STI_NCMAP || idx + count > STI_NCMAP)
+		if (idx >= STI_NCMAP || count > STI_NCMAP - idx)
 			return EINVAL;
 		if ((ret = copyin(cmapp->red, &scr->scr_rcmap[idx], count)))
 			break;
